/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import org.apache.taglibs.standard.resources.Resources;

public final class IteratedExpression {
    private static final long serialVersionUID = 1L;
    protected final ValueExpression orig;
    protected final String delims;
    private Object base;
    private int index;
    private Iterator iter;

    public IteratedExpression(ValueExpression orig, String delims) {
        this.orig = orig;
        this.delims = delims;
    }

    public Object getItem(ELContext context, int i) {
        if (this.base == null) {
            this.base = this.orig.getValue(context);
            if (this.base == null) {
                return null;
            }
            this.iter = this.toIterator(this.base);
            this.index = 0;
        }
        if (this.index > i) {
            this.iter = this.toIterator(this.base);
            this.index = 0;
        }
        while (this.iter.hasNext()) {
            Object item = this.iter.next();
            if (this.index++ != i) continue;
            return item;
        }
        return null;
    }

    public ValueExpression getValueExpression() {
        return this.orig;
    }

    private Iterator toIterator(Object obj) {
        Iterator iter;
        if (obj instanceof String) {
            iter = this.toIterator(new StringTokenizer((String)obj, this.delims));
        } else if (obj instanceof Iterator) {
            iter = (Iterator)obj;
        } else if (obj instanceof Collection) {
            iter = this.toIterator(((Collection)obj).iterator());
        } else if (obj instanceof Enumeration) {
            iter = this.toIterator((Enumeration)obj);
        } else if (obj instanceof Map) {
            iter = ((Map)obj).entrySet().iterator();
        } else {
            throw new ELException(Resources.getMessage("FOREACH_BAD_ITEMS"));
        }
        return iter;
    }

    private Iterator toIterator(final Enumeration obj) {
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return obj.hasMoreElements();
            }

            public Object next() {
                return obj.nextElement();
            }

            @Override
            public void remove() {
            }
        };
    }
}

