/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.configprovider.ConfigurationResourceProvider;
import com.sun.faces.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

public class WebResourceProvider
implements ConfigurationResourceProvider {
    private static final String WEB_INF_RESOURCE = "/WEB-INF/faces-config.xml";

    @Override
    public Collection<URL> getResources(ServletContext context) {
        URL webFacesConfig;
        WebConfiguration webConfig = WebConfiguration.getInstance(context);
        String paths = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.JavaxFacesConfigFiles);
        LinkedHashSet<URL> set = new LinkedHashSet<URL>(6);
        if (paths != null) {
            for (String token : Util.split(paths.trim(), ",")) {
                URL u;
                String path = token.trim();
                if (WEB_INF_RESOURCE.equals(path) || path.length() == 0 || (u = this.getContextURLForPath(context, path)) == null) continue;
                set.add(u);
            }
        }
        if ((webFacesConfig = this.getContextURLForPath(context, WEB_INF_RESOURCE)) != null) {
            set.add(webFacesConfig);
        }
        context.setAttribute("com.sun.faces.webresources", set);
        return set;
    }

    private URL getContextURLForPath(ServletContext context, String path) {
        try {
            return context.getResource(path);
        }
        catch (MalformedURLException mue) {
            throw new FacesException((Throwable)mue);
        }
    }
}

