/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.util.StringTokenizer;
import xjavadoc.AbstractClass;
import xjavadoc.AbstractExecutableMember;
import xjavadoc.AbstractType;
import xjavadoc.Util;
import xjavadoc.XClass;
import xjavadoc.XParameter;
import xjavadoc.XTag;

public final class ParameterImpl
extends AbstractType
implements XParameter {
    public static int instanceCount = 0;
    private AbstractExecutableMember _containingExecutableMember;
    private int _parameterIndex;
    private String _description;

    public ParameterImpl() {
        ++instanceCount;
    }

    @Override
    public final String getName() {
        return this._containingExecutableMember.getParameterName(this._parameterIndex);
    }

    @Override
    public final XClass getType() {
        String type = this._containingExecutableMember.getParameterType(this._parameterIndex);
        AbstractClass containingClass = this._containingExecutableMember.getContainingAbstractClass();
        XClass result = containingClass.qualify(type);
        return result;
    }

    @Override
    public final int getDimension() {
        return this._containingExecutableMember.getParameterDimension(this._parameterIndex);
    }

    @Override
    public XTag getParamTag() {
        for (XTag paramTag : this._containingExecutableMember.getDoc().getTags("param", true)) {
            StringTokenizer st = new StringTokenizer(paramTag.getValue());
            if (!st.hasMoreTokens() || !st.nextToken().equals(this.getName())) continue;
            this._description = paramTag.getValue().substring(this.getName().length()).trim();
            return paramTag;
        }
        this._description = null;
        return null;
    }

    @Override
    public String getDescription() {
        XTag paramTag = this.getParamTag();
        if (paramTag != null) {
            return this._description;
        }
        return null;
    }

    @Override
    public String getDimensionAsString() {
        return Util.appendDimensionAsString(this.getDimension(), new StringBuffer()).toString();
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer(this.getType().getQualifiedName());
        Util.appendDimensionAsString(this.getDimension(), sb).append(" ").append(this.getName());
        return sb.toString();
    }

    final void setState(AbstractExecutableMember containingExecutableMember, int parameterIndex) {
        this._containingExecutableMember = containingExecutableMember;
        this._parameterIndex = parameterIndex;
    }
}

