/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDeclaringClassUtil {
    static final boolean isIBMJVM;

    public static Class<?> getDeclaringClass(Class<?> clazz) {
        String name;
        int last;
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        Class<?> declaring = clazz.getDeclaringClass();
        if (declaring == null && isIBMJVM && (last = (name = clazz.getName()).lastIndexOf(36)) >= 0) {
            ClassLoader cl = GetDeclaringClassUtil.getClassLoader(clazz);
            while (declaring == null && last >= 0) {
                try {
                    declaring = cl.loadClass(clazz.getName().substring(0, last));
                }
                catch (ClassNotFoundException e) {
                    last = name.lastIndexOf(36, last - 1);
                }
            }
            if (declaring == null) {
                throw new RuntimeException("No declaring class could be determined for " + clazz.getName());
            }
        }
        return declaring;
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetClassLoaderAction.NON_PRIVILEGED.getClassLoader(clazz);
        }
        return GetClassLoaderAction.PRIVILEGED.getClassLoader(clazz);
    }

    private static String getSystemProperty(String key) {
        if (System.getSecurityManager() == null) {
            return GetSystemPropertyAction.NON_PRIVILEGED.getSystemProperty(key);
        }
        return GetSystemPropertyAction.PRIVILEGED.getSystemProperty(key);
    }

    static {
        String vendor = GetDeclaringClassUtil.getSystemProperty("java.vm.vendor");
        isIBMJVM = vendor.toUpperCase(Locale.ENGLISH).contains("IBM");
    }

    private static interface GetSystemPropertyAction {
        public static final GetSystemPropertyAction NON_PRIVILEGED = new GetSystemPropertyAction(){

            public String getSystemProperty(String key) {
                return System.getProperty(key);
            }
        };
        public static final GetSystemPropertyAction PRIVILEGED = new GetSystemPropertyAction(){

            public String getSystemProperty(final String key) {
                return AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(key);
                    }
                });
            }
        };

        public String getSystemProperty(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface GetClassLoaderAction {
        public static final GetClassLoaderAction NON_PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(Class<?> clazz) {
                return clazz.getClassLoader();
            }
        };
        public static final GetClassLoaderAction PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return clazz.getClassLoader();
                    }
                });
            }
        };

        public ClassLoader getClassLoader(Class<?> var1);
    }
}

