/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.client.WSPortInfo;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;

public class PortInfo
implements WSPortInfo {
    @NotNull
    private final WSServiceDelegate owner;
    @NotNull
    public final QName portName;
    @NotNull
    public final EndpointAddress targetEndpoint;
    @NotNull
    public final BindingID bindingId;
    @Nullable
    public final WSDLPort portModel;

    public PortInfo(WSServiceDelegate owner, EndpointAddress targetEndpoint, QName name, BindingID bindingId) {
        this.owner = owner;
        this.targetEndpoint = targetEndpoint;
        this.portName = name;
        this.bindingId = bindingId;
        this.portModel = this.getPortModel(owner, name);
    }

    public PortInfo(@NotNull WSServiceDelegate owner, @NotNull WSDLPort port) {
        this.owner = owner;
        this.targetEndpoint = port.getAddress();
        this.portName = port.getName();
        this.bindingId = port.getBinding().getBindingId();
        this.portModel = port;
    }

    public BindingImpl createBinding(WebServiceFeature[] webServiceFeatures, Class<?> portInterface) {
        WebServiceFeatureList r = new WebServiceFeatureList(webServiceFeatures);
        if (this.portModel != null) {
            r.mergeFeatures(this.portModel, portInterface == null, false);
        }
        for (WebServiceFeature wsf : this.owner.serviceInterceptor.preCreateBinding(this, portInterface, r)) {
            r.add(wsf);
        }
        BindingImpl bindingImpl = BindingImpl.create(this.bindingId, r.toArray());
        this.owner.getHandlerConfigurator().configureHandlers(this, bindingImpl);
        return bindingImpl;
    }

    private WSDLPort getPortModel(WSServiceDelegate owner, QName portName) {
        if (owner.getWsdlService() != null) {
            Iterable<WSDLPortImpl> ports = owner.getWsdlService().getPorts();
            for (WSDLPortImpl port : ports) {
                if (!port.getName().equals(portName)) continue;
                return port;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public WSDLPort getPort() {
        return this.portModel;
    }

    @Override
    @NotNull
    public WSService getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    @NotNull
    public EndpointAddress getEndpointAddress() {
        return this.targetEndpoint;
    }

    public QName getServiceName() {
        return this.owner.getServiceName();
    }

    public QName getPortName() {
        return this.portName;
    }

    public String getBindingID() {
        return this.bindingId.toString();
    }
}

