/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.sei;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.client.AsyncInvoker;
import com.sun.xml.ws.client.AsyncResponseImpl;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContext;
import com.sun.xml.ws.client.sei.ResponseBuilder;
import com.sun.xml.ws.client.sei.SEIMethodHandler;
import com.sun.xml.ws.client.sei.SEIStub;
import com.sun.xml.ws.client.sei.ValueGetterFactory;
import com.sun.xml.ws.client.sei.ValueSetterFactory;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.model.ParameterImpl;
import com.sun.xml.ws.model.WrapperParameter;
import java.util.List;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;

abstract class AsyncMethodHandler
extends SEIMethodHandler {
    private final ResponseBuilder responseBuilder;
    @Nullable
    private final Class asyncBeanClass;

    AsyncMethodHandler(SEIStub owner, JavaMethodImpl jm, JavaMethodImpl sync) {
        super(owner, sync);
        List<ParameterImpl> rp = sync.getResponseParameters();
        int size = 0;
        for (ParameterImpl param : rp) {
            if (param.isWrapperStyle()) {
                WrapperParameter wrapParam = (WrapperParameter)param;
                size += wrapParam.getWrapperChildren().size();
                if (sync.getBinding().getStyle() != SOAPBinding.Style.DOCUMENT) continue;
                size += 2;
                continue;
            }
            ++size;
        }
        Class tempWrap = null;
        if (size > 1) {
            rp = jm.getResponseParameters();
            for (ParameterImpl param : rp) {
                if (param.isWrapperStyle()) {
                    WrapperParameter wrapParam = (WrapperParameter)param;
                    if (sync.getBinding().getStyle() == SOAPBinding.Style.DOCUMENT) {
                        tempWrap = (Class)wrapParam.getTypeReference().type;
                        break;
                    }
                    for (ParameterImpl p : wrapParam.getWrapperChildren()) {
                        if (p.getIndex() != -1) continue;
                        tempWrap = (Class)p.getTypeReference().type;
                        break;
                    }
                    if (tempWrap == null) continue;
                    break;
                }
                if (param.getIndex() != -1) continue;
                tempWrap = (Class)param.getTypeReference().type;
                break;
            }
        }
        this.asyncBeanClass = tempWrap;
        switch (size) {
            case 0: {
                this.responseBuilder = this.buildResponseBuilder(sync, ValueSetterFactory.NONE);
                break;
            }
            case 1: {
                this.responseBuilder = this.buildResponseBuilder(sync, ValueSetterFactory.SINGLE);
                break;
            }
            default: {
                this.responseBuilder = this.buildResponseBuilder(sync, new ValueSetterFactory.AsyncBeanValueSetterFactory(this.asyncBeanClass));
            }
        }
    }

    protected final Response<Object> doInvoke(Object proxy, Object[] args, AsyncHandler handler) {
        SEIAsyncInvoker invoker = new SEIAsyncInvoker(proxy, args);
        AsyncResponseImpl<Object> ft = new AsyncResponseImpl<Object>((Runnable)invoker, handler);
        invoker.setReceiver(ft);
        this.owner.getExecutor().execute(ft);
        return ft;
    }

    @Override
    ValueGetterFactory getValueGetterFactory() {
        return ValueGetterFactory.ASYNC;
    }

    private class SEIAsyncInvoker
    extends AsyncInvoker {
        private final RequestContext rc;
        private final Object[] args;

        SEIAsyncInvoker(Object proxy, Object[] args) {
            this.rc = AsyncMethodHandler.this.owner.requestContext.copy();
            this.args = args;
        }

        @Override
        public void do_run() {
            Packet req = new Packet(AsyncMethodHandler.this.createRequestMessage(this.args));
            req.soapAction = AsyncMethodHandler.this.soapAction;
            req.expectReply = !AsyncMethodHandler.this.isOneWay;
            req.getMessage().assertOneWay(AsyncMethodHandler.this.isOneWay);
            Fiber.CompletionCallback callback = new Fiber.CompletionCallback(){

                @Override
                public void onCompletion(@NotNull Packet response) {
                    SEIAsyncInvoker.this.responseImpl.setResponseContext(new ResponseContext(response));
                    Message msg = response.getMessage();
                    if (msg == null) {
                        return;
                    }
                    try {
                        if (msg.isFault()) {
                            SOAPFaultBuilder faultBuilder = SOAPFaultBuilder.create(msg);
                            throw faultBuilder.createException(AsyncMethodHandler.this.checkedExceptions);
                        }
                        Object[] rargs = new Object[1];
                        if (AsyncMethodHandler.this.asyncBeanClass != null) {
                            rargs[0] = AsyncMethodHandler.this.asyncBeanClass.newInstance();
                        }
                        AsyncMethodHandler.this.responseBuilder.readResponse(msg, rargs);
                        SEIAsyncInvoker.this.responseImpl.set(rargs[0], null);
                    }
                    catch (Throwable t) {
                        if (t instanceof RuntimeException) {
                            if (t instanceof WebServiceException) {
                                SEIAsyncInvoker.this.responseImpl.set(null, t);
                                return;
                            }
                        } else if (t instanceof Exception) {
                            SEIAsyncInvoker.this.responseImpl.set(null, t);
                            return;
                        }
                        SEIAsyncInvoker.this.responseImpl.set(null, new WebServiceException(t));
                    }
                }

                @Override
                public void onCompletion(@NotNull Throwable error) {
                    if (error instanceof WebServiceException) {
                        SEIAsyncInvoker.this.responseImpl.set(null, error);
                    } else {
                        SEIAsyncInvoker.this.responseImpl.set(null, new WebServiceException(error));
                    }
                }
            };
            AsyncMethodHandler.this.owner.doProcessAsync(req, this.rc, callback);
        }
    }
}

