/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.log.FileHandle;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class LastFileReader
extends FileReader {
    private Set trackableEntries = new HashSet();
    private long nextUnprovenOffset = 0L;
    private long lastValidOffset = 0L;
    private LogEntryType entryType;
    private Map lastOffsetSeen = new HashMap();

    public LastFileReader(EnvironmentImpl env, int readBufferSize) throws IOException, DatabaseException {
        super(env, readBufferSize, true, -1L, new Long(-1L), -1L, -1L);
        this.anticipateChecksumErrors = true;
    }

    public LastFileReader(EnvironmentImpl env, int readBufferSize, Long specificFileNumber) throws IOException, DatabaseException {
        super(env, readBufferSize, true, -1L, specificFileNumber, -1L, -1L);
        this.anticipateChecksumErrors = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initStartingPosition(long endOfFileLsn, Long singleFileNum) throws IOException, DatabaseException {
        this.eof = false;
        Long lastNum = singleFileNum != null && singleFileNum >= 0L ? singleFileNum : this.fileManager.getLastFileNum();
        FileHandle fileHandle = null;
        this.readBufferFileEnd = 0L;
        long fileLen = 0L;
        while (fileHandle == null && !this.eof) {
            Object var10_7;
            if (lastNum == null) {
                this.eof = true;
                continue;
            }
            try {
                block7: {
                    try {
                        this.readBufferFileNum = lastNum;
                        fileHandle = this.fileManager.getFileHandle(this.readBufferFileNum);
                        fileLen = fileHandle.getFile().length();
                        if (fileLen > (long)FileManager.firstLogEntryOffset()) break block7;
                        lastNum = this.fileManager.getFollowingFileNum(lastNum, false);
                        fileHandle.release();
                        fileHandle = null;
                    }
                    catch (DatabaseException e) {
                        lastNum = this.attemptToMoveBadFile(e);
                        fileHandle = null;
                        var10_7 = null;
                        if (fileHandle == null) continue;
                        fileHandle.release();
                        continue;
                    }
                }
                var10_7 = null;
                if (fileHandle == null) continue;
            }
            catch (Throwable throwable) {
                var10_7 = null;
                if (fileHandle != null) {
                    fileHandle.release();
                }
                throw throwable;
            }
            fileHandle.release();
        }
        this.nextEntryOffset = 0L;
    }

    private Long attemptToMoveBadFile(DatabaseException origException) throws DatabaseException, IOException {
        String fileName = this.fileManager.getFullFileNames(this.readBufferFileNum)[0];
        File problemFile = new File(fileName);
        Long lastNum = null;
        if (problemFile.length() > (long)FileManager.firstLogEntryOffset()) {
            throw origException;
        }
        this.fileManager.clear();
        lastNum = this.fileManager.getFollowingFileNum(this.readBufferFileNum, false);
        this.fileManager.renameFile(this.readBufferFileNum, ".bad");
        return lastNum;
    }

    public void setEndOfFile() throws IOException, DatabaseException {
        this.fileManager.truncateLog(this.readBufferFileNum, this.nextUnprovenOffset);
    }

    public long getEndOfLog() {
        return DbLsn.makeLsn(this.readBufferFileNum, this.nextUnprovenOffset);
    }

    public long getLastValidLsn() {
        return DbLsn.makeLsn(this.readBufferFileNum, this.lastValidOffset);
    }

    public long getPrevOffset() {
        return this.lastValidOffset;
    }

    public LogEntryType getEntryType() {
        return this.entryType;
    }

    public void setTargetType(LogEntryType type) {
        this.trackableEntries.add(type);
    }

    public long getLastSeen(LogEntryType type) {
        Long typeNumber = (Long)this.lastOffsetSeen.get(type);
        if (typeNumber != null) {
            return DbLsn.makeLsn(this.readBufferFileNum, typeNumber);
        }
        return -1L;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) {
        entryBuffer.position(entryBuffer.position() + this.currentEntrySize);
        this.entryType = new LogEntryType(this.currentEntryTypeNum, this.currentEntryTypeVersion);
        if (this.trackableEntries.contains(this.entryType)) {
            this.lastOffsetSeen.put(this.entryType, new Long(this.currentEntryOffset));
        }
        return true;
    }

    public boolean readNextEntry() throws DatabaseException, IOException {
        boolean foundEntry = false;
        this.nextUnprovenOffset = this.nextEntryOffset;
        try {
            foundEntry = super.readNextEntry();
            this.lastValidOffset = this.currentEntryOffset;
        }
        catch (DbChecksumException e) {
            Tracer.trace(Level.INFO, this.env, "Found checksum exception while searching  for end of log. Last valid entry is at " + DbLsn.toString(DbLsn.makeLsn(this.readBufferFileNum, this.lastValidOffset)) + " Bad entry is at " + DbLsn.makeLsn(this.readBufferFileNum, this.currentEntryOffset));
        }
        return foundEntry;
    }
}

