/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageDataContainer;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.coveragedata.LineData;
import net.sourceforge.cobertura.util.StringUtil;

public class SourceFileData
extends CoverageDataContainer
implements Comparable,
HasBeenInstrumented {
    private static final long serialVersionUID = 3L;
    private String name;

    public SourceFileData(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Source file name must be specified.");
        }
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassData(ClassData classData) {
        this.lock.lock();
        try {
            if (this.children.containsKey(classData.getBaseName())) {
                throw new IllegalArgumentException("Source file " + this.name + " already contains a class with the name " + classData.getBaseName());
            }
            this.children.put(classData.getBaseName(), classData);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(SourceFileData.class)) {
            return Integer.MAX_VALUE;
        }
        return this.name.compareTo(((SourceFileData)o).name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        this.lock.lock();
        try {
            boolean bl = this.children.containsKey(name);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsInstrumentationInfo() {
        this.lock.lock();
        try {
            for (ClassData classData : this.children.values()) {
                if (classData.containsInstrumentationInfo()) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SourceFileData sourceFileData = (SourceFileData)obj;
        this.getBothLocks(sourceFileData);
        try {
            boolean bl = super.equals(obj) && this.name.equals(sourceFileData.name);
            return bl;
        }
        finally {
            this.lock.unlock();
            sourceFileData.lock.unlock();
        }
    }

    public String getBaseName() {
        int lastDot = this.name.lastIndexOf(46);
        String fullNameWithoutExtension = lastDot == -1 ? this.name : this.name.substring(0, lastDot);
        int lastSlash = fullNameWithoutExtension.lastIndexOf(47);
        if (lastSlash == -1) {
            return fullNameWithoutExtension;
        }
        return fullNameWithoutExtension.substring(lastSlash + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet getClasses() {
        this.lock.lock();
        try {
            TreeSet treeSet = new TreeSet(this.children.values());
            return treeSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineData getLineCoverage(int lineNumber) {
        this.lock.lock();
        try {
            for (ClassData classData : this.children.values()) {
                if (!classData.isValidSourceLineNumber(lineNumber)) continue;
                LineData lineData = classData.getLineCoverage(lineNumber);
                return lineData;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getNormalizedName() {
        int lastDot = this.name.lastIndexOf(46);
        String fullNameWithoutExtension = lastDot == -1 ? this.name : this.name.substring(0, lastDot);
        return StringUtil.replaceAll(fullNameWithoutExtension, "/", ".");
    }

    public String getPackageName() {
        int lastSlash = this.name.lastIndexOf(47);
        if (lastSlash == -1) {
            return null;
        }
        return StringUtil.replaceAll(this.name.substring(0, lastSlash), "/", ".");
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSourceLineNumber(int lineNumber) {
        this.lock.lock();
        try {
            for (ClassData classData : this.children.values()) {
                if (!classData.isValidSourceLineNumber(lineNumber)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }
}

