/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.security.digest.DigestRequest;
import org.jboss.seam.security.digest.DigestUtils;
import org.jboss.seam.security.digest.DigestValidationException;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.util.Base64;
import org.jboss.seam.web.AbstractFilter;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.web.authenticationFilter")
@Install(value=false, precedence=0)
@BypassInterceptors
@Filter(within={"org.jboss.seam.web.exceptionFilter"})
public class AuthenticationFilter
extends AbstractFilter {
    private static final String DEFAULT_REALM = "seamApp";
    private static final String AUTH_TYPE_BASIC = "basic";
    private static final String AUTH_TYPE_DIGEST = "digest";
    @Logger
    Log log;
    private String realm = "seamApp";
    private String key;
    private int nonceValiditySeconds = 300;
    private String authType = "basic";

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getNonceValiditySeconds() {
        return this.nonceValiditySeconds;
    }

    public void setNonceValiditySeconds(int value) {
        this.nonceValiditySeconds = value;
    }

    public void doFilter(ServletRequest request, ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("This filter can only process HttpServletRequest requests");
        }
        final HttpServletRequest httpRequest = (HttpServletRequest)request;
        final HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpRequest.getSession();
        new ContextualHttpServletRequest(httpRequest){

            public void process() throws ServletException, IOException, LoginException {
                if (AuthenticationFilter.AUTH_TYPE_BASIC.equals(AuthenticationFilter.this.authType)) {
                    AuthenticationFilter.this.processBasicAuth(httpRequest, httpResponse, chain);
                } else if (AuthenticationFilter.AUTH_TYPE_DIGEST.equals(AuthenticationFilter.this.authType)) {
                    AuthenticationFilter.this.processDigestAuth(httpRequest, httpResponse, chain);
                } else {
                    throw new ServletException("Invalid authentication type");
                }
            }
        }.run();
    }

    private void processBasicAuth(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Identity identity = Identity.instance();
        if (identity == null) {
            throw new ServletException("Identity not found - please ensure that the Identity component is created on startup.");
        }
        Credentials credentials = identity.getCredentials();
        boolean requireAuth = false;
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Basic ")) {
            String base64Token = header.substring(6);
            String token = new String(Base64.decode(base64Token));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            if (!username.equals(credentials.getUsername()) || !identity.isLoggedIn()) {
                try {
                    credentials.setPassword(password);
                    this.authenticate(request, username);
                }
                catch (Exception ex) {
                    this.log.warn((Object)("Error authenticating: " + ex.getMessage()), new Object[0]);
                    requireAuth = true;
                }
            }
        }
        if (!identity.isLoggedIn() && !credentials.isSet()) {
            requireAuth = true;
        }
        try {
            if (!requireAuth) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        catch (NotLoggedInException ex) {
            requireAuth = true;
        }
        if (requireAuth && !identity.isLoggedIn()) {
            response.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            response.sendError(401, "Not authorized");
        }
    }

    private void processDigestAuth(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Identity identity = Identity.instance();
        if (identity == null) {
            throw new ServletException("Identity not found - please ensure that the Identity component is created on startup.");
        }
        Credentials credentials = identity.getCredentials();
        boolean requireAuth = false;
        boolean nonceExpired = false;
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Digest ")) {
            String section212response = header.substring(7);
            String[] headerEntries = section212response.split(",");
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (String entry : headerEntries) {
                String[] vals = this.split(entry, "=");
                headerMap.put(vals[0].trim(), vals[1].replace("\"", "").trim());
            }
            DigestRequest digestRequest = new DigestRequest();
            digestRequest.setHttpMethod(request.getMethod());
            digestRequest.setSystemRealm(this.realm);
            digestRequest.setRealm((String)headerMap.get("realm"));
            digestRequest.setKey(this.key);
            digestRequest.setNonce((String)headerMap.get("nonce"));
            digestRequest.setUri((String)headerMap.get("uri"));
            digestRequest.setClientDigest((String)headerMap.get("response"));
            digestRequest.setQop((String)headerMap.get("qop"));
            digestRequest.setNonceCount((String)headerMap.get("nc"));
            digestRequest.setClientNonce((String)headerMap.get("cnonce"));
            try {
                digestRequest.validate();
                request.getSession().setAttribute("org.jboss.seam.security.digestRequest", (Object)digestRequest);
                this.authenticate(request, (String)headerMap.get("username"));
            }
            catch (DigestValidationException ex) {
                this.log.warn((Object)String.format("Digest validation failed, header [%s]: %s", section212response, ex.getMessage()), new Object[0]);
                requireAuth = true;
                if (ex.isNonceExpired()) {
                    nonceExpired = true;
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)("Error authenticating: " + ex.getMessage()), new Object[0]);
                requireAuth = true;
            }
        }
        if (!identity.isLoggedIn() && !credentials.isSet()) {
            requireAuth = true;
        }
        try {
            if (!requireAuth) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        catch (NotLoggedInException ex) {
            requireAuth = true;
        }
        if (requireAuth && !identity.isLoggedIn()) {
            long expiryTime = System.currentTimeMillis() + (long)(this.nonceValiditySeconds * 1000);
            String signatureValue = DigestUtils.md5Hex(expiryTime + ":" + this.key);
            String nonceValue = expiryTime + ":" + signatureValue;
            String nonceValueBase64 = Base64.encodeBytes(nonceValue.getBytes());
            String authenticateHeader = "Digest realm=\"" + this.realm + "\", " + "qop=\"auth\", nonce=\"" + nonceValueBase64 + "\"";
            if (nonceExpired) {
                authenticateHeader = authenticateHeader + ", stale=\"true\"";
            }
            response.addHeader("WWW-Authenticate", authenticateHeader);
            response.sendError(401);
        }
    }

    private void authenticate(HttpServletRequest request, String username) throws ServletException, IOException, LoginException {
        Identity identity = Identity.instance();
        identity.getCredentials().setUsername(username);
        identity.authenticate();
    }

    private String[] split(String toSplit, String delimiter) {
        if (delimiter.length() != 1) {
            throw new IllegalArgumentException("Delimiter can only be one character in length");
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + 1);
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthType {
        basic,
        digest;

    }
}

