/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlColumn;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.component.html.HtmlForm;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.component.html.HtmlMessage;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import org.rhq.core.gui.util.FacesComponentIdFactory;
import org.rhq.core.gui.util.FacesExpressionUtility;
import org.richfaces.component.html.HtmlSeparator;
import org.richfaces.component.html.HtmlSimpleTogglePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacesComponentUtility {
    public static final String NO_STYLE_CLASS = null;
    private static final String DISABLED_ATTRIBUTE_NAME = "disabled";
    private static final String READONLY_ATTRIBUTE = "readonly";
    private static final String UNSET_ATTRIBUTE = "unset";
    private static final String OVERRIDE_ATTRIBUTE = "override";

    public static HtmlPanelGroup createBlockPanel(FacesComponentIdFactory idFactory, String styleClass) {
        HtmlPanelGroup panel = FacesComponentUtility.createComponent(HtmlPanelGroup.class, idFactory);
        panel.setLayout("block");
        panel.setStyleClass(styleClass);
        return panel;
    }

    public static HtmlPanelGroup addBlockPanel(UIComponent parent, FacesComponentIdFactory idFactory, String styleClass) {
        HtmlPanelGroup panel = FacesComponentUtility.createBlockPanel(idFactory, styleClass);
        parent.getChildren().add(panel);
        return panel;
    }

    public static HtmlPanelGroup addInlinePanel(UIComponent parent, FacesComponentIdFactory idFactory, String styleClass) {
        HtmlPanelGroup panel = FacesComponentUtility.createComponent(HtmlPanelGroup.class, idFactory);
        panel.setStyleClass(styleClass);
        parent.getChildren().add(panel);
        return panel;
    }

    public static HtmlSimpleTogglePanel addSimpleTogglePanel(UIComponent parent, FacesComponentIdFactory idFactory, String label) {
        HtmlSimpleTogglePanel panel = FacesComponentUtility.createComponent(HtmlSimpleTogglePanel.class, idFactory);
        panel.setLabel(label);
        panel.setSwitchType("client");
        parent.getChildren().add(panel);
        return panel;
    }

    public static HtmlSeparator addSeparator(UIComponent parent, FacesComponentIdFactory idFactory) {
        HtmlSeparator separator = FacesComponentUtility.createComponent(HtmlSeparator.class, idFactory);
        parent.getChildren().add(separator);
        return separator;
    }

    public static HtmlOutputText addOutputText(UIComponent parent, FacesComponentIdFactory idFactory, CharSequence value, String styleClass) {
        HtmlOutputText text = FacesComponentUtility.createComponent(HtmlOutputText.class, idFactory);
        text.setValue((Object)value);
        text.setStyleClass(styleClass);
        parent.getChildren().add(text);
        return text;
    }

    public static HtmlOutputText createOutputText(FacesComponentIdFactory idFactory, CharSequence value, String styleClass) {
        HtmlOutputText text = FacesComponentUtility.createComponent(HtmlOutputText.class, idFactory);
        if (value != null) {
            value = ((Object)value).toString().trim();
        }
        text.setValue((Object)value);
        text.setStyleClass(styleClass);
        return text;
    }

    public static HtmlColumn addColumn(UIComponent parent, FacesComponentIdFactory idFactory, CharSequence headerText, String headerStyle) {
        HtmlColumn column = FacesComponentUtility.createComponent(HtmlColumn.class, idFactory);
        HtmlOutputText header = new HtmlOutputText();
        header.setValue((Object)headerText);
        header.setStyleClass(headerStyle);
        column.setHeader((UIComponent)header);
        parent.getChildren().add(column);
        return column;
    }

    public static HtmlOutputText addVerbatimText(UIComponent parent, CharSequence html) {
        HtmlOutputText outputText = FacesComponentUtility.createComponent(HtmlOutputText.class, null);
        outputText.setEscape(false);
        outputText.setValue((Object)html);
        parent.getChildren().add(outputText);
        return outputText;
    }

    public static UIOutput addButton(UIComponent parent, String label, String styleClass) {
        return FacesComponentUtility.addVerbatimText(parent, "<button class=\"" + styleClass + "\">" + label + "</button>");
    }

    public static UIOutput addJavaScript(UIComponent parent, FacesComponentIdFactory idFactory, CharSequence src, CharSequence script) {
        UIOutput output = FacesComponentUtility.createComponent(UIOutput.class, idFactory);
        output.getAttributes().put("escape", Boolean.FALSE);
        StringBuilder value = new StringBuilder();
        value.append("\n<script language=\"JavaScript\" type=\"text/javascript\"");
        if (src != null) {
            value.append(" src=\"").append(src).append("\"");
        }
        value.append(">");
        if (script != null) {
            value.append("\n").append(script).append("\n");
        }
        value.append("</script>\n");
        output.setValue((Object)value);
        parent.getChildren().add(output);
        return output;
    }

    public static <T extends UIComponent> List<T> getDescendantsOfType(UIComponent component, Class<T> componentClass) {
        ArrayList results = new ArrayList();
        FacesComponentUtility.getDescendantsOfType(component, componentClass, results);
        return results;
    }

    private static <T extends UIComponent> void getDescendantsOfType(UIComponent component, Class<T> componentClass, List<T> results) {
        for (int i = 0; i < component.getChildren().size(); ++i) {
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (componentClass.isAssignableFrom(child.getClass())) {
                results.add(child);
            }
            FacesComponentUtility.getDescendantsOfType(child, componentClass, results);
        }
    }

    public static <T extends UIComponent> T getAncestorOfType(UIComponent component, Class<T> componentClass) {
        if (component == null) {
            return null;
        }
        if (componentClass.isAssignableFrom(component.getClass())) {
            return (T)component;
        }
        return FacesComponentUtility.getAncestorOfType(component.getParent(), componentClass);
    }

    public static HtmlOutputLabel addLabel(UIComponent parent, FacesComponentIdFactory idFactory, UIInput associatedInput, String value, String styleClass) {
        HtmlOutputLabel label = FacesComponentUtility.createComponent(HtmlOutputLabel.class, idFactory);
        label.setFor(associatedInput.getId());
        label.setValue((Object)value);
        label.setStyleClass(styleClass);
        parent.getChildren().add(label);
        return label;
    }

    public static HtmlGraphicImage addGraphicImage(UIComponent parent, FacesComponentIdFactory idFactory, String url, String alt) {
        HtmlGraphicImage image = FacesComponentUtility.createComponent(HtmlGraphicImage.class, idFactory);
        image.setUrl(url);
        image.setAlt(alt);
        image.setTitle(alt);
        parent.getChildren().add(image);
        return image;
    }

    public static HtmlOutputLink addOutputLink(UIComponent parent, FacesComponentIdFactory idFactory, String value) {
        HtmlOutputLink link = FacesComponentUtility.createComponent(HtmlOutputLink.class, idFactory);
        link.setValue((Object)value);
        parent.getChildren().add(link);
        return link;
    }

    public static UIParameter addParameter(UIComponent parent, FacesComponentIdFactory idFactory, String name, String value) {
        UIParameter parameter = FacesComponentUtility.createComponent(UIParameter.class, idFactory);
        parameter.setName(name);
        parameter.setValue((Object)value);
        parent.getChildren().add(parameter);
        return parameter;
    }

    public static HtmlForm addForm(UIComponent parent, FacesComponentIdFactory idFactory) {
        HtmlForm form = FacesComponentUtility.createComponent(HtmlForm.class, idFactory);
        form.setPrependId(false);
        parent.getChildren().add(form);
        return form;
    }

    public static HtmlCommandButton addCommandButton(UIComponent parent, FacesComponentIdFactory idFactory, String value, String styleClass) {
        HtmlCommandButton button = FacesComponentUtility.createComponent(HtmlCommandButton.class, idFactory);
        button.setValue((Object)value);
        button.setStyleClass(styleClass);
        parent.getChildren().add(button);
        return button;
    }

    public static HtmlCommandLink addCommandLink(UIComponent parent, FacesComponentIdFactory idFactory) {
        HtmlCommandLink link = FacesComponentUtility.createComponent(HtmlCommandLink.class, idFactory);
        parent.getChildren().add(link);
        return link;
    }

    public static HtmlMessage addMessage(UIComponent parent, FacesComponentIdFactory idFactory, String associatedComponentId, String styleClass) {
        HtmlMessage message = FacesComponentUtility.createComponent(HtmlMessage.class, idFactory);
        message.setFor(associatedComponentId);
        message.setShowDetail(true);
        message.setErrorClass(styleClass);
        message.setWarnClass(styleClass);
        message.setFatalClass(styleClass);
        message.setInfoClass(styleClass);
        parent.getChildren().add(message);
        return message;
    }

    public static HtmlPanelGrid addPanelGrid(UIComponent parent, FacesComponentIdFactory idFactory, int columns, String styleClass) {
        HtmlPanelGrid panelGrid = FacesComponentUtility.createComponent(HtmlPanelGrid.class, idFactory);
        panelGrid.setColumns(columns);
        panelGrid.setStyleClass(styleClass);
        parent.getChildren().add(panelGrid);
        return panelGrid;
    }

    public static HtmlDataTable addDataTable(UIComponent parent, FacesComponentIdFactory idFactory, String styleClass) {
        HtmlDataTable dataTable = FacesComponentUtility.createComponent(HtmlDataTable.class, idFactory);
        dataTable.setStyleClass(styleClass);
        parent.getChildren().add(dataTable);
        return dataTable;
    }

    public static String getExpressionAttribute(UIComponent component, String attribName) {
        return FacesComponentUtility.getExpressionAttribute(component, attribName, String.class);
    }

    public static <T> T getExpressionAttribute(UIComponent component, String attribName, Class<T> expectedType) {
        ValueExpression valueExpression = component.getValueExpression(attribName);
        T attribValue = valueExpression != null ? (T)FacesExpressionUtility.getValue(valueExpression, expectedType) : null;
        return attribValue;
    }

    public static Map<String, String> getParameters(UIComponent component) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        List children = component.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            Object paramValue = param.getValue();
            params.put(param.getName(), paramValue != null ? paramValue.toString() : null);
        }
        return params;
    }

    public static <T extends UIComponent> T createComponent(Class<T> componentClass) {
        return FacesComponentUtility.createComponent(componentClass, null);
    }

    public static <T extends UIComponent> T createComponent(Class<T> componentClass, FacesComponentIdFactory idFactory) {
        Application application = FacesContext.getCurrentInstance().getApplication();
        String componentType = FacesComponentUtility.getComponentType(componentClass);
        UIComponent component = application.createComponent(componentType);
        if (idFactory == null) {
            idFactory = new DefaultFacesComponentIdFactory();
        }
        component.setId(idFactory.createUniqueId());
        return (T)component;
    }

    public static void setDisabled(UIComponent component, boolean disabled) {
        component.getAttributes().put(DISABLED_ATTRIBUTE_NAME, disabled);
    }

    public static boolean isDisabled(UIComponent component) {
        Boolean disabled = (Boolean)component.getAttributes().get(DISABLED_ATTRIBUTE_NAME);
        return disabled != null && disabled != false;
    }

    public static void setReadonly(UIInput input, boolean readonly) {
        input.getAttributes().put(READONLY_ATTRIBUTE, readonly);
    }

    public static boolean isReadonly(UIComponent component) {
        Boolean readonly = (Boolean)component.getAttributes().get(READONLY_ATTRIBUTE);
        return readonly != null && readonly != false;
    }

    public static void setUnset(UIInput input, boolean unset) {
        input.getAttributes().put(UNSET_ATTRIBUTE, unset);
    }

    public static boolean isUnset(UIComponent component) {
        Boolean unset = (Boolean)component.getAttributes().get(UNSET_ATTRIBUTE);
        return unset != null && unset != false;
    }

    public static void setOverride(UIInput input, boolean override) {
        input.getAttributes().put(OVERRIDE_ATTRIBUTE, override);
    }

    public static boolean isOverride(UIComponent component) {
        Boolean override = (Boolean)component.getAttributes().get(OVERRIDE_ATTRIBUTE);
        return override == null || override != false;
    }

    public static void detachComponent(UIComponent component) {
        UIComponent parent = component.getParent();
        if (parent != null) {
            Iterator children = parent.getChildren().iterator();
            while (children.hasNext()) {
                UIComponent child = (UIComponent)children.next();
                if (child.getId() == null || !child.getId().equals(component.getId())) continue;
                children.remove();
                break;
            }
        }
    }

    public static UIForm getEnclosingForm(UIComponent component) throws IllegalArgumentException {
        UIForm ret = null;
        while (component != null) {
            if (component instanceof UIForm) {
                if (ret != null) {
                    throw new IllegalArgumentException();
                }
                ret = (UIForm)component;
            }
            component = component.getParent();
        }
        return ret;
    }

    private static <T extends UIComponent> String getComponentType(Class<T> componentClass) {
        String componentType;
        try {
            componentType = (String)componentClass.getDeclaredField("COMPONENT_TYPE").get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return componentType;
    }

    private static class DefaultFacesComponentIdFactory
    implements FacesComponentIdFactory {
        private DefaultFacesComponentIdFactory() {
        }

        public String createUniqueId() {
            return "j_id_RHQ_" + UUID.randomUUID();
        }
    }
}

