/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.classes;

import java.net.URL;
import java.util.Vector;
import org.apache.commons.discovery.ResourceClass;
import org.apache.commons.discovery.ResourceClassDiscover;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.ResourceClassDiscoverImpl;
import org.apache.commons.logging.Log;

public class DiscoverClasses
extends ResourceClassDiscoverImpl
implements ResourceClassDiscover {
    private static Log log = DiscoveryLogFactory.newLog(DiscoverClasses.class);

    public static void setLog(Log _log) {
        log = _log;
    }

    public DiscoverClasses() {
    }

    public DiscoverClasses(ClassLoaders classLoaders) {
        super(classLoaders);
    }

    @Override
    public ResourceClassIterator findResourceClasses(final String className) {
        final String resourceName = className.replace('.', '/') + ".class";
        if (log.isDebugEnabled()) {
            log.debug((Object)("find: className='" + className + "'"));
        }
        return new ResourceClassIterator(){
            private Vector history = new Vector();
            private int idx = 0;
            private ResourceClass resource = null;

            @Override
            public boolean hasNext() {
                if (this.resource == null) {
                    this.resource = this.getNextClass();
                }
                return this.resource != null;
            }

            @Override
            public ResourceClass nextResourceClass() {
                ResourceClass element = this.resource;
                this.resource = null;
                return element;
            }

            private ResourceClass getNextClass() {
                while (this.idx < DiscoverClasses.this.getClassLoaders().size()) {
                    ClassLoader loader = DiscoverClasses.this.getClassLoaders().get(this.idx++);
                    URL url = loader.getResource(resourceName);
                    if (url != null) {
                        if (!this.history.contains(url)) {
                            this.history.addElement(url);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("getNextClass: next URL='" + url + "'"));
                            }
                            return new ResourceClass(className, url, loader);
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("getNextClass: duplicate URL='" + url + "'"));
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("getNextClass: loader " + loader + ": '" + resourceName + "' not found"));
                }
                return null;
            }
        };
    }
}

