/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.names;

import java.util.Vector;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.names.ResourceNameDiscoverImpl;
import org.apache.commons.logging.Log;

public class NameDiscoverers
extends ResourceNameDiscoverImpl
implements ResourceNameDiscover {
    private static Log log = DiscoveryLogFactory.newLog(NameDiscoverers.class);
    private Vector discoverers = new Vector();

    public static void setLog(Log _log) {
        log = _log;
    }

    public void addResourceNameDiscover(ResourceNameDiscover discover) {
        if (discover != null) {
            this.discoverers.addElement(discover);
        }
    }

    protected ResourceNameDiscover getResourceNameDiscover(int idx) {
        return (ResourceNameDiscover)this.discoverers.get(idx);
    }

    protected int size() {
        return this.discoverers.size();
    }

    @Override
    public ResourceNameIterator findResourceNames(final String resourceName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("find: resourceName='" + resourceName + "'"));
        }
        return new ResourceNameIterator(){
            private int idx = 0;
            private ResourceNameIterator iterator = null;

            @Override
            public boolean hasNext() {
                if (this.iterator == null || !this.iterator.hasNext()) {
                    this.iterator = this.getNextIterator();
                    if (this.iterator == null) {
                        return false;
                    }
                }
                return this.iterator.hasNext();
            }

            @Override
            public String nextResourceName() {
                return this.iterator.nextResourceName();
            }

            private ResourceNameIterator getNextIterator() {
                while (this.idx < NameDiscoverers.this.size()) {
                    ResourceNameIterator iter;
                    if (!(iter = NameDiscoverers.this.getResourceNameDiscover(this.idx++).findResourceNames(resourceName)).hasNext()) continue;
                    return iter;
                }
                return null;
            }
        };
    }
}

