/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.commons.httpclient.auth;

import hidden.org.apache.commons.httpclient.Credentials;
import hidden.org.apache.commons.httpclient.HttpConstants;
import hidden.org.apache.commons.httpclient.UsernamePasswordCredentials;
import hidden.org.apache.commons.httpclient.auth.AuthenticationException;
import hidden.org.apache.commons.httpclient.auth.MalformedChallengeException;
import hidden.org.apache.commons.httpclient.auth.RFC2617Scheme;
import hidden.org.apache.commons.logging.Log;
import hidden.org.apache.commons.logging.LogFactory;
import java.security.MessageDigest;
import java.util.Map;

public class DigestScheme
extends RFC2617Scheme {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$auth$DigestScheme == null ? (class$org$apache$commons$httpclient$auth$DigestScheme = DigestScheme.class$("hidden.org.apache.commons.httpclient.auth.DigestScheme")) : class$org$apache$commons$httpclient$auth$DigestScheme);
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$DigestScheme;

    public String getID() {
        String id = this.getRealm();
        String nonce = this.getParameter("nonce");
        if (nonce != null) {
            id = id + "-" + nonce;
        }
        return id;
    }

    public DigestScheme(String challenge) throws MalformedChallengeException {
        super(challenge);
        if (this.getParameter("realm") == null) {
            throw new MalformedChallengeException("realm missing");
        }
        if (this.getParameter("nonce") == null) {
            throw new MalformedChallengeException("nonce missing");
        }
        this.getParameters().put("nc", "00000001");
    }

    public String getSchemeName() {
        return "digest";
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        LOG.trace("enter DigestScheme.authenticate(Credentials, String, String)");
        UsernamePasswordCredentials usernamepassword = null;
        try {
            usernamepassword = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new AuthenticationException("Credentials cannot be used for digest authentication: " + credentials.getClass().getName());
        }
        this.getParameters().put("cnonce", DigestScheme.createCnonce());
        this.getParameters().put("methodname", method);
        this.getParameters().put("uri", uri);
        return DigestScheme.authenticate(usernamepassword, this.getParameters());
    }

    public static String authenticate(UsernamePasswordCredentials credentials, Map params) throws AuthenticationException {
        LOG.trace("enter DigestScheme.authenticate(UsernamePasswordCredentials, Map)");
        String digest = DigestScheme.createDigest(credentials.getUserName(), credentials.getPassword(), params);
        return "Digest " + DigestScheme.createDigestHeader(credentials.getUserName(), params, digest);
    }

    public static String createDigest(String uname, String pwd, Map params) throws AuthenticationException {
        String serverDigestValue;
        MessageDigest md5Helper;
        LOG.trace("enter DigestScheme.createDigest(String, String, Map)");
        String digAlg = "MD5";
        String uri = (String)params.get("uri");
        String realm = (String)params.get("realm");
        String nonce = (String)params.get("nonce");
        String nc = (String)params.get("nc");
        String cnonce = (String)params.get("cnonce");
        String qop = (String)params.get("qop");
        String method = (String)params.get("methodname");
        String algorithm = (String)params.get("algorithm");
        if (algorithm == null) {
            algorithm = "MD5";
        }
        if (qop != null) {
            qop = "auth";
        }
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new AuthenticationException("Unsupported algorithm in HTTP Digest authentication: MD5");
        }
        String a1 = null;
        if (algorithm.equals("MD5")) {
            a1 = uname + ":" + realm + ":" + pwd;
        } else if (algorithm.equals("MD5-sess")) {
            String tmp = DigestScheme.encode(md5Helper.digest(HttpConstants.getContentBytes(uname + ":" + realm + ":" + pwd)));
            a1 = tmp + ":" + nonce + ":" + cnonce;
        } else {
            LOG.warn("Unhandled algorithm " + algorithm + " requested");
            a1 = uname + ":" + realm + ":" + pwd;
        }
        String md5a1 = DigestScheme.encode(md5Helper.digest(HttpConstants.getContentBytes(a1)));
        String a2 = method + ":" + uri;
        String md5a2 = DigestScheme.encode(md5Helper.digest(HttpConstants.getBytes(a2)));
        if (qop == null) {
            LOG.debug("Using null qop method");
            serverDigestValue = md5a1 + ":" + nonce + ":" + md5a2;
        } else {
            LOG.debug("Using qop method " + qop);
            serverDigestValue = md5a1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        }
        String serverDigest = DigestScheme.encode(md5Helper.digest(HttpConstants.getBytes(serverDigestValue)));
        return serverDigest;
    }

    public static String createDigestHeader(String uname, Map params, String digest) {
        LOG.trace("enter DigestScheme.createDigestHeader(String, Map, String)");
        StringBuffer sb = new StringBuffer();
        String uri = (String)params.get("uri");
        String realm = (String)params.get("realm");
        String nonce = (String)params.get("nonce");
        String nc = (String)params.get("nc");
        String cnonce = (String)params.get("cnonce");
        String opaque = (String)params.get("opaque");
        String response = digest;
        String qop = (String)params.get("qop");
        String algorithm = (String)params.get("algorithm");
        if (qop != null) {
            qop = "auth";
        }
        sb.append("username=\"" + uname + "\"").append(", realm=\"" + realm + "\"").append(", nonce=\"" + nonce + "\"").append(", uri=\"" + uri + "\"").append(qop == null ? "" : ", qop=\"" + qop + "\"").append(algorithm == null ? "" : ", algorithm=\"" + algorithm + "\"").append(qop == null ? "" : ", nc=" + nc).append(qop == null ? "" : ", cnonce=\"" + cnonce + "\"").append(", response=\"" + response + "\"").append(opaque == null ? "" : ", opaque=\"" + opaque + "\"");
        return sb.toString();
    }

    private static String encode(byte[] binaryData) {
        LOG.trace("enter DigestScheme.encode(byte[])");
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        int i = 0;
        while (i < 16) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
            ++i;
        }
        return new String(buffer);
    }

    public static String createCnonce() throws AuthenticationException {
        MessageDigest md5Helper;
        LOG.trace("enter DigestScheme.createCnonce()");
        String digAlg = "MD5";
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new AuthenticationException("Unsupported algorithm in HTTP Digest authentication: MD5");
        }
        String cnonce = Long.toString(System.currentTimeMillis());
        cnonce = DigestScheme.encode(md5Helper.digest(HttpConstants.getBytes(cnonce)));
        return cnonce;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

