/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.BindingKey;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DeleteBinding;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class DeleteBindingHandler
extends AbstractHandler {
    public static final String TAG_NAME = "delete_binding";
    private HandlerMaker maker = null;

    protected DeleteBindingHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        DeleteBinding obj = new DeleteBinding();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "authInfo")).size() > 0) {
            handler = this.maker.lookup("authInfo");
            obj.setAuthInfo((AuthInfo)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "bindingKey");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("bindingKey");
            obj.addBindingKey((BindingKey)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector keyVector;
        DeleteBinding request = (DeleteBinding)object;
        String generic = request.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("generic", generic);
        AuthInfo authInfo = request.getAuthInfo();
        if (authInfo != null) {
            handler = this.maker.lookup("authInfo");
            handler.marshal(authInfo, element);
        }
        if ((keyVector = request.getBindingKeyVector()) != null && keyVector.size() > 0) {
            handler = this.maker.lookup("bindingKey");
            for (int i = 0; i < keyVector.size(); ++i) {
                handler.marshal(new BindingKey((String)keyVector.elementAt(i)), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AuthInfo authInfo = new AuthInfo();
        authInfo.setValue("6f157513-844e-4a95-a856-d257e6ba9726");
        DeleteBinding service = new DeleteBinding();
        service.setAuthInfo(authInfo);
        service.addBindingKey("1bd50f65-9671-41ae-8d13-b3b5a5afcda0");
        service.addBindingKey(new BindingKey("1fbe67e6-f8b5-4743-a23f-9c13e4273d9f"));
        System.out.println();
        RegistryObject regObject = service;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

