/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class ErrInfoHandler
extends AbstractHandler {
    public static final String TAG_NAME = "errInfo";

    protected ErrInfoHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        ErrInfo obj = new ErrInfo();
        obj.setErrCode(element.getAttribute("errCode"));
        obj.setErrMsg(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String lineValue;
        ErrInfo errInfo = (ErrInfo)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String errCode = errInfo.getErrCode();
        if (errCode != null) {
            element.setAttribute("errCode", errCode);
        }
        if ((lineValue = errInfo.getErrMsg()) != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(lineValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        ErrInfo errInfo = new ErrInfo();
        errInfo.setErrCode("E_accountLimitExceeded");
        errInfo.setErrMsg("Authentication token information has timed out.");
        System.out.println();
        RegistryObject regObject = errInfo;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

