/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.negotiation.prototype.DecodeAction;

public class AdvancedLdapLoginModule
extends AbstractServerLoginModule {
    private static final String BIND_AUTHENTICATION = "bindAuthentication";
    private static final String BIND_DN = "bindDN";
    private static final String BIND_CREDENTIAL = "bindCredential";
    private static final String SECURITY_DOMAIN = "jaasSecurityDomain";
    private static final String BASE_CTX_DN = "baseCtxDN";
    private static final String BASE_FILTER = "baseFilter";
    private static final String SEARCH_TIME_LIMIT = "searchTimeLimit";
    private static final String ROLES_CTS_DN = "rolesCtxDN";
    private static final String ROLE_FILTER = "roleFilter";
    private static final String RECURSE_ROLES = "recurseRoles";
    private static final String ROLE_ATTRIBUTE_ID = "roleAttributeID";
    private static final String ROLE_ATTRIBUTE_IS_DN = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID = "roleNameAttributeID";
    private static final String ROLE_SEARCH_SCOPE = "searchScope";
    private static final String ALLOW_EMPTY_PASSWORD = "allowEmptyPassword";
    private static final String AUTH_TYPE_GSSAPI = "GSSAPI";
    private static final String AUTH_TYPE_SIMPLE = "simple";
    private static final String DEFAULT_LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String DEFAULT_URL = "ldap://localhost:389";
    private static final String DEFAULT_SSL_URL = "ldap://localhost:686";
    private static final String PROTOCOL_SSL = "SSL";
    private static final String OBJECT_SCOPE = "OBJECT_SCOPE";
    private static final String ONELEVEL_SCOPE = "ONELEVEL_SCOPE";
    private static final String SUBTREE_SCOPE = "SUBTREE_SCOPE";
    protected String bindAuthentication;
    protected String bindDn;
    protected String bindCredential;
    protected String jaasSecurityDomain;
    protected String baseCtxDN;
    protected String baseFilter;
    protected int searchTimeLimit = 10000;
    protected SearchControls userSearchControls;
    protected String rolesCtxDN;
    protected String roleFilter;
    protected boolean recurseRoles;
    protected SearchControls roleSearchControls;
    protected String roleAttributeID;
    protected boolean roleAttributeIsDN;
    protected String roleNameAttributeID;
    protected boolean allowEmptyPassword;
    private Principal identity;
    private char[] credential;
    private SimpleGroup userRoles = new SimpleGroup("Roles");
    private Set<String> processedRoleDNs = new HashSet<String>();

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        this.bindAuthentication = (String)options.get(BIND_AUTHENTICATION);
        this.bindDn = (String)options.get(BIND_DN);
        this.bindCredential = (String)options.get(BIND_CREDENTIAL);
        this.jaasSecurityDomain = (String)options.get(SECURITY_DOMAIN);
        this.baseCtxDN = (String)options.get(BASE_CTX_DN);
        this.baseFilter = (String)options.get(BASE_FILTER);
        String temp = (String)options.get(SEARCH_TIME_LIMIT);
        if (temp != null) {
            try {
                this.searchTimeLimit = Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                this.log.warn((Object)("Failed to parse: " + temp + ", using searchTimeLimit=" + this.searchTimeLimit));
            }
        }
        this.userSearchControls = new SearchControls();
        this.userSearchControls.setSearchScope(2);
        this.userSearchControls.setReturningAttributes(new String[0]);
        this.userSearchControls.setTimeLimit(this.searchTimeLimit);
        this.rolesCtxDN = (String)options.get(ROLES_CTS_DN);
        this.roleFilter = (String)options.get(ROLE_FILTER);
        temp = (String)options.get(RECURSE_ROLES);
        this.recurseRoles = Boolean.parseBoolean(temp);
        int searchScope = 2;
        temp = (String)options.get(ROLE_SEARCH_SCOPE);
        if (OBJECT_SCOPE.equalsIgnoreCase(temp)) {
            searchScope = 0;
        } else if (ONELEVEL_SCOPE.equalsIgnoreCase(temp)) {
            searchScope = 1;
        }
        if (SUBTREE_SCOPE.equalsIgnoreCase(temp)) {
            searchScope = 2;
        }
        this.roleSearchControls = new SearchControls();
        this.roleSearchControls.setSearchScope(searchScope);
        this.roleSearchControls.setReturningAttributes(new String[0]);
        this.roleSearchControls.setTimeLimit(this.searchTimeLimit);
        this.roleAttributeID = (String)options.get(ROLE_ATTRIBUTE_ID);
        temp = (String)options.get(ROLE_ATTRIBUTE_IS_DN);
        this.roleAttributeIsDN = Boolean.parseBoolean(temp);
        this.roleNameAttributeID = (String)options.get(ROLE_NAME_ATTRIBUTE_ID);
        temp = (String)options.get(ALLOW_EMPTY_PASSWORD);
        this.allowEmptyPassword = Boolean.parseBoolean(temp);
    }

    public boolean login() throws LoginException {
        Object result = null;
        AuthorizeAction action = new AuthorizeAction();
        if (AUTH_TYPE_GSSAPI.equals(this.bindAuthentication)) {
            this.log.trace((Object)"Using GSSAPI to connect to LDAP");
            LoginContext lc = new LoginContext(this.jaasSecurityDomain);
            lc.login();
            Subject serverSubject = lc.getSubject();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Subject = " + serverSubject));
                this.log.debug((Object)("Logged in '" + lc + "' LoginContext"));
            }
            result = Subject.doAs(serverSubject, action);
            lc.logout();
        } else {
            result = action.run();
        }
        if (result instanceof LoginException) {
            throw (LoginException)result;
        }
        return (Boolean)result;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] roleSets = new Group[]{this.userRoles};
        return roleSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean innerLogin() throws LoginException {
        this.processIdentityAndCredential();
        this.log.trace((Object)("Identity - " + this.getIdentity().getName()));
        String bindCredential = this.bindCredential;
        if (!AUTH_TYPE_GSSAPI.equals(this.bindAuthentication) && this.jaasSecurityDomain != null && this.jaasSecurityDomain.length() > 0) {
            try {
                ObjectName serviceName = new ObjectName(this.jaasSecurityDomain);
                char[] tmp = DecodeAction.decode(bindCredential, serviceName);
                bindCredential = new String(tmp);
            }
            catch (Exception e) {
                LoginException le = new LoginException("Unabe to decode bindCredential");
                le.initCause(e);
                throw le;
            }
        }
        Context searchContext = null;
        try {
            searchContext = this.constructLdapContext(this.bindDn, bindCredential, this.bindAuthentication);
            this.log.debug((Object)"Obtained LdapContext");
            String userDN = this.findUserDN((LdapContext)searchContext);
            if (!this.loginOk) {
                this.authenticate(userDN);
            }
            if (this.loginOk) {
                this.rolesSearch((LdapContext)searchContext, userDN);
            }
        }
        finally {
            if (searchContext != null) {
                try {
                    searchContext.close();
                }
                catch (NamingException e) {
                    this.log.warn((Object)"Error closing context", (Throwable)e);
                }
            }
        }
        return this.loginOk;
    }

    protected void processIdentityAndCredential() throws LoginException {
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    this.log.debug((Object)"Failed to create principal", (Throwable)e);
                    throw new LoginException("Failed to create principal: " + e.getMessage());
                }
            }
        } else {
            try {
                NameCallback nc = new NameCallback("User name: ", "guest");
                PasswordCallback pc = new PasswordCallback("Password: ", false);
                Callback[] callbacks = new Callback[]{nc, pc};
                this.callbackHandler.handle(callbacks);
                String username = nc.getName();
                this.identity = this.createIdentity(username);
                this.credential = pc.getPassword();
                pc.clearPassword();
            }
            catch (Exception e) {
                LoginException le = new LoginException("Unable to obtain username/credential");
                le.initCause(e);
                throw le;
            }
        }
    }

    protected LdapContext constructLdapContext(String dn, Object credential, String authentication) throws LoginException {
        Properties env = this.createBaseProperties();
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = DEFAULT_LDAP_CTX_FACTORY;
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if (authentication != null && authentication.length() > 0) {
            env.setProperty("java.naming.security.authentication", authentication);
        } else {
            String authType = env.getProperty("java.naming.security.authentication");
            if (authType == null) {
                env.setProperty("java.naming.security.authentication", AUTH_TYPE_SIMPLE);
            }
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = (String)this.options.get("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = PROTOCOL_SSL.equals(protocol) ? DEFAULT_SSL_URL : DEFAULT_URL;
            env.setProperty("java.naming.provider.url", providerURL);
        }
        if (dn != null) {
            env.setProperty("java.naming.security.principal", dn);
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        this.traceLdapEnv(env);
        try {
            return new InitialLdapContext(env, null);
        }
        catch (NamingException e) {
            LoginException le = new LoginException("Unable to create new InitialLdapContext");
            le.initCause(e);
            throw le;
        }
    }

    protected Properties createBaseProperties() {
        Properties env = new Properties();
        for (Map.Entry entry : this.options.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        return env;
    }

    protected String findUserDN(LdapContext ctx) throws LoginException {
        if (this.baseCtxDN == null) {
            return this.getIdentity().getName();
        }
        try {
            NamingEnumeration<SearchResult> results = null;
            Object[] filterArgs = new Object[]{this.getIdentity().getName()};
            results = ctx.search(this.baseCtxDN, this.baseFilter, filterArgs, this.userSearchControls);
            if (!results.hasMore()) {
                results.close();
                throw new LoginException("Search of baseDN(" + this.baseCtxDN + ") found no matches");
            }
            SearchResult sr = results.next();
            String name = sr.getName();
            String userDN = null;
            if (!sr.isRelative()) {
                throw new LoginException("Can't follow referal for authentication: " + name);
            }
            userDN = name + "," + this.baseCtxDN;
            results.close();
            results = null;
            this.log.trace((Object)("findUserDN - " + userDN));
            return userDN;
        }
        catch (NamingException e) {
            LoginException le = new LoginException("Unable to find user DN");
            le.initCause(e);
            throw le;
        }
    }

    protected void authenticate(String userDN) throws LoginException {
        if (this.credential.length == 0 && !this.allowEmptyPassword) {
            this.log.trace((Object)"Rejecting empty password.");
            return;
        }
        try {
            LdapContext authContext = this.constructLdapContext(userDN, this.credential, null);
            authContext.close();
        }
        catch (NamingException ne) {
            this.log.debug((Object)("Authentication failed - " + ne.getMessage()));
            LoginException le = new LoginException("Authentication failed");
            le.initCause(ne);
            throw le;
        }
        this.loginOk = true;
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", this.getIdentity().getName());
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
    }

    protected void rolesSearch(LdapContext searchContext, String dn) throws LoginException {
        Object[] filterArgs = new Object[]{this.getIdentity().getName(), dn};
        NamingEnumeration<SearchResult> results = null;
        try {
            this.log.trace((Object)("rolesCtxDN=" + this.rolesCtxDN + " roleFilter=" + this.roleFilter + " filterArgs[0]=" + filterArgs[0] + " filterArgs[1]=" + filterArgs[1]));
            if (this.roleFilter != null && this.roleFilter.length() > 0) {
                results = searchContext.search(this.rolesCtxDN, this.roleFilter, filterArgs, this.roleSearchControls);
                while (results.hasMore()) {
                    SearchResult sr = results.next();
                    String resultDN = this.canonicalize(sr.getName());
                    this.obtainRole(searchContext, resultDN);
                }
            } else {
                this.obtainRole(searchContext, dn);
            }
        }
        catch (NamingException e) {
            LoginException le = new LoginException("Error finding roles");
            le.initCause(e);
            throw le;
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException e) {
                    this.log.warn((Object)"Problem closing results", (Throwable)e);
                }
            }
        }
    }

    protected void obtainRole(LdapContext searchContext, String dn) throws NamingException, LoginException {
        this.log.trace((Object)("rolesSearch resultDN = " + dn));
        String[] attrNames = new String[]{this.roleAttributeID};
        Attributes result = searchContext.getAttributes(dn, attrNames);
        if (result != null && result.size() > 0) {
            Attribute roles = result.get(this.roleAttributeID);
            for (int n = 0; n < roles.size(); ++n) {
                String roleName = (String)roles.get(n);
                if (this.roleAttributeIsDN) {
                    String baseRoleDN = roleName;
                    String roleDN = "\"" + baseRoleDN + "\"";
                    this.loadRoleByRoleNameAttributeID(searchContext, roleDN);
                    this.recurseRolesSearch(searchContext, baseRoleDN);
                    continue;
                }
                this.addRole(roleName);
            }
        }
    }

    protected void loadRoleByRoleNameAttributeID(LdapContext searchContext, String roleDN) {
        String[] returnAttribute = new String[]{this.roleNameAttributeID};
        this.log.trace((Object)("Using roleDN: " + roleDN));
        try {
            Attributes result2 = searchContext.getAttributes(roleDN, returnAttribute);
            Attribute roles2 = result2.get(this.roleNameAttributeID);
            if (roles2 != null) {
                for (int m = 0; m < roles2.size(); ++m) {
                    String roleName = (String)roles2.get(m);
                    this.addRole(roleName);
                }
            }
        }
        catch (NamingException e) {
            this.log.trace((Object)"Failed to query roleNameAttrName", (Throwable)e);
        }
    }

    protected void recurseRolesSearch(LdapContext searchContext, String roleDN) throws LoginException {
        if (this.recurseRoles) {
            if (!this.processedRoleDNs.contains(roleDN)) {
                this.processedRoleDNs.add(roleDN);
                this.log.trace((Object)("Recursive search for '" + roleDN + "'"));
                this.rolesSearch(searchContext, roleDN);
            } else {
                this.log.trace((Object)("Already visited role '" + roleDN + "' ending recursion."));
            }
        }
    }

    protected void traceLdapEnv(Properties env) {
        if (this.log.isTraceEnabled()) {
            Properties tmp = new Properties();
            tmp.putAll((Map<?, ?>)env);
            String credentials = tmp.getProperty("java.naming.security.credentials");
            if (credentials != null && credentials.length() > 0) {
                tmp.setProperty("java.naming.security.credentials", "***");
            }
            this.log.trace((Object)("Logging into LDAP server, env=" + tmp.toString()));
        }
    }

    protected String canonicalize(String searchResult) {
        String result = searchResult;
        int len = searchResult.length();
        result = searchResult.endsWith("\"") ? searchResult.substring(0, len - 1) + "," + this.rolesCtxDN + "\"" : searchResult + "," + this.rolesCtxDN;
        return result;
    }

    private void addRole(String roleName) {
        if (roleName != null) {
            try {
                Principal p = super.createIdentity(roleName);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Assign user '" + this.getIdentity().getName() + "' to role " + roleName));
                }
                this.userRoles.addMember(p);
            }
            catch (Exception e) {
                this.log.debug((Object)("Failed to create principal: " + roleName), (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuthorizeAction
    implements PrivilegedAction<Object> {
        private AuthorizeAction() {
        }

        @Override
        public Object run() {
            try {
                return AdvancedLdapLoginModule.this.innerLogin();
            }
            catch (LoginException e) {
                return e;
            }
        }
    }
}

