/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBException;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.annotation.SerializedConcurrentAccess;
import org.jboss.ejb3.aop.AbstractInterceptor;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.stateful.StatefulRemoveInterceptor;
import org.jboss.logging.Logger;

public class StatefulInstanceInterceptor
extends AbstractInterceptor {
    private static final Logger log = Logger.getLogger(StatefulInstanceInterceptor.class);

    @Override
    public String getName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object object;
        boolean block;
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        Object id = ejb.getId();
        StatefulContainer container = (StatefulContainer)StatefulInstanceInterceptor.getEJBContainer(invocation);
        StatefulBeanContext target = container.getCache().get(id);
        boolean bl = block = container.getAnnotation(SerializedConcurrentAccess.class) != null;
        if (block) {
            target.getLock().lockInterruptibly();
        } else {
            object = target;
            synchronized (object) {
                if (target.isInInvocation()) {
                    throw new ConcurrentAccessException("no concurrent calls on stateful bean '" + container.getName() + "' (EJB3 4.3.13)");
                }
                target.setInInvocation(true);
            }
        }
        ejb.setBeanContext(target);
        StatefulBeanContext.currentBean.push(target);
        container.pushContext(target);
        try {
            if (target.isDiscarded()) {
                throw new EJBException("SFSB was discarded by another thread");
            }
            object = ejb.invokeNext();
            return object;
        }
        catch (Exception ex) {
            if (StatefulRemoveInterceptor.isApplicationException(ex, (MethodInvocation)invocation)) {
                throw ex;
            }
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing bean " + id + " because of exception"), (Throwable)ex);
                }
                container.getCache().remove(id);
                target.setDiscarded(true);
            }
            throw ex;
        }
        finally {
            container.popContext();
            StatefulBeanContext.currentBean.pop();
            StatefulBeanContext statefulBeanContext = target;
            synchronized (statefulBeanContext) {
                target.setInInvocation(false);
                if (!target.isTxSynchronized() && !target.isDiscarded()) {
                    container.getCache().release(target);
                }
                if (block) {
                    target.getLock().unlock();
                }
            }
        }
    }
}

