/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.jboss.jms.client.remoting.CallbackManager;
import org.jboss.jms.delegate.ConsumerDelegate;
import org.jboss.jms.delegate.DefaultCancel;
import org.jboss.jms.delegate.DeliveryInfo;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.message.MessageProxy;
import org.jboss.jms.wireformat.ClientDelivery;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.prioritylinkedlist.BasicPriorityLinkedList;
import org.jboss.messaging.util.prioritylinkedlist.PriorityLinkedList;

public class ClientConsumer {
    private static final Logger log = Logger.getLogger(ClientConsumer.class);
    private static boolean trace = log.isTraceEnabled();
    private static boolean debug = log.isDebugEnabled();
    private static final int WAIT_TIMEOUT = 30000;
    private PriorityLinkedList buffer;
    private SessionDelegate sessionDelegate;
    private ConsumerDelegate consumerDelegate;
    private String consumerID;
    private boolean isConnectionConsumer;
    private volatile Thread receiverThread;
    private MessageListener listener;
    private int ackMode;
    private boolean closed;
    private Object mainLock;
    private Executor sessionExecutor;
    private boolean listenerRunning;
    private int maxDeliveries;
    private String queueName;
    private long lastDeliveryId = -1L;
    private int bufferSize;
    private boolean waitingForLastDelivery;
    private boolean shouldAck;
    private long redeliveryDelay;
    private volatile int currentToken;
    private boolean paused;
    private int consumeCount;
    private boolean firstTime = true;
    private volatile Thread onMessageThread;
    private ExecutorService pool = Executors.newCachedThreadPool();
    private long maxRetryChangeRate;
    private long retryChangeRateInterval;
    private boolean abortReceive;
    private Object consumerLock;
    private Object messageSource;
    private boolean isClustered = false;
    private long minTimeoutProcessTime;

    private static boolean checkExpiredOrReachedMaxdeliveries(MessageProxy proxy, SessionDelegate del, int maxDeliveries, boolean shouldCancel) {
        boolean reachedMaxDeliveries;
        JBossMessage msg = proxy.getMessage();
        boolean expired = msg.isExpired();
        boolean bl = reachedMaxDeliveries = proxy.getDeliveryCount() == maxDeliveries;
        if (expired || reachedMaxDeliveries) {
            if (expired) {
                if (debug) {
                    log.debug((Object)(proxy.getMessage() + " has expired, cancelling to server"));
                }
            } else if (debug) {
                log.debug((Object)(proxy.getMessage() + " has reached maximum delivery number " + maxDeliveries + ", cancelling to server"));
            }
            if (shouldCancel) {
                DefaultCancel cancel = new DefaultCancel(proxy.getDeliveryId(), proxy.getDeliveryCount(), expired, reachedMaxDeliveries);
                try {
                    del.cancelDelivery(cancel);
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to cancel delivery", (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    public static void callOnMessageStatic(SessionDelegate sess, MessageListener listener, String consumerID, String queueName, boolean isConnectionConsumer, MessageProxy m, int ackMode, int maxDeliveries, SessionDelegate connectionConsumerSession, boolean shouldAck) throws JMSException {
        block9: {
            if (ClientConsumer.checkExpiredOrReachedMaxdeliveries(m, connectionConsumerSession != null ? connectionConsumerSession : sess, maxDeliveries, shouldAck)) {
                return;
            }
            DeliveryInfo deliveryInfo = new DeliveryInfo(m, consumerID, queueName, connectionConsumerSession, shouldAck, null);
            m.incDeliveryCount();
            if (!isConnectionConsumer) {
                sess.preDeliver(deliveryInfo);
            }
            try {
                if (trace) {
                    log.trace((Object)("calling listener's onMessage(" + m + ")"));
                }
                listener.onMessage((Message)m);
                if (trace) {
                    log.trace((Object)"listener's onMessage() finished");
                }
            }
            catch (RuntimeException e) {
                long id = m.getMessage().getMessageID();
                log.error((Object)("RuntimeException was thrown from onMessage, " + id + " will be redelivered"), (Throwable)e);
                if (ackMode != 1 && ackMode != 3) break block9;
                sess.recover();
            }
        }
        if (!isConnectionConsumer) {
            if (trace) {
                log.trace((Object)"Calling postDeliver");
            }
            sess.postDeliver();
            if (trace) {
                log.trace((Object)"Called postDeliver");
            }
        }
    }

    public void callOnMessage(SessionDelegate sess, MessageListener listener, String consumerID, String queueName, boolean isConnectionConsumer, MessageProxy m, int ackMode, int maxDeliveries, SessionDelegate connectionConsumerSession, boolean shouldAck) throws JMSException {
        block9: {
            if (ClientConsumer.checkExpiredOrReachedMaxdeliveries(m, connectionConsumerSession != null ? connectionConsumerSession : sess, maxDeliveries, shouldAck)) {
                return;
            }
            DeliveryInfo deliveryInfo = new DeliveryInfo(m, consumerID, queueName, connectionConsumerSession, shouldAck, m.getSource());
            m.incDeliveryCount();
            if (!isConnectionConsumer && !sess.preDeliver(deliveryInfo)) {
                return;
            }
            try {
                if (trace) {
                    log.trace((Object)("calling listener's onMessage(" + m + ")"));
                }
                this.onMessageThread = Thread.currentThread();
                listener.onMessage((Message)m);
                if (trace) {
                    log.trace((Object)"listener's onMessage() finished");
                }
            }
            catch (RuntimeException e) {
                long id = m.getMessage().getMessageID();
                log.error((Object)("RuntimeException was thrown from onMessage, " + id + " will be redelivered"), (Throwable)e);
                if (ackMode != 1 && ackMode != 3) break block9;
                sess.recover();
            }
        }
        if (!isConnectionConsumer) {
            if (trace) {
                log.trace((Object)"Calling postDeliver");
            }
            sess.postDeliver();
            if (trace) {
                log.trace((Object)"Called postDeliver");
            }
        }
    }

    public int getBufferSize() {
        return this.buffer.size();
    }

    public ClientConsumer(boolean isCC, int ackMode, SessionDelegate sess, ConsumerDelegate cons, String consumerID, String queueName, int bufferSize, Executor sessionExecutor, int maxDeliveries, boolean shouldAck, long redeliveryDelay, long maxRetryChangeRate, long retryChangeRateInterval, boolean isClustered, CallbackManager cbManager, long minTimeoutProcessTime) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException(this + " bufferSize must be > 0");
        }
        this.bufferSize = bufferSize;
        this.buffer = new BasicPriorityLinkedList(10);
        this.isConnectionConsumer = isCC;
        this.ackMode = ackMode;
        this.sessionDelegate = sess;
        this.consumerDelegate = cons;
        this.consumerID = consumerID;
        this.queueName = queueName;
        this.mainLock = new Object();
        this.sessionExecutor = sessionExecutor;
        this.maxDeliveries = maxDeliveries;
        this.shouldAck = shouldAck;
        this.redeliveryDelay = redeliveryDelay;
        this.maxRetryChangeRate = maxRetryChangeRate;
        this.retryChangeRateInterval = retryChangeRateInterval;
        this.isClustered = isClustered;
        if (isClustered) {
            this.consumerLock = new Object();
        }
        this.messageSource = cbManager;
        this.minTimeoutProcessTime = minTimeoutProcessTime;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void handleMessage(Object message, CallbackManager cbManager) throws Exception {
        ClientDelivery del = (ClientDelivery)message;
        JBossMessage msg = (JBossMessage)del.getMessage();
        MessageProxy proxy = JBossMessage.createThinDelegate(del.getDeliveryId(), msg, del.getDeliveryCount());
        JBossDestination dest = (JBossDestination)proxy.getJMSDestination();
        if (dest.isDirect() && !this.consumerDelegate.getDestination().isDirect()) {
            proxy.setJMSDestination(msg.getOriginalSuckerDestination());
        }
        proxy.setSource(cbManager);
        this.sessionExecutor.execute(new HandleMessageRunnable(this.currentToken, proxy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener listener) throws JMSException {
        Object object = this.mainLock;
        synchronized (object) {
            if (this.receiverThread != null) {
                throw new IllegalStateException("Consumer is currently in receive(..). Cannot set MessageListener");
            }
            this.listener = listener;
            if (listener != null && !this.buffer.isEmpty()) {
                this.listenerRunning = true;
                this.queueRunner(new ListenerRunner());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBuffer() throws JMSException {
        if (trace) {
            log.trace((Object)("Cancelling buffer: " + this.buffer.size()));
        }
        Object object = this.mainLock;
        synchronized (object) {
            if (this.shouldAck && !this.buffer.isEmpty()) {
                ArrayList<DefaultCancel> cancels = new ArrayList<DefaultCancel>();
                ListIterator i = this.buffer.iterator();
                while (i.hasNext()) {
                    MessageProxy mp = (MessageProxy)i.next();
                    DefaultCancel cancel = new DefaultCancel(mp.getDeliveryId(), mp.getDeliveryCount(), false, false);
                    cancels.add(cancel);
                }
                if (trace) {
                    log.trace((Object)"Calling cancelDeliveries");
                }
                this.sessionDelegate.cancelDeliveries(cancels);
                if (trace) {
                    log.trace((Object)"Done call");
                }
                this.buffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long lastDeliveryId) throws JMSException {
        log.trace((Object)(this + " close"));
        this.waitForLastDelivery(lastDeliveryId);
        if (this.listener != null) {
            this.setMessageListener(null);
        }
        this.waitForOnMessageToComplete();
        Object object = this.mainLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.receiverThread != null) {
                this.mainLock.notify();
            }
            this.listener = null;
        }
        this.pool.shutdownNow();
        if (trace) {
            log.trace((Object)(this + " closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public MessageProxy receive(long timeout) throws JMSException {
        MessageProxy m = null;
        Object object = this.mainLock;
        // MONITORENTER : object
        if (trace) {
            log.trace((Object)(this + " receiving, timeout = " + timeout));
        }
        if (this.closed) {
            if (trace) {
                log.trace((Object)(this + " closed, returning null"));
            }
            // MONITOREXIT : object
            return null;
        }
        if (this.listener != null) {
            throw new JMSException("The consumer has a MessageListener set, cannot call receive(..)");
        }
        this.receiverThread = Thread.currentThread();
        long startTimestamp = System.currentTimeMillis();
        try {
            while (true) {
                if (timeout == 0L) {
                    if (trace) {
                        log.trace((Object)(this + ": receive, no timeout"));
                    }
                    if ((m = this.getMessage(0L)) == null) {
                        MessageProxy messageProxy = null;
                        return messageProxy;
                    }
                } else if (timeout == -1L) {
                    if (trace) {
                        log.trace((Object)(this + ": receive, noWait"));
                    }
                    if ((m = this.getMessage(-1L)) == null) {
                        if (trace) {
                            log.trace((Object)(this + ": no message available"));
                        }
                        MessageProxy messageProxy = null;
                        return messageProxy;
                    }
                } else {
                    if (trace) {
                        log.trace((Object)(this + ": receive, timeout " + timeout + " ms, blocking poll on queue"));
                    }
                    if ((m = this.getMessage(timeout)) == null) {
                        if (trace) {
                            log.trace((Object)(this + ": " + timeout + " ms timeout expired"));
                        }
                        MessageProxy messageProxy = null;
                        return messageProxy;
                    }
                }
                if (trace) {
                    log.trace((Object)(this + " received " + m + " after being blocked on buffer"));
                }
                boolean ignore = ClientConsumer.checkExpiredOrReachedMaxdeliveries(m, this.sessionDelegate, this.maxDeliveries, this.shouldAck);
                if (!this.isConnectionConsumer && !ignore) {
                    final DeliveryInfo info = new DeliveryInfo(m, this.consumerID, this.queueName, null, this.shouldAck, m.getSource());
                    if (timeout <= 0L || this.sessionDelegate.getTransacted()) {
                        boolean bl = ignore = !this.sessionDelegate.preDeliver(info);
                        if (!ignore) {
                            ignore = !this.sessionDelegate.postDeliver();
                        }
                    } else {
                        long timeLeft;
                        Callable<Boolean> afterReceive = new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                if (!ClientConsumer.this.sessionDelegate.preDeliver(info)) {
                                    return true;
                                }
                                return !ClientConsumer.this.sessionDelegate.postDeliver();
                            }
                        };
                        Future<Boolean> f = this.pool.submit(afterReceive);
                        long tmUsed = System.currentTimeMillis() - startTimestamp;
                        long timeDelta = timeout - tmUsed;
                        long l = timeLeft = timeDelta <= this.minTimeoutProcessTime ? this.minTimeoutProcessTime : timeDelta;
                        if (trace) {
                            log.trace((Object)("Time left: " + timeLeft + " timeout " + timeout + " tmUsed " + tmUsed));
                        }
                        try {
                            ignore = f.get(timeLeft, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            log.warn((Object)"Interrupted during getting future result.", (Throwable)e);
                        }
                        catch (ExecutionException e) {
                            log.warn((Object)"received application exception.", e.getCause());
                            Throwable t = e.getCause();
                            if (t instanceof JMSException) {
                                throw (JMSException)t;
                            }
                        }
                        catch (TimeoutException e) {
                            log.warn((Object)("Timed out waiting for post message processing " + m + " within time " + timeLeft));
                            ignore = false;
                            this.sessionDelegate.processMessageTimeout();
                        }
                    }
                    if (trace) {
                        log.trace((Object)("Post deliver returned " + !ignore));
                    }
                    if (!ignore) {
                        m.incDeliveryCount();
                    }
                }
                if (!ignore) {
                    if (trace) {
                        log.trace((Object)(this + ": message " + m + " is not expired, pushing it to the caller"));
                    }
                    break;
                }
                if (trace) {
                    log.trace((Object)("Discarding message " + m));
                }
                if (timeout == 0L || (timeout -= System.currentTimeMillis() - startTimestamp) != 0L) continue;
                timeout = -1L;
            }
        }
        finally {
            this.receiverThread = null;
        }
        // MONITOREXIT : object
        if (!trace) return m;
        log.trace((Object)(this + " receive() returning " + m));
        return m;
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public String toString() {
        return "ClientConsumer[" + this.consumerID + "]";
    }

    public String getConsumerId() {
        return this.consumerID;
    }

    public void setConsumerId(String consumerId) {
        this.consumerID = consumerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToFrontOfBuffer(MessageProxy proxy) throws Exception {
        Object object = this.mainLock;
        synchronized (object) {
            proxy.setSource(this.messageSource);
            this.buffer.addFirst(proxy, proxy.getJMSPriority());
            --this.consumeCount;
            this.messageAdded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeWith(ClientConsumer newHandler) {
        ++this.currentToken;
        this.consumerID = newHandler.consumerID;
        Object object = this.consumerLock;
        synchronized (object) {
            this.messageSource = newHandler.messageSource;
            this.buffer.clear();
        }
        this.consumeCount = 0;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.mainLock;
        synchronized (object) {
            this.paused = true;
            this.sendChangeRateMessage(0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.mainLock;
        synchronized (object) {
            this.paused = false;
            if (this.firstTime) {
                this.consumeCount = 0;
                this.firstTime = false;
            } else {
                this.consumeCount = this.bufferSize / 3 - this.buffer.size();
            }
            this.sendChangeRateMessage(1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLastDelivery(long id) {
        if (trace) {
            log.trace((Object)("Waiting for last delivery id " + id));
        }
        if (id == -1L) {
            return;
        }
        Object object = this.mainLock;
        synchronized (object) {
            this.waitingForLastDelivery = true;
            try {
                long start;
                for (long wait = 30000L; this.lastDeliveryId != id && wait > 0L; wait -= System.currentTimeMillis() - start) {
                    start = System.currentTimeMillis();
                    try {
                        this.mainLock.wait(wait);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (trace && this.lastDeliveryId == id) {
                    log.trace((Object)"Got last delivery");
                }
                if (this.lastDeliveryId != id) {
                    log.warn((Object)("Timed out waiting for last delivery " + id + " got " + this.lastDeliveryId));
                }
            }
            finally {
                this.waitingForLastDelivery = false;
            }
        }
    }

    public void sendChangeRateMessage(float newRate) {
        try {
            this.consumerDelegate.changeRate(newRate);
        }
        catch (JMSException e) {
            if (this.maxRetryChangeRate == 0L) {
                log.error((Object)"Failed to send changeRate message", (Throwable)e);
            }
            log.warn((Object)("Failed to send changeRate message, will retry with maxRetryChangeRate " + this.maxRetryChangeRate + ", retryChangeRateInterval " + this.retryChangeRateInterval + ", newRate " + newRate));
            this.retrySendChangeRateMessage(newRate);
        }
    }

    private void retrySendChangeRateMessage(float newRate) {
        int numRetry = 0;
        while (true) {
            try {
                ++numRetry;
                if (trace) {
                    log.trace((Object)("Retrying sending changeRate, numRetry " + numRetry));
                }
                this.consumerDelegate.changeRate(newRate);
                log.info((Object)("Successfully sent changeRate. Retry number: " + numRetry));
            }
            catch (JMSException ee) {
                if (this.maxRetryChangeRate > 0L && (long)numRetry >= this.maxRetryChangeRate) {
                    log.warn((Object)("Failed to send changeRate message after retry number " + numRetry), (Throwable)ee);
                    break;
                }
                try {
                    Thread.sleep(this.retryChangeRateInterval);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            break;
        }
    }

    private void waitForOnMessageToComplete() {
        if (Thread.currentThread() == this.onMessageThread) {
            return;
        }
        org.jboss.messaging.util.Future result = new org.jboss.messaging.util.Future();
        this.sessionExecutor.execute(new Closer(result));
        if (trace) {
            log.trace((Object)(this + " blocking wait for Closer execution"));
        }
        result.getResult();
        if (trace) {
            log.trace((Object)(this + " got Closer result"));
        }
    }

    private void queueRunner(ListenerRunner runner) {
        this.sessionExecutor.execute(runner);
    }

    private void messageAdded() {
        boolean notified = false;
        if (trace) {
            log.trace((Object)("Receiver thread:" + this.receiverThread + " listener:" + this.listener + " listenerRunning:" + this.listenerRunning + " sessionExecutor:" + this.sessionExecutor));
        }
        if (this.receiverThread != null) {
            if (trace) {
                log.trace((Object)(this + " notifying receiver/waiter thread"));
            }
            this.mainLock.notifyAll();
            notified = true;
        } else if (this.listener != null && !this.listenerRunning) {
            this.listenerRunning = true;
            if (trace) {
                log.trace((Object)(this + " scheduled a new ListenerRunner"));
            }
            this.queueRunner(new ListenerRunner());
        }
        if (this.waitingForLastDelivery && !notified) {
            if (trace) {
                log.trace((Object)"Notifying");
            }
            this.mainLock.notifyAll();
        }
    }

    private long waitOnLock(Object lock, long waitTime) throws InterruptedException {
        long start = System.currentTimeMillis();
        lock.wait(waitTime);
        long waited = System.currentTimeMillis() - start;
        if (waited < waitTime) {
            return waitTime -= waited;
        }
        return 0L;
    }

    private MessageProxy getMessage(long timeout) {
        block11: {
            if (timeout != -1L) {
                try {
                    if (timeout == 0L) {
                        while (!this.closed && this.buffer.isEmpty() && !this.abortReceive) {
                            if (trace) {
                                log.trace((Object)(this + " waiting on main lock, no timeout"));
                            }
                            this.mainLock.wait();
                            if (!this.buffer.isEmpty() || !this.abortReceive) {
                                if (!trace) continue;
                                log.trace((Object)(this + " done waiting on main lock"));
                                continue;
                            }
                            break block11;
                        }
                        break block11;
                    }
                    long toWait = timeout;
                    while (!this.closed && this.buffer.isEmpty() && toWait > 0L) {
                        if (trace) {
                            log.trace((Object)(this + " waiting on main lock, timeout " + toWait + " ms"));
                        }
                        toWait = this.waitOnLock(this.mainLock, toWait);
                        if (!trace) continue;
                        log.trace((Object)(this + " done waiting on lock, buffer is " + (this.buffer.isEmpty() ? "" : "NOT ") + "empty"));
                    }
                }
                catch (InterruptedException e) {
                    if (trace) {
                        log.trace((Object)("InterruptedException, " + this + ".getMessage() returning null"));
                    }
                    return null;
                }
            }
        }
        MessageProxy m = null;
        if (!this.closed && !this.buffer.isEmpty()) {
            m = (MessageProxy)this.buffer.removeFirst();
            this.checkSendChangeRate();
        }
        return m;
    }

    private void checkSendChangeRate() {
        ++this.consumeCount;
        if (!this.paused && this.consumeCount == this.bufferSize) {
            this.consumeCount = 0;
            this.sendChangeRateMessage(1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortReceive() {
        Object object = this.mainLock;
        synchronized (object) {
            log.error((Object)(this + " The connection is about to be aborted, stop the blocking receiving."));
            this.abortReceive = true;
            this.mainLock.notifyAll();
        }
    }

    private class ListenerRunner
    implements Runnable {
        private ListenerRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MessageProxy mp = null;
            MessageListener theListener = null;
            Object object = ClientConsumer.this.mainLock;
            synchronized (object) {
                if (ClientConsumer.this.listener == null || ClientConsumer.this.buffer.isEmpty()) {
                    ClientConsumer.this.listenerRunning = false;
                    if (trace) {
                        log.trace((Object)"no listener or buffer is empty, returning");
                    }
                    return;
                }
                theListener = ClientConsumer.this.listener;
                mp = (MessageProxy)ClientConsumer.this.buffer.removeFirst();
                ClientConsumer.this.checkSendChangeRate();
            }
            if (mp != null) {
                try {
                    ClientConsumer.this.callOnMessage(ClientConsumer.this.sessionDelegate, theListener, ClientConsumer.this.consumerID, ClientConsumer.this.queueName, false, mp, ClientConsumer.this.ackMode, ClientConsumer.this.maxDeliveries, null, ClientConsumer.this.shouldAck);
                    if (trace) {
                        log.trace((Object)"Called callonMessage");
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Failed to deliver message", t);
                }
            }
            object = ClientConsumer.this.mainLock;
            synchronized (object) {
                if (!ClientConsumer.this.buffer.isEmpty()) {
                    if (trace) {
                        log.trace((Object)"More messages in buffer so queueing next onMessage to run");
                    }
                    ClientConsumer.this.queueRunner(this);
                    if (trace) {
                        log.trace((Object)"Queued next onMessage to run");
                    }
                } else {
                    if (trace) {
                        log.trace((Object)"no more messages in buffer, marking listener as not running");
                    }
                    ClientConsumer.this.listenerRunning = false;
                }
            }
            if (trace) {
                log.trace((Object)"Exiting run()");
            }
        }
    }

    private class HandleMessageRunnable
    implements Runnable {
        private int token;
        private MessageProxy proxy;

        HandleMessageRunnable(int token, MessageProxy proxy) {
            this.token = token;
            this.proxy = proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (trace) {
                    log.trace((Object)(this + " receiving message " + this.proxy + " from the remoting layer"));
                }
                Object object = ClientConsumer.this.mainLock;
                synchronized (object) {
                    if (ClientConsumer.this.closed) {
                        throw new IllegalStateException(this + " is closed, so ignoring message");
                    }
                    if (this.token != ClientConsumer.this.currentToken) {
                        log.trace((Object)("Ignoring message " + this.proxy));
                        return;
                    }
                    this.proxy.setSessionDelegate(ClientConsumer.this.sessionDelegate, ClientConsumer.this.isConnectionConsumer);
                    this.proxy.getMessage().doBeforeReceive();
                    if (ClientConsumer.this.isClustered) {
                        Object object2 = ClientConsumer.this.consumerLock;
                        synchronized (object2) {
                            if (this.proxy.getSource() == ClientConsumer.this.messageSource) {
                                ClientConsumer.this.buffer.addLast(this.proxy, this.proxy.getJMSPriority());
                                ClientConsumer.this.lastDeliveryId = this.proxy.getDeliveryId();
                                if (trace) {
                                    log.trace((Object)(this + " added message(s) to the buffer are now " + ClientConsumer.this.buffer.size() + " messages"));
                                }
                                ClientConsumer.this.messageAdded();
                            } else {
                                log.debug((Object)("Discarding message from old source " + this.proxy.getSource() + " on to new source " + ClientConsumer.this.messageSource));
                            }
                        }
                    } else {
                        ClientConsumer.this.buffer.addLast(this.proxy, this.proxy.getJMSPriority());
                        ClientConsumer.this.lastDeliveryId = this.proxy.getDeliveryId();
                        if (trace) {
                            log.trace((Object)(this + " added message(s) to the buffer are now " + ClientConsumer.this.buffer.size() + " messages"));
                        }
                        ClientConsumer.this.messageAdded();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to handle message", (Throwable)e);
            }
        }
    }

    private class Closer
    implements Runnable {
        org.jboss.messaging.util.Future result;

        Closer(org.jboss.messaging.util.Future result) {
            this.result = result;
        }

        public void run() {
            if (trace) {
                log.trace((Object)"Closer starts running");
            }
            this.result.setResult(null);
            if (trace) {
                log.trace((Object)"Closer finished run");
            }
        }
    }
}

