/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.delegate;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.messaging.util.Streamable;

public class TopologyResult
implements Streamable {
    private ClientConnectionFactoryDelegate[] delegates;
    private Map failoverMap;
    String uniqueName;

    public TopologyResult() {
    }

    public TopologyResult(String uniqueName, ClientConnectionFactoryDelegate[] delegates, Map failoverMap) {
        this.uniqueName = uniqueName;
        this.delegates = delegates;
        this.failoverMap = failoverMap;
    }

    public ClientConnectionFactoryDelegate[] getDelegates() {
        return this.delegates;
    }

    public void setDelegates(ClientConnectionFactoryDelegate[] delegates) {
        this.delegates = delegates;
    }

    public Map getFailoverMap() {
        return this.failoverMap;
    }

    public void setFailoverMap(Map failoverMap) {
        this.failoverMap = failoverMap;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public void read(DataInputStream is) throws Exception {
        this.uniqueName = is.readUTF();
        int len = is.readInt();
        this.delegates = new ClientConnectionFactoryDelegate[len];
        for (int i = 0; i < len; ++i) {
            this.delegates[i] = new ClientConnectionFactoryDelegate();
            this.delegates[i].read(is);
        }
        len = is.readInt();
        this.failoverMap = new HashMap(len);
        for (int c = 0; c < len; ++c) {
            Integer i = new Integer(is.readInt());
            Integer j = new Integer(is.readInt());
            this.failoverMap.put(i, j);
        }
    }

    public void write(DataOutputStream os) throws Exception {
        os.writeUTF(this.uniqueName);
        int len = this.delegates.length;
        os.writeInt(len);
        for (int i = 0; i < len; ++i) {
            this.delegates[i].write(os);
        }
        os.writeInt(this.failoverMap.size());
        for (Map.Entry entry : this.failoverMap.entrySet()) {
            Integer i = (Integer)entry.getKey();
            Integer j = (Integer)entry.getValue();
            os.writeInt(i);
            os.writeInt(j);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("UpdateConnectionFactoryResult[");
        if (this.delegates != null) {
            for (int i = 0; i < this.delegates.length; ++i) {
                sb.append(this.delegates[i]);
                if (i >= this.delegates.length - 1) continue;
                sb.append(',');
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

