/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.clusterconnection;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.TimedCallable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jboss.jms.client.JBossConnection;
import org.jboss.jms.client.JBossConnectionFactory;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Binding;
import org.jboss.messaging.core.contract.ClusterNotification;
import org.jboss.messaging.core.contract.ClusterNotificationListener;
import org.jboss.messaging.core.contract.PostOffice;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.core.contract.Replicator;
import org.jboss.messaging.core.impl.clusterconnection.MessageSucker;

public class ClusterConnectionManager
implements ClusterNotificationListener {
    private static final Logger log = Logger.getLogger(ClusterConnectionManager.class);
    private static final long CLOSE_TIMEOUT = 2000L;
    private static boolean trace = log.isTraceEnabled();
    private Map connections = new HashMap();
    private boolean started;
    private int nodeID;
    private String connectionFactoryUniqueName;
    private Replicator replicator;
    private PostOffice postOffice;
    private boolean preserveOrdering;
    private String suckerUser;
    private String suckerPassword;
    private int maxRetry;
    private int retryInterval;

    public ClusterConnectionManager(int nodeID, String connectionFactoryUniqueName, boolean preserveOrdering, String suckerUser, String suckerPassword, int maxRetry, int retryInterval) {
        this.nodeID = nodeID;
        this.connectionFactoryUniqueName = connectionFactoryUniqueName;
        this.preserveOrdering = preserveOrdering;
        this.suckerUser = suckerUser;
        this.suckerPassword = suckerPassword;
        this.maxRetry = maxRetry;
        this.retryInterval = retryInterval;
        if (trace) {
            log.trace((Object)("Created " + this));
        }
    }

    public void injectReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    public void injectPostOffice(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (trace) {
            log.trace((Object)(this + " started"));
        }
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        for (ConnectionInfo info : this.connections.values()) {
            info.close();
        }
        this.connections.clear();
        this.started = false;
        if (trace) {
            log.trace((Object)(this + " stopped"));
        }
    }

    public Map getAllConnections() {
        return this.connections;
    }

    public void resetAllSuckers() {
        for (ConnectionInfo conn : this.connections.values()) {
            conn.resetAllSuckers();
        }
    }

    public void closeAllSuckers() {
        for (ConnectionInfo conn : this.connections.values()) {
            conn.closeAllSuckers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notify(ClusterNotification notification) {
        block33: {
            if (this.replicator == null) {
                return;
            }
            if (trace) {
                log.trace((Object)(this + " notification received " + notification));
            }
            try {
                ConnectionInfo conn;
                if (notification.type == 6 && notification.data instanceof String) {
                    String uniqueName;
                    String key = (String)notification.data;
                    if (!key.startsWith("CF_") || !(uniqueName = key.substring("CF_".length())).equals(this.connectionFactoryUniqueName)) break block33;
                    log.trace((Object)(this + " deployment of ClusterConnectionFactory"));
                    ClusterConnectionManager clusterConnectionManager = this;
                    synchronized (clusterConnectionManager) {
                        this.ensureAllConnectionsCreated();
                        this.createAllSuckers();
                        break block33;
                    }
                }
                if (notification.type == 7 && notification.data instanceof String) {
                    String uniqueName;
                    String key = (String)notification.data;
                    if (key.startsWith("CF_") && (uniqueName = key.substring("CF_".length())).equals(this.connectionFactoryUniqueName)) {
                        Map updatedReplicantMap = this.replicator.get((Serializable)((Object)key));
                        ArrayList<Integer> toRemove = new ArrayList<Integer>();
                        for (Map.Entry entry : this.connections.entrySet()) {
                            Integer nid = (Integer)entry.getKey();
                            if (updatedReplicantMap.get(nid) != null) continue;
                            toRemove.add(nid);
                        }
                        for (Integer nid : toRemove) {
                            ConnectionInfo info = (ConnectionInfo)this.connections.remove(nid);
                            info.close();
                        }
                    }
                } else if (notification.type == 0) {
                    String queueName = (String)notification.data;
                    if (trace) {
                        log.trace((Object)(this + " bind of queue " + queueName));
                    }
                    if (notification.nodeID == this.nodeID) {
                        if (trace) {
                            log.trace((Object)(this + " Local bind"));
                        }
                        this.ensureAllConnectionsCreated();
                        Collection bindings = this.postOffice.getAllBindingsForQueueName(queueName);
                        Iterator iter = bindings.iterator();
                        if (trace) {
                            log.trace((Object)(this + " Looking for remote bindings"));
                        }
                        while (iter.hasNext()) {
                            Binding binding = (Binding)iter.next();
                            if (trace) {
                                log.trace((Object)(this + " Remote binding is " + binding));
                            }
                            if (binding.queue.getNodeID() == this.nodeID) continue;
                            if (trace) {
                                log.trace((Object)(this + " Creating sucker"));
                            }
                            this.createSucker(queueName, binding.queue.getNodeID());
                        }
                    } else {
                        if (trace) {
                            log.trace((Object)(this + " Remote bind"));
                        }
                        this.ensureAllConnectionsCreated();
                        Binding localBinding = this.postOffice.getBindingForQueueName(queueName);
                        if (localBinding == null) {
                            if (trace) {
                                log.trace((Object)(this + " There's no local binding"));
                            }
                        } else {
                            if (trace) {
                                log.trace((Object)(this + " Creating sucker"));
                            }
                            this.createSucker(queueName, notification.nodeID);
                        }
                    }
                } else if (notification.type == 1) {
                    String queueName = (String)notification.data;
                    if (notification.nodeID == this.nodeID) {
                        this.removeAllSuckers(queueName);
                    } else {
                        this.removeSucker(queueName, notification.nodeID);
                    }
                } else if (notification.type == 8 && (conn = (ConnectionInfo)this.connections.remove(notification.nodeID)) != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to process notification", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "ClusterConnectionManager:" + System.identityHashCode(this) + " nodeID: " + this.nodeID + " connectionFactoryName: " + this.connectionFactoryUniqueName;
    }

    private void ensureAllConnectionsCreated() throws Exception {
        Map updatedReplicantMap = this.replicator.get((Serializable)((Object)("CF_" + this.connectionFactoryUniqueName)));
        for (Map.Entry entry : updatedReplicantMap.entrySet()) {
            Integer nid = (Integer)entry.getKey();
            ClientConnectionFactoryDelegate delegate = (ClientConnectionFactoryDelegate)entry.getValue();
            if (this.connections.get(nid) != null) continue;
            try {
                ConnectionInfo info = new ConnectionInfo(new JBossConnectionFactory(delegate), this.suckerUser, this.suckerPassword, nid == this.nodeID, this.maxRetry, this.retryInterval);
                log.trace((Object)(this + " created connection info " + info));
                this.connections.put(nid, info);
                info.start();
            }
            catch (Exception e) {
                log.error((Object)"Failed to start connection info ", (Throwable)e);
            }
        }
    }

    private void createSucker(String queueName, int nodeID) throws Exception {
        log.debug((Object)("createSucker " + queueName + " nodeID=" + nodeID));
        ConnectionInfo info = (ConnectionInfo)this.connections.get(new Integer(nodeID));
        if (info == null) {
            if (trace) {
                log.trace((Object)("Cluster pull connection factory has not yet been deployed on node " + nodeID));
            }
            return;
        }
        ConnectionInfo localInfo = (ConnectionInfo)this.connections.get(new Integer(this.nodeID));
        if (localInfo == null) {
            if (trace) {
                log.trace((Object)"Cluster pull connection factory has not yet been deployed on local node");
            }
            return;
        }
        if (!info.hasSucker(queueName)) {
            if (trace) {
                log.trace((Object)("Creating Sucker for queue " + queueName + " node " + nodeID));
            }
            Binding binding = this.postOffice.getBindingForQueueName(queueName);
            Queue localQueue = binding.queue;
            if (localQueue.isClustered()) {
                Collection coll = this.postOffice.getAllBindingsForQueueName(queueName);
                Iterator iter = coll.iterator();
                long sourceChannelID = -1L;
                while (iter.hasNext()) {
                    Binding b = (Binding)iter.next();
                    if (b.queue.getNodeID() != nodeID) continue;
                    sourceChannelID = b.queue.getChannelID();
                }
                if (sourceChannelID == -1L) {
                    throw new IllegalArgumentException("Cannot find source channel id");
                }
                MessageSucker sucker = new MessageSucker(localQueue, info.session, localInfo.session, this.preserveOrdering, sourceChannelID);
                info.addSucker(sucker);
                sucker.start();
                if (trace) {
                    log.trace((Object)"Started it");
                }
            }
        } else if (trace) {
            log.trace((Object)("Sucker for queue " + queueName + " node " + nodeID + " already exists, not creating it"));
        }
    }

    private void removeSucker(String queueName, int nodeID) {
        log.debug((Object)("removeSucker " + queueName + " nodeID=" + nodeID));
        ConnectionInfo info = (ConnectionInfo)this.connections.get(new Integer(nodeID));
        if (info == null) {
            return;
        }
        MessageSucker sucker = info.removeSucker(queueName);
        if (sucker != null) {
            sucker.stop();
        }
    }

    private void removeAllSuckers(String queueName) {
        log.debug((Object)("removeAllSuckers " + queueName));
        for (ConnectionInfo info : this.connections.values()) {
            MessageSucker sucker = info.removeSucker(queueName);
            if (sucker == null) continue;
            sucker.stop();
        }
    }

    private void createAllSuckers() throws Exception {
        Collection allBindings = this.postOffice.getAllBindings();
        Iterator<Object> iter = allBindings.iterator();
        HashMap<String, ArrayList<Queue>> nameMap = new HashMap<String, ArrayList<Queue>>();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            if (!binding.queue.isClustered()) continue;
            ArrayList<Queue> queues = (ArrayList<Queue>)nameMap.get(binding.queue.getName());
            if (queues == null) {
                queues = new ArrayList<Queue>();
                nameMap.put(binding.queue.getName(), queues);
            }
            queues.add(binding.queue);
        }
        for (Map.Entry entry : nameMap.entrySet()) {
            String queueName = (String)entry.getKey();
            List queues = (List)entry.getValue();
            Iterator iter2 = queues.iterator();
            Queue localQueue = null;
            while (iter2.hasNext()) {
                Queue queue = (Queue)iter2.next();
                if (queue.getNodeID() != this.nodeID) continue;
                localQueue = queue;
                break;
            }
            if (localQueue == null) continue;
            for (Queue queue : queues) {
                if (queue.getNodeID() == this.nodeID || !queue.isClustered()) continue;
                this.createSucker(queueName, queue.getNodeID());
            }
        }
    }

    public static class ConnectionInfo
    implements ExceptionListener {
        protected JBossConnectionFactory connectionFactory;
        protected JBossConnection connection;
        protected Session session;
        protected Map suckers;
        protected boolean started;
        private String suckerUser;
        private String suckerPassword;
        protected boolean isLocal;
        private int maxRetry;
        private int retryInterval;

        public ConnectionInfo(JBossConnectionFactory connectionFactory, String suckerUser, String suckerPassword, boolean isLocal, int maxRetry, int retryInterval) throws Exception {
            this.connectionFactory = connectionFactory;
            this.suckers = new HashMap();
            this.suckerUser = suckerUser;
            this.suckerPassword = suckerPassword;
            this.isLocal = isLocal;
            this.maxRetry = maxRetry;
            this.retryInterval = retryInterval;
        }

        protected synchronized void start() throws Exception {
            if (this.started) {
                return;
            }
            if (this.connection == null) {
                this.connection = (JBossConnection)this.connectionFactory.createConnection(this.suckerUser, this.suckerPassword);
                if (!this.isLocal) {
                    this.connection.setExceptionListener(this);
                }
                this.session = this.connection.createSession(false, 2);
            }
            this.connection.start();
            this.started = true;
        }

        synchronized void stop() throws Exception {
            if (!this.started) {
                return;
            }
            this.connection.stop();
            this.started = false;
        }

        synchronized void resetAllSuckers() {
            for (MessageSucker sucker : this.suckers.values()) {
                sucker.setConsuming(false);
            }
        }

        synchronized void closeAllSuckers() {
            for (MessageSucker sucker : this.suckers.values()) {
                sucker.stop();
            }
            this.suckers.clear();
        }

        protected synchronized void close() {
            this.closeAllSuckers();
            Callable callable = new Callable(){

                public Object call() {
                    try {
                        ConnectionInfo.this.connection.close();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                    return null;
                }
            };
            TimedCallable timedCallable = new TimedCallable(callable, 2000L);
            try {
                timedCallable.call();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection = null;
            this.started = false;
        }

        protected synchronized boolean hasSucker(String queueName) {
            return this.suckers.containsKey(queueName);
        }

        protected synchronized void addSucker(MessageSucker sucker) {
            if (this.suckers.containsKey(sucker.getQueueName())) {
                throw new IllegalStateException("Already has sucker for queue " + sucker.getQueueName());
            }
            this.suckers.put(sucker.getQueueName(), sucker);
        }

        synchronized MessageSucker removeSucker(String queueName) {
            MessageSucker sucker = (MessageSucker)this.suckers.remove(queueName);
            return sucker;
        }

        public void onException(JMSException e) {
            log.warn((Object)("Connection failure detected. Clean up and retry connection. maxRetry: " + this.maxRetry + " retryInterval: " + this.retryInterval));
            this.cleanupConnection();
            this.retryConnection();
        }

        protected synchronized void cleanupConnection() {
            if (!this.started) {
                return;
            }
            for (MessageSucker sucker : this.suckers.values()) {
                sucker.suspend();
            }
            Callable callable = new Callable(){

                public Object call() {
                    try {
                        ConnectionInfo.this.connection.close();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                    return null;
                }
            };
            TimedCallable timedCallable = new TimedCallable(callable, 2000L);
            try {
                timedCallable.call();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.connection = null;
            this.started = false;
        }

        protected synchronized int retryConnection() {
            int retryCount = 0;
            while ((this.maxRetry == -1 || retryCount < this.maxRetry) && this.suckers.size() > 0) {
                try {
                    this.start();
                    break;
                }
                catch (Exception e) {
                    ++retryCount;
                    if (trace) {
                        log.trace((Object)("Retrying ConnectionInfo " + this + " failed, retry count: " + retryCount), (Throwable)e);
                    }
                    try {
                        this.wait(this.retryInterval);
                    }
                    catch (InterruptedException ite) {}
                }
            }
            if (!this.started) {
                log.error((Object)("Retrying ConnectionInfo " + this + " failed after maxmum retry: " + retryCount));
                return retryCount;
            }
            for (MessageSucker sucker : this.suckers.values()) {
                try {
                    sucker.resume(this.session);
                }
                catch (JMSException e) {
                    log.warn((Object)("Error resuming sucker " + sucker), (Throwable)e);
                }
            }
            return retryCount;
        }
    }
}

