/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.common.resolvers.spi;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.common.resolvers.spi.EjbReference;
import org.jboss.ejb3.common.resolvers.spi.NonDeterministicInterfaceException;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.JbossSessionBeanJndiNameResolver;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;

public abstract class EjbReferenceResolverBase {
    private static final Logger log = Logger.getLogger(EjbReferenceResolverBase.class);
    public static final String DU_ATTACHMENT_NAME_METADATA = AttachmentNames.PROCESSED_METADATA;

    protected JBossMetaData getMetaData(DeploymentUnit du) {
        return (JBossMetaData)du.getAttachment(DU_ATTACHMENT_NAME_METADATA, JBossMetaData.class);
    }

    protected String getMatch(EjbReference reference, JBossMetaData metadata, ClassLoader cl) throws NonDeterministicInterfaceException {
        log.debug((Object)("Resolving reference for " + reference + " in " + metadata));
        ArrayList<JBossSessionBeanMetaData> matches = new ArrayList<JBossSessionBeanMetaData>();
        String mappedName = reference.getMappedName();
        if (mappedName != null && mappedName.trim().length() > 0) {
            return mappedName;
        }
        JBossEnterpriseBeansMetaData beans = metadata.getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            JBossSessionBeanMetaData smd;
            if (!bean.isSession() || !this.isMatch(reference, smd = (JBossSessionBeanMetaData)bean, cl)) continue;
            matches.add(smd);
            log.debug((Object)("Found match in EJB " + smd.getEjbName() + " for " + reference));
        }
        if (matches.size() > 1) {
            String beanName = reference.getBeanName();
            assert (beanName == null || beanName.trim().length() == 0) : "Error in resolution logic, more than one eligible EJB was found to satisfy beanInterface " + this.getBeanInterfaceName(reference, cl) + ", but EJB Name was explicitly-specified.";
            throw new NonDeterministicInterfaceException("Specified reference " + reference + " was matched by more than one EJB: " + matches + ".  Specify beanName explciitly or ensure beanInterface is unique.");
        }
        return matches.size() > 0 ? this.getJndiName(reference, (JBossSessionBeanMetaData)matches.iterator().next(), cl) : null;
    }

    protected boolean isMatch(EjbReference reference, JBossSessionBeanMetaData md, ClassLoader cl) {
        ArrayList<String> interfaces = new ArrayList<String>();
        interfaces.addAll(this.getAllParentInterfaces(this.getEligibleBeanInterfaces(md), cl));
        String requestedInterface = reference.getBeanInterface();
        assert (requestedInterface != null && requestedInterface.trim().length() > 0) : "beanInterface must be specified";
        if (interfaces.contains(requestedInterface)) {
            boolean found = false;
            for (String interfaze : interfaces) {
                boolean equal = interfaze.equals(requestedInterface);
                if (equal && !found) {
                    found = true;
                    continue;
                }
                if (!equal || !found) continue;
                throw new NonDeterministicInterfaceException("beanInterface specified, " + interfaze + ", is not unique within EJB " + md.getEjbName());
            }
            String ejbName = reference.getBeanName();
            return ejbName == null || ejbName.trim().length() <= 0 || ejbName.equals(md.getEjbName());
        }
        return false;
    }

    private Collection<String> getAllParentInterfaces(Collection<String> interfaceNames, ClassLoader cl) {
        ArrayList<String> interfaces = new ArrayList<String>();
        for (String interfaceName : interfaceNames) {
            interfaces.addAll(this.getAllParentInterfaces(interfaceName, cl));
        }
        return interfaces;
    }

    private Collection<String> getAllParentInterfaces(String interfaceName, ClassLoader cl) {
        ArrayList<String> interfaces = new ArrayList<String>();
        interfaces.add(interfaceName);
        try {
            Class<?>[] parentInterfaces;
            Class<?> interfaze = Class.forName(interfaceName, false, cl);
            for (Class<?> parentInterface : parentInterfaces = interfaze.getInterfaces()) {
                String parentInterfaceName = parentInterface.getName();
                Collection<String> grandParents = this.getAllParentInterfaces(parentInterfaceName, cl);
                if (grandParents.size() > 0) {
                    interfaces.addAll(grandParents);
                }
                if (interfaces.contains(parentInterfaceName)) continue;
                interfaces.add(parentInterfaceName);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load class from specified ClassLoader " + cl, cnfe);
        }
        return interfaces;
    }

    private Collection<String> getEligibleBeanInterfaces(JBossSessionBeanMetaData smd) {
        ArrayList<String> interfaces = new ArrayList<String>();
        BusinessLocalsMetaData businessLocals = smd.getBusinessLocals();
        BusinessRemotesMetaData businessRemotes = smd.getBusinessRemotes();
        String home = smd.getHome();
        String localHome = smd.getLocalHome();
        if (businessLocals != null) {
            interfaces.addAll((Collection<String>)businessLocals);
        }
        if (businessRemotes != null) {
            interfaces.addAll((Collection<String>)businessRemotes);
        }
        if (home != null && home.trim().length() > 0) {
            interfaces.add(home);
        }
        if (localHome != null && localHome.trim().length() > 0) {
            interfaces.add(localHome);
        }
        return interfaces;
    }

    protected String getJndiName(EjbReference reference, JBossSessionBeanMetaData metadata, ClassLoader cl) {
        String mappedName = reference.getMappedName();
        if (mappedName != null && mappedName.trim().length() > 0) {
            log.debug((Object)("Bypassing resolution, using mappedName of " + reference));
            return mappedName;
        }
        String interfaceName = this.getBeanInterfaceName(reference, cl);
        Collection<String> eligibleInterfaces = this.getEligibleBeanInterfaces(metadata);
        if (!eligibleInterfaces.contains(interfaceName)) {
            log.debug((Object)("Found specified beanInterface that is not a direct beanInterface of EJB " + metadata.getEjbName() + ": " + interfaceName));
            for (String eligibleInterface : eligibleInterfaces) {
                Collection<String> parents = this.getAllParentInterfaces(eligibleInterface, cl);
                if (!parents.contains(interfaceName)) continue;
                log.debug((Object)("Resolved specified beanInterface " + interfaceName + " to " + eligibleInterface + " for EJB " + metadata.getEjbName()));
                interfaceName = eligibleInterface;
                break;
            }
        }
        String resolvedJndiName = JbossSessionBeanJndiNameResolver.resolveJndiName((JBossEnterpriseBeanMetaData)metadata, (String)interfaceName);
        log.debug((Object)("Resolved JNDI Name for " + reference + " of EJB " + metadata.getEjbName() + ": " + resolvedJndiName));
        return resolvedJndiName;
    }

    private String getBeanInterfaceName(EjbReference reference, ClassLoader cl) {
        String interfaceName = reference.getBeanInterface();
        assert (interfaceName != null && interfaceName.trim().length() > 0) : "beanInterface must be specified";
        return interfaceName;
    }
}

