/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Available;
import org.jboss.tools.buildmagic.task.MissingAttributeException;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

public class CallTarget
extends Task {
    protected final TaskLogger log = new TaskLogger(this);
    protected final List params = new LinkedList();
    protected String target;
    protected boolean override = true;
    protected String _if;
    protected String unless;
    protected List availables = new LinkedList();
    public static final Class[] ARGUMENT_TYPES = new Class[]{Boolean.TYPE};
    public static final Object[] ARGUMENT_VALUES = new Object[]{Boolean.TRUE};

    public void setOverride(boolean override) {
        this.override = override;
        this.log.debug("override flag: " + override);
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setIf(String property) {
        this._if = property;
    }

    public void setUnless(String property) {
        this.unless = property;
    }

    public Available createAvailable() {
        Available a = (Available)this.getProject().createTask("available");
        a.setProperty("null");
        this.availables.add(a);
        return a;
    }

    protected void validate() throws BuildException {
        if (this.target == null) {
            throw new MissingAttributeException("target", this);
        }
    }

    public void execute() throws BuildException {
        this.validate();
        Iterator iter = this.availables.iterator();
        while (iter.hasNext()) {
            Available a = (Available)iter.next();
            if (a.eval()) continue;
            return;
        }
        Hashtable map = this.getProject().getProperties();
        if (this._if != null && !map.containsKey(this._if)) {
            return;
        }
        if (this.unless != null && map.containsKey(this.unless)) {
            return;
        }
        iter = this.params.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            if (this.override) {
                try {
                    Class<?> type = task.getClass();
                    Method meth = type.getMethod("setOverride", ARGUMENT_TYPES);
                    meth.invoke((Object)task, ARGUMENT_VALUES);
                    this.log.debug("set override for task: " + task);
                }
                catch (Exception e) {
                    this.log.warning("failed to set override: " + e);
                }
            }
            task.execute();
        }
        this.getProject().executeTarget(this.target);
    }

    public Task createParam() {
        Task task = this.getProject().createTask("property");
        this.params.add(task);
        return task;
    }

    public Task createProperty() {
        Task task = this.getProject().createTask("property");
        this.params.add(task);
        return task;
    }
}

