/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.tools.buildmagic.task.MissingAttributeException;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

public class FindRoot
extends Task {
    protected TaskLogger log;
    protected String basedir = ".";
    protected String suffix;
    protected String property;

    public FindRoot() {
        this.log = new TaskLogger(this);
    }

    public FindRoot(TaskLogger log) {
        this.log = log;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public File getRoot() throws BuildException {
        if (this.suffix == null) {
            throw new MissingAttributeException("suffix", this);
        }
        if (this.property == null) {
            throw new MissingAttributeException("property", this);
        }
        File root = this.findRoot(this.basedir, this.suffix);
        this.log.verbose("using root: " + root);
        return root;
    }

    public void execute() throws BuildException {
        File root = this.getRoot();
        this.getProject().getProperties().put(this.property, root.getAbsolutePath());
    }

    private File getParentFile(File file) {
        String filename = file.getAbsolutePath();
        file = new File(filename);
        return (filename = file.getParent()) == null ? null : new File(filename);
    }

    private File findRoot(String start, String suffix) throws BuildException {
        this.log.verbose("Searching for " + suffix + " ...");
        File parent = new File(new File(start).getAbsolutePath());
        File file = new File(parent, suffix);
        while (!file.exists()) {
            if ((parent = this.getParentFile(parent)) == null) {
                throw new BuildException("Could not locate a " + suffix);
            }
            file = new File(parent, suffix);
        }
        return parent;
    }
}

