/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.access.SoftLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalCache
implements CacheConcurrencyStrategy {
    private static final Logger log = LoggerFactory.getLogger(TransactionalCache.class);
    private Cache cache;

    @Override
    public String getRegionName() {
        return this.cache.getRegionName();
    }

    @Override
    public Object get(Object key, long txTimestamp) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("cache lookup: " + key);
        }
        Object result = this.cache.read(key);
        if (log.isDebugEnabled()) {
            log.debug(result == null ? "cache miss" : "cache hit");
        }
        return result;
    }

    @Override
    public boolean put(Object key, Object value, long txTimestamp, Object version, Comparator versionComparator, boolean minimalPut) throws CacheException {
        if (minimalPut && this.cache.read(key) != null) {
            if (log.isDebugEnabled()) {
                log.debug("item already cached: " + key);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("caching: " + key);
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeLoad(key, value, version);
        } else {
            this.cache.put(key, value);
        }
        return true;
    }

    @Override
    public SoftLock lock(Object key, Object version) throws CacheException {
        return null;
    }

    @Override
    public void release(Object key, SoftLock clientLock) throws CacheException {
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("updating: " + key);
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeUpdate(key, value, currentVersion, previousVersion);
        } else {
            this.cache.update(key, value);
        }
        return true;
    }

    @Override
    public boolean insert(Object key, Object value, Object currentVersion) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("inserting: " + key);
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeInsert(key, value, currentVersion);
        } else {
            this.cache.update(key, value);
        }
        return true;
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.cache.remove(key);
    }

    @Override
    public void remove(Object key) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("removing: " + key);
        }
        this.cache.remove(key);
    }

    @Override
    public void clear() throws CacheException {
        log.debug("clearing");
        this.cache.clear();
    }

    @Override
    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn("could not destroy cache", (Throwable)e);
        }
    }

    @Override
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean afterUpdate(Object key, Object value, Object version, SoftLock clientLock) throws CacheException {
        return false;
    }

    public String toString() {
        return this.cache + "(transactional)";
    }
}

