/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl.bridge;

import java.util.Properties;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.NoCacheProvider;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cache.impl.bridge.CollectionRegionAdapter;
import org.hibernate.cache.impl.bridge.EntityRegionAdapter;
import org.hibernate.cache.impl.bridge.QueryResultsRegionAdapter;
import org.hibernate.cache.impl.bridge.TimestampsRegionAdapter;
import org.hibernate.cfg.Settings;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionFactoryCacheProviderBridge
implements RegionFactory {
    public static final String DEF_PROVIDER = NoCacheProvider.class.getName();
    private static final Logger log = LoggerFactory.getLogger(RegionFactoryCacheProviderBridge.class);
    private CacheProvider cacheProvider;
    private Settings settings;

    public RegionFactoryCacheProviderBridge(Properties properties) {
        String providerClassName = PropertiesHelper.getString("hibernate.cache.provider_class", properties, DEF_PROVIDER);
        log.info("Cache provider: " + providerClassName);
        try {
            this.cacheProvider = (CacheProvider)ReflectHelper.classForName(providerClassName).newInstance();
        }
        catch (Throwable cnfe) {
            String msg = "Could not instantiate cache provider: " + providerClassName + "\nUnsupported cache provider implemention is not included our Product." + "\nThis error may be caused by the configured cache provider was not found in the classpath." + "\nPlease check the cache configuration and make sure the provider is in the classpath.";
            throw new CacheException(msg, cnfe);
        }
    }

    @Override
    public void start(Settings settings, Properties properties) throws CacheException {
        this.settings = settings;
        this.cacheProvider.start(properties);
    }

    @Override
    public void stop() {
        this.cacheProvider.stop();
        this.cacheProvider = null;
    }

    @Override
    public boolean isMinimalPutsEnabledByDefault() {
        return this.cacheProvider.isMinimalPutsEnabledByDefault();
    }

    @Override
    public long nextTimestamp() {
        return this.cacheProvider.nextTimestamp();
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    @Override
    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new EntityRegionAdapter(this.cacheProvider.buildCache(regionName, properties), this.settings, metadata);
    }

    @Override
    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new CollectionRegionAdapter(this.cacheProvider.buildCache(regionName, properties), this.settings, metadata);
    }

    @Override
    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new QueryResultsRegionAdapter(this.cacheProvider.buildCache(regionName, properties), this.settings);
    }

    @Override
    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new TimestampsRegionAdapter(this.cacheProvider.buildCache(regionName, properties), this.settings);
    }
}

