/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.sql.ANSICaseFragment;
import org.hibernate.sql.CaseFragment;

public class Oracle9iDialect
extends Oracle8iDialect {
    @Override
    protected void registerCharacterTypeMappings() {
        this.registerColumnType(1, "char(1 char)");
        this.registerColumnType(12, 4000, "varchar2($l char)");
        this.registerColumnType(12, "long");
    }

    @Override
    protected void registerDateTimeTypeMappings() {
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "timestamp");
    }

    @Override
    public CaseFragment createCaseFragment() {
        return new ANSICaseFragment();
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (sql.toLowerCase().endsWith(" for update")) {
            sql = sql.substring(0, sql.length() - 11);
            isForUpdate = true;
        }
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (hasOffset) {
            pagingSelect.append(" ) row_ where rownum <= ?) where rownum_ > ?");
        } else {
            pagingSelect.append(" ) where rownum <= ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        return pagingSelect.toString();
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        return this.getBasicSelectClauseNullString(sqlType);
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select systimestamp from dual";
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return "current_timestamp";
    }
}

