/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.OracleJoinFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDialect
extends Oracle9Dialect {
    private static final Logger log = LoggerFactory.getLogger(OracleDialect.class);

    public OracleDialect() {
        log.warn("The OracleDialect dialect has been deprecated; use Oracle8iDialect instead");
        this.registerColumnType(93, "date");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, 4000, "varchar2($l)");
    }

    @Override
    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    @Override
    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (sql.toLowerCase().endsWith(" for update")) {
            sql = sql.substring(0, sql.length() - 11);
            isForUpdate = true;
        }
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (hasOffset) {
            pagingSelect.append(" ) row_ ) where rownum_ <= ? and rownum_ > ?");
        } else {
            pagingSelect.append(" ) where rownum <= ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        return pagingSelect.toString();
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        switch (sqlType) {
            case 1: 
            case 12: {
                return "to_char(null)";
            }
            case 91: 
            case 92: 
            case 93: {
                return "to_date(null)";
            }
        }
        return "to_number(null)";
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select sysdate from dual";
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return "sysdate";
    }
}

