/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.SessionFactoryAwareNode;
import org.hibernate.type.LiteralType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class JavaConstantNode
extends Node
implements ExpectedTypeAwareNode,
SessionFactoryAwareNode {
    private SessionFactoryImplementor factory;
    private String constantExpression;
    private Object constantValue;
    private Type heuristicType;
    private Type expectedType;

    public void setText(String s) {
        if (StringHelper.isNotEmpty(s)) {
            this.constantExpression = s;
            this.constantValue = ReflectHelper.getConstantValue(s);
            this.heuristicType = TypeFactory.heuristicType(this.constantValue.getClass().getName());
            super.setText(s);
        }
    }

    @Override
    public void setExpectedType(Type expectedType) {
        this.expectedType = expectedType;
    }

    @Override
    public Type getExpectedType() {
        return this.expectedType;
    }

    @Override
    public void setSessionFactory(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    private String resolveToLiteralString(Type type) {
        try {
            LiteralType literalType = (LiteralType)((Object)type);
            Dialect dialect = this.factory.getDialect();
            return literalType.objectToSQLString(this.constantValue, dialect);
        }
        catch (Throwable t) {
            throw new QueryException("Could not format constant value to SQL literal: " + this.constantExpression, t);
        }
    }

    @Override
    public String getRenderText(SessionFactoryImplementor sessionFactory) {
        Type type = this.expectedType == null ? this.heuristicType : this.expectedType;
        return this.resolveToLiteralString(type);
    }
}

