/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public abstract class ToOne
extends SimpleValue
implements Fetchable {
    private FetchMode fetchMode;
    protected String referencedPropertyName;
    private String referencedEntityName;
    private boolean embedded;
    private boolean lazy = true;
    protected boolean unwrapProxy;

    protected ToOne(Table table) {
        super(table);
    }

    @Override
    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    @Override
    public void setFetchMode(FetchMode fetchMode) {
        this.fetchMode = fetchMode;
    }

    @Override
    public abstract void createForeignKey() throws MappingException;

    @Override
    public abstract Type getType() throws MappingException;

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    public void setReferencedPropertyName(String name) {
        this.referencedPropertyName = name == null ? null : name.intern();
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName == null ? null : referencedEntityName.intern();
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.referencedEntityName == null) {
            this.referencedEntityName = ReflectHelper.reflectedPropertyClass(className, propertyName).getName();
        }
    }

    @Override
    public boolean isTypeSpecified() {
        return this.referencedEntityName != null;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    @Override
    public boolean isValid(Mapping mapping) throws MappingException {
        if (this.referencedEntityName == null) {
            throw new MappingException("association must specify the referenced entity");
        }
        return super.isValid(mapping);
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isUnwrapProxy() {
        return this.unwrapProxy;
    }

    public void setUnwrapProxy(boolean unwrapProxy) {
        this.unwrapProxy = unwrapProxy;
    }
}

