/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.MutableType;
import org.hibernate.type.SerializationException;
import org.hibernate.util.SerializationHelper;

public class SerializableType
extends MutableType {
    private final Class serializableClass;

    public SerializableType(Class serializableClass) {
        this.serializableClass = serializableClass;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        Hibernate.BINARY.set(st, SerializableType.toBytes(value), index);
    }

    @Override
    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        byte[] bytes = (byte[])Hibernate.BINARY.get(rs, name);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return this.fromBytes(bytes);
    }

    @Override
    public Class getReturnedClass() {
        return this.serializableClass;
    }

    @Override
    public boolean isEqual(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y) || Hibernate.BINARY.isEqual(SerializableType.toBytes(x), SerializableType.toBytes(y));
    }

    @Override
    public int getHashCode(Object x, EntityMode entityMode) {
        return Hibernate.BINARY.getHashCode(SerializableType.toBytes(x), entityMode);
    }

    @Override
    public String toString(Object value) throws HibernateException {
        return Hibernate.BINARY.toString(SerializableType.toBytes(value));
    }

    @Override
    public Object fromStringValue(String xml) throws HibernateException {
        return this.fromBytes((byte[])Hibernate.BINARY.fromStringValue(xml));
    }

    @Override
    public String getName() {
        return this.serializableClass == Serializable.class ? "serializable" : this.serializableClass.getName();
    }

    @Override
    public Object deepCopyNotNull(Object value) throws HibernateException {
        return this.fromBytes(SerializableType.toBytes(value));
    }

    private static byte[] toBytes(Object object) throws SerializationException {
        return SerializationHelper.serialize((Serializable)object);
    }

    private Object fromBytes(byte[] bytes) throws SerializationException {
        return SerializationHelper.deserialize(bytes, this.getReturnedClass().getClassLoader());
    }

    @Override
    public int sqlType() {
        return Hibernate.BINARY.sqlType();
    }

    @Override
    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return cached == null ? null : this.fromBytes((byte[])cached);
    }

    @Override
    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return value == null ? null : SerializableType.toBytes(value);
    }
}

