/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import org.hornetq.api.core.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.ServerSessionPacketHandler;
import org.hornetq.core.protocol.core.impl.CoreProtocolManager;
import org.hornetq.core.protocol.core.impl.CoreSessionCallback;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateReplicationSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.NullResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReattachSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReattachSessionResponseMessage;
import org.hornetq.core.replication.ReplicationEndpoint;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.version.Version;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;

public class HornetQPacketHandler
implements ChannelHandler {
    private static final Logger log = Logger.getLogger(HornetQPacketHandler.class);
    private final HornetQServer server;
    private final Channel channel1;
    private final CoreRemotingConnection connection;
    private final CoreProtocolManager protocolManager;

    public HornetQPacketHandler(CoreProtocolManager protocolManager, HornetQServer server, Channel channel1, CoreRemotingConnection connection) {
        this.protocolManager = protocolManager;
        this.server = server;
        this.channel1 = channel1;
        this.connection = connection;
    }

    public void handlePacket(Packet packet) {
        byte type = packet.getType();
        switch (type) {
            case 30: {
                CreateSessionMessage request = (CreateSessionMessage)packet;
                this.handleCreateSession(request);
                break;
            }
            case 32: {
                ReattachSessionMessage request = (ReattachSessionMessage)packet;
                this.handleReattachSession(request);
                break;
            }
            case 34: {
                CreateQueueMessage request = (CreateQueueMessage)packet;
                this.handleCreateQueue(request);
                break;
            }
            case 36: {
                CreateReplicationSessionMessage request = (CreateReplicationSessionMessage)packet;
                this.handleCreateReplication(request);
                break;
            }
            default: {
                log.error("Invalid packet " + packet);
            }
        }
    }

    private void handleCreateSession(CreateSessionMessage request) {
        PacketImpl response;
        boolean incompatibleVersion = false;
        try {
            Version version = this.server.getVersion();
            int[] compatibleList = version.getCompatibleVersionList();
            boolean isCompatibleClient = false;
            for (int i = 0; i < compatibleList.length; ++i) {
                if (compatibleList[i] != request.getVersion()) continue;
                isCompatibleClient = true;
                break;
            }
            if (!isCompatibleClient) {
                log.warn("Client with version " + request.getVersion() + " and address " + this.connection.getRemoteAddress() + " is not compatible with server version " + version.getFullVersion() + ". " + "Please ensure all clients and servers are upgraded to the same version for them to " + "interoperate properly");
                throw new HornetQException(108, "Server and client versions incompatible");
            }
            if (!this.server.isStarted()) {
                throw new HornetQException(112, "Server not started");
            }
            if (!this.server.checkActivate()) {
                throw new HornetQException(112, "Server will not accept create session requests");
            }
            Channel channel = this.connection.getChannel(request.getSessionChannelID(), request.getWindowSize());
            ServerSession session = this.server.createSession(request.getName(), request.getUsername(), request.getPassword(), request.getMinLargeMessageSize(), (RemotingConnection)this.connection, request.isAutoCommitSends(), request.isAutoCommitAcks(), request.isPreAcknowledge(), request.isXA(), request.getDefaultAddress(), (SessionCallback)new CoreSessionCallback(request.getName(), this.protocolManager, channel));
            session.setSessionContext(this.server.getStorageManager().newContext(this.server.getExecutorFactory().getExecutor()));
            ServerSessionPacketHandler handler = new ServerSessionPacketHandler(session, this.server.getStorageManager(), channel);
            channel.setHandler(handler);
            this.protocolManager.addSessionHandler(request.getName(), handler);
            response = new CreateSessionResponseMessage(this.server.getVersion().getIncrementingVersion());
        }
        catch (HornetQException e) {
            log.error("Failed to create session ", e);
            response = new HornetQExceptionMessage(e);
            if (e.getCode() == 108) {
                incompatibleVersion = true;
            }
        }
        catch (Exception e) {
            log.error("Failed to create session ", e);
            log.error("Failed to create session", e);
            response = new HornetQExceptionMessage(new HornetQException(0));
        }
        if (incompatibleVersion) {
            this.channel1.sendAndFlush(response);
        } else {
            this.channel1.send(response);
        }
    }

    private void handleReattachSession(ReattachSessionMessage request) {
        PacketImpl response = null;
        try {
            if (!this.server.isStarted()) {
                response = new ReattachSessionResponseMessage(-1, false);
            }
            log.debug("Reattaching request from " + this.connection.getRemoteAddress());
            ServerSessionPacketHandler sessionHandler = this.protocolManager.getSessionHandler(request.getName());
            if (!this.server.checkActivate() || sessionHandler == null) {
                response = new ReattachSessionResponseMessage(-1, false);
            } else if (sessionHandler.getChannel().getConfirmationWindowSize() == -1) {
                log.warn("Reattach request from " + this.connection.getRemoteAddress() + " failed as there is no confirmationWindowSize configured, which may be ok for your system");
                sessionHandler.closeListeners();
                sessionHandler.close();
                response = new ReattachSessionResponseMessage(-1, false);
            } else {
                int serverLastConfirmedCommandID = sessionHandler.transferConnection(this.connection, request.getLastConfirmedCommandID());
                response = new ReattachSessionResponseMessage(serverLastConfirmedCommandID, true);
            }
        }
        catch (Exception e) {
            log.error("Failed to reattach session", e);
            response = new HornetQExceptionMessage(new HornetQException(0));
        }
        this.channel1.send(response);
    }

    private void handleCreateQueue(CreateQueueMessage request) {
        try {
            this.server.createQueue(request.getAddress(), request.getQueueName(), request.getFilterString(), request.isDurable(), request.isTemporary());
        }
        catch (Exception e) {
            log.error("Failed to handle create queue", e);
        }
    }

    private void handleCreateReplication(CreateReplicationSessionMessage request) {
        PacketImpl response;
        try {
            Channel channel = this.connection.getChannel(request.getSessionChannelID(), -1);
            ReplicationEndpoint endpoint = this.server.connectToReplicationEndpoint(channel);
            channel.setHandler((ChannelHandler)endpoint);
            response = new NullResponseMessage();
        }
        catch (Exception e) {
            if (e instanceof HornetQException) {
                response = new HornetQExceptionMessage((HornetQException)e);
            }
            log.warn(e.getMessage(), e);
            response = new HornetQExceptionMessage(new HornetQException(0));
        }
        this.channel1.send(response);
    }
}

