/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.URL;

class DefaultWebResponse
extends WebResponse {
    DefaultWebResponse(String text) {
        this(null, null, text);
    }

    DefaultWebResponse(WebClient client, URL url, String text) {
        this(client, FrameSelector.TOP_FRAME, url, text);
    }

    DefaultWebResponse(WebClient client, FrameSelector frame, URL url, String text) {
        super(client, frame, url, text);
    }

    @Override
    public int getResponseCode() {
        return 200;
    }

    @Override
    public String getResponseMessage() {
        return "OK";
    }

    @Override
    public String[] getHeaderFieldNames() {
        return new String[]{"Content-type"};
    }

    @Override
    public String getHeaderField(String fieldName) {
        if (fieldName.equalsIgnoreCase("Content-type")) {
            return "text/html; charset=us-ascii";
        }
        return null;
    }

    @Override
    public String[] getHeaderFields(String fieldName) {
        String[] stringArray;
        String value = this.getHeaderField(fieldName);
        if (value == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        return stringArray;
    }

    @Override
    public String toString() {
        try {
            return "DefaultWebResponse [" + this.getText() + "]";
        }
        catch (IOException e) {
            return "DefaultWebResponse [???]";
        }
    }
}

