/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.parsing.HTMLParserFactory;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Stack;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeUtils {
    NodeUtils() {
    }

    public static int getAttributeValue(Node node, String attributeName, int defaultValue) {
        NamedNodeMap nnm = node.getAttributes();
        Node attribute = nnm.getNamedItem(attributeName);
        if (attribute == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attribute.getNodeValue());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String getNodeAttribute(Node node, String attributeName) {
        return NodeUtils.getNodeAttribute(node, attributeName, "");
    }

    public static String getNodeAttribute(Node node, String attributeName, String defaultValue) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return defaultValue;
        }
        Node attribute = attributes.getNamedItem(attributeName);
        return attribute == null ? defaultValue : attribute.getNodeValue();
    }

    static boolean isNodeAttributePresent(Node node, String attributeName) {
        return node.getAttributes().getNamedItem(attributeName) != null;
    }

    public static String asText(NodeList rootNodes) {
        final StringBuffer sb = new StringBuffer(2048);
        NodeAction action = new NodeAction(){

            @Override
            public boolean processElement(PreOrderTraversal traversal, Element node) {
                String nodeName = node.getNodeName().toLowerCase();
                if (nodeName.equals("p") || nodeName.equals("br") || nodeName.equalsIgnoreCase("tr")) {
                    sb.append("\n");
                } else if (nodeName.equals("td") || nodeName.equalsIgnoreCase("th")) {
                    sb.append(" | ");
                } else if (nodeName.equals("img") && HttpUnitOptions.getImagesTreatedAsAltText()) {
                    sb.append(NodeUtils.getNodeAttribute(node, "alt"));
                }
                return true;
            }

            @Override
            public void processTextNode(PreOrderTraversal traversal, Node textNode) {
                sb.append(HTMLParserFactory.getHTMLParser().getCleanedText(textNode.getNodeValue()));
            }
        };
        new PreOrderTraversal(rootNodes).perform(action);
        return sb.toString();
    }

    static class PreOrderTraversal {
        private Stack _pendingNodes = new Stack();
        private Stack _traversalContext = new Stack();
        private static final Object POP_CONTEXT = new Object();

        public PreOrderTraversal(NodeList rootNodes) {
            this.pushNodeList(rootNodes);
        }

        public PreOrderTraversal(Node rootNode) {
            this.pushNodeList(rootNode.getLastChild());
        }

        public void pushBaseContext(Object context) {
            this._traversalContext.push(context);
        }

        public void pushContext(Object context) {
            this._traversalContext.push(context);
            this._pendingNodes.push(POP_CONTEXT);
        }

        public Iterator getContexts() {
            Stack stack = this._traversalContext;
            return this.getTopDownIterator(stack);
        }

        public Object getRootContext() {
            return this._traversalContext.firstElement();
        }

        private Iterator getTopDownIterator(final Stack stack) {
            return new Iterator(){
                private ListIterator _forwardIterator;
                {
                    this._forwardIterator = stack.listIterator(stack.size());
                }

                @Override
                public boolean hasNext() {
                    return this._forwardIterator.hasPrevious();
                }

                public Object next() {
                    return this._forwardIterator.previous();
                }

                @Override
                public void remove() {
                    this._forwardIterator.remove();
                }
            };
        }

        public Object getClosestContext(Class matchingClass) {
            for (int i = this._traversalContext.size() - 1; i >= 0; --i) {
                Object o = this._traversalContext.elementAt(i);
                if (!matchingClass.isInstance(o)) continue;
                return o;
            }
            return null;
        }

        public void perform(NodeAction action) {
            while (!this._pendingNodes.empty()) {
                Object object = this._pendingNodes.pop();
                if (object == POP_CONTEXT) {
                    this._traversalContext.pop();
                    continue;
                }
                Node node = (Node)object;
                if (node.getNodeType() == 3) {
                    action.processTextNode(this, node);
                } else {
                    if (node.getNodeType() != 1) continue;
                    action.processElement(this, (Element)node);
                }
                this.pushNodeList(node.getLastChild());
            }
        }

        private void pushNodeList(NodeList nl) {
            if (nl != null) {
                for (int i = nl.getLength() - 1; i >= 0; --i) {
                    this._pendingNodes.push(nl.item(i));
                }
            }
        }

        private void pushNodeList(Node lastChild) {
            for (Node node = lastChild; node != null; node = node.getPreviousSibling()) {
                this._pendingNodes.push(node);
            }
        }
    }

    static interface NodeAction {
        public boolean processElement(PreOrderTraversal var1, Element var2);

        public void processTextNode(PreOrderTraversal var1, Node var2);
    }
}

