/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.file;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.DelegatingHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.file.FileSystemContext;
import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;
import org.jboss.virtual.spi.LinkInfo;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VFSContextFactory;
import org.jboss.virtual.spi.VFSContextFactoryLocator;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkHandler
extends AbstractURLHandler
implements StructuredVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private List<LinkInfo> links;
    private HashMap<String, VirtualFileHandler> linkTargets = new HashMap(3);

    public LinkHandler(FileSystemContext context, VirtualFileHandler parent, URI uri, String name, List<LinkInfo> links) throws IOException, URISyntaxException {
        super(context, parent, uri.toURL(), name);
        this.links = links;
        this.setVfsUrl(new URL("vfs" + uri.toURL().toString()));
        for (LinkInfo link : links) {
            String atom;
            int n;
            String linkName = link.getName();
            if (linkName == null) {
                linkName = VFSUtils.getName(link.getLinkTarget());
            }
            if (linkName == null) continue;
            List<String> paths = PathTokenizer.getTokens(linkName);
            VirtualFileHandler linkParent = this;
            for (n = 0; n < paths.size() - 1; ++n) {
                VirtualFileHandler previous = linkParent;
                atom = paths.get(n);
                if ((linkParent = this.getChildPrivate(previous, atom)) != null) continue;
                linkParent = previous;
                break;
            }
            while (n < paths.size() - 1) {
                atom = paths.get(n);
                URL polURL = new URL(linkParent.toURI().toURL(), atom);
                ParentOfLink pol = new ParentOfLink(this.getVFSContext(), linkParent, polURL, atom);
                if (linkParent == this) {
                    this.linkTargets.put(atom, pol);
                } else if (linkParent instanceof ParentOfLink) {
                    ParentOfLink prevPOL = (ParentOfLink)linkParent;
                    prevPOL.addChild(pol, atom);
                } else {
                    throw new IOException("Link parent not ParentOfLink.");
                }
                linkParent = pol;
                ++n;
            }
            atom = paths.get(n);
            VirtualFileHandler linkHandler = this.createLinkHandler(linkParent, atom, link.getLinkTarget());
            if (linkParent == this) {
                this.linkTargets.put(atom, linkHandler);
                continue;
            }
            if (!(linkParent instanceof ParentOfLink)) continue;
            ParentOfLink prevPOL = (ParentOfLink)linkParent;
            prevPOL.addChild(linkHandler, atom);
        }
    }

    private VirtualFileHandler getChildPrivate(VirtualFileHandler parent, String name) throws IOException {
        if (parent instanceof LinkHandler) {
            return ((LinkHandler)parent).structuredFindChild(name);
        }
        return parent.getChild(name);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isNested() throws IOException {
        return false;
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        VirtualFileHandler upToDateHandler = this.getParent().getChild(this.getName());
        if (upToDateHandler != this) {
            return upToDateHandler.getChildren(ignoreErrors);
        }
        return new ArrayList<VirtualFileHandler>(this.linkTargets.values());
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        return this.linkTargets.get(name);
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        VirtualFileHandler upToDateHandler = this.getParent().getChild(this.getName());
        if (upToDateHandler != this) {
            return upToDateHandler.getChild(path);
        }
        return this.structuredFindChild(path);
    }

    @Override
    public boolean removeChild(String name) throws IOException {
        VirtualFileHandler upToDateHandler = this.getParent().getChild(this.getName());
        if (upToDateHandler != this) {
            return upToDateHandler.removeChild(name);
        }
        return this.linkTargets.remove(name) != null;
    }

    @Override
    protected void doClose() {
        super.doClose();
        this.links.clear();
    }

    protected VirtualFileHandler createLinkHandler(VirtualFileHandler parent, String name, URI linkURI) throws IOException {
        VFSContextFactory factory = VFSContextFactoryLocator.getFactory(linkURI);
        VFSContext context = factory.getVFS(linkURI);
        VirtualFileHandler rootHandler = context.getRoot();
        return new DelegatingHandler(this.getVFSContext(), parent, name, rootHandler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParentOfLink
    extends AbstractURLHandler
    implements StructuredVirtualFileHandler {
        private static final long serialVersionUID = 1L;
        private HashMap<String, VirtualFileHandler> children = new HashMap(1);

        public ParentOfLink(VFSContext context, VirtualFileHandler parent, URL url, String name) {
            super(context, parent, url, name);
            try {
                this.setVfsUrl(new URL("vfs" + url.toString()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        void addChild(VirtualFileHandler child, String name) {
            this.children.put(name, child);
        }

        @Override
        public VirtualFileHandler createChildHandler(String name) throws IOException {
            return this.children.get(name);
        }

        @Override
        public VirtualFileHandler getChild(String path) throws IOException {
            return this.structuredFindChild(path);
        }

        @Override
        public boolean removeChild(String name) throws IOException {
            return this.children.remove(name) != null;
        }

        @Override
        public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
            return Collections.unmodifiableList(new ArrayList<VirtualFileHandler>(this.children.values()));
        }

        @Override
        public boolean isLeaf() throws IOException {
            return false;
        }

        @Override
        public boolean isNested() throws IOException {
            return false;
        }
    }
}

