/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import org.apache.ws.jaxme.xs.XSEnumeration;
import org.apache.ws.jaxme.xs.XSListType;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.impl.XSSimpleTypeImpl;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsEList;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.XsTLocalSimpleType;
import org.xml.sax.SAXException;

public class XSListTypeImpl
extends XSSimpleTypeImpl
implements XSListType {
    private static final String[][] ZERO_PATTERNS = new String[0][];
    private static final XSEnumeration[] ZERO_ENUMERATIONS = new XSEnumeration[0];
    private final XSType itemType;

    @Override
    public boolean isRestriction() {
        return false;
    }

    @Override
    public XSType getRestrictedType() {
        throw new IllegalStateException("This is a basic list type and not a restriction of another simple type.");
    }

    public XSListTypeImpl(XSType pOwner, XsEList pBaseList) throws SAXException {
        XsQName itemTypeName = pBaseList.getItemType();
        if (itemTypeName == null) {
            XsTLocalSimpleType simpleType = pBaseList.getSimpleType();
            if (simpleType == null) {
                throw new LocSAXException("You must either set the 'itemType' attribute or add a 'simpleType' element.", pBaseList.getLocator());
            }
            XSType type = pOwner.getXSSchema().getXSObjectFactory().newXSType((XSObject)pOwner, simpleType);
            type.validate();
            this.itemType = type;
        } else {
            XSType type = pOwner.getXSSchema().getType(itemTypeName);
            if (type == null) {
                throw new LocSAXException("Unknown item type: " + itemTypeName, pBaseList.getLocator());
            }
            type.validate();
            if (!type.isSimple()) {
                throw new LocSAXException("The item type " + itemTypeName + " is complex.", pBaseList.getLocator());
            }
            this.itemType = type;
        }
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public XSListType getListType() {
        return this;
    }

    @Override
    public String[][] getPattern() {
        return ZERO_PATTERNS;
    }

    @Override
    public XSEnumeration[] getEnumerations() {
        return ZERO_ENUMERATIONS;
    }

    @Override
    public Long getLength() {
        return null;
    }

    @Override
    public Long getMinLength() {
        return null;
    }

    @Override
    public Long getMaxLength() {
        return null;
    }

    @Override
    public XSType getItemType() {
        return this.itemType;
    }
}

