/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.xml.XsObject;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class XSObjectImpl
implements XSObject {
    private final XSObject parent;
    private final XsObject baseObject;

    protected XSObjectImpl(XSObject pParent, XsObject pBaseObject) {
        if (pParent == null) {
            if (!(this instanceof XSSchema)) {
                throw new IllegalStateException("Null parents are allowed for XSSchema objects only.");
            }
        } else if (this instanceof XSSchema) {
            throw new IllegalStateException("An XSSchema object must have a null parent.");
        }
        this.parent = pParent;
        this.baseObject = pBaseObject;
    }

    @Override
    public XSObject getParentObject() {
        return this.parent;
    }

    @Override
    public XSSchema getXSSchema() {
        if (this.parent == null) {
            return (XSSchema)((Object)this);
        }
        return this.parent.getXSSchema();
    }

    @Override
    public boolean isTopLevelObject() {
        return this.parent == null || this.parent instanceof XSSchema;
    }

    @Override
    public Locator getLocator() {
        return this.baseObject.getLocator();
    }

    protected XsObject getXsObject() {
        return this.baseObject;
    }

    @Override
    public void validate() throws SAXException {
    }
}

