/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.parser.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.ws.jaxme.xs.parser.AttributeSetter;
import org.apache.ws.jaxme.xs.parser.ChildSetter;
import org.apache.ws.jaxme.xs.parser.XSContext;
import org.apache.ws.jaxme.xs.parser.XsSAXParser;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractXsSAXParser
implements ContentHandler,
XsSAXParser {
    private static final Class[] ZERO_CLASSES = new Class[0];
    private static final Object[] ZERO_OBJECTS = new Object[0];
    private Object bean;
    private int level;
    private String qName;
    private String namespaceURI;
    private String localName;
    private ContentHandler childHandler;

    protected abstract XSContext getData();

    public AbstractXsSAXParser(Object pBean) {
        this.bean = pBean;
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    public void setQName(String pQName) {
        this.qName = pQName;
    }

    public void setNamespaceURI(String pNamespaceURI) {
        this.namespaceURI = pNamespaceURI;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setLocalName(String pLocalName) {
        this.localName = pLocalName;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getQName() {
        return this.qName;
    }

    public ContentHandler getChildHandler() {
        return this.childHandler;
    }

    @Override
    public void startPrefixMapping(String pPrefix, String pURI) throws SAXException {
        if (this.childHandler == null) {
            this.getData().getNamespaceSupport().declarePrefix(pPrefix, pURI);
        } else {
            this.childHandler.startPrefixMapping(pPrefix, pURI);
        }
    }

    @Override
    public void endPrefixMapping(String pPrefix) throws SAXException {
        if (this.childHandler != null) {
            this.childHandler.endPrefixMapping(pPrefix);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.getData().getNamespaceSupport().pushContext();
    }

    @Override
    public void endDocument() throws SAXException {
        this.getData().getNamespaceSupport().popContext();
    }

    @Override
    public void characters(char[] pBuffer, int pOffset, int pLen) throws SAXException {
        if (this.childHandler == null) {
            try {
                this.getData().getTextSetter().addText(new String(pBuffer, pOffset, pLen));
            }
            catch (SAXException e) {
                throw e;
            }
            catch (RuntimeException e) {
                Exception ex;
                block8: {
                    Throwable t;
                    UndeclaredThrowableException te;
                    ex = e;
                    while (true) {
                        te = null;
                        if (ex instanceof UndeclaredThrowableException) {
                            te = (UndeclaredThrowableException)ex;
                            t = te.getUndeclaredThrowable();
                        } else {
                            if (!(ex instanceof InvocationTargetException)) break block8;
                            t = ((InvocationTargetException)ex).getTargetException();
                        }
                        if (!(t instanceof Exception)) break;
                        ex = (Exception)t;
                    }
                    if (te == null) {
                        te = new UndeclaredThrowableException(t);
                    }
                    t.printStackTrace();
                    throw te;
                }
                throw new LocSAXException(ex.getClass().getName() + ": " + ex.getMessage(), this.getData().getLocator(), ex);
            }
        }
        this.childHandler.characters(pBuffer, pOffset, pLen);
    }

    @Override
    public void ignorableWhitespace(char[] pBuffer, int pOffset, int pLen) throws SAXException {
        if (this.childHandler == null) {
            this.characters(pBuffer, pOffset, pLen);
        } else {
            this.childHandler.ignorableWhitespace(pBuffer, pOffset, pLen);
        }
    }

    @Override
    public void skippedEntity(String pEntity) throws SAXException {
        if (this.childHandler == null) {
            throw new LocSAXException("Unable to skip entities: " + pEntity, this.getData().getLocator());
        }
        this.skippedEntity(pEntity);
    }

    @Override
    public void processingInstruction(String pTarget, String pData) throws SAXException {
        if (this.childHandler != null) {
            this.childHandler.processingInstruction(pTarget, pData);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAttr) throws SAXException {
        switch (++this.level) {
            case 1: {
                this.setQName(pQName);
                this.setNamespaceURI(pNamespaceURI);
                this.setLocalName(pLocalName);
                if (pAttr == null) return;
                for (int i = 0; i < pAttr.getLength(); ++i) {
                    try {
                        AttributeSetter attrSetter = this.getData().getAttributeSetter();
                        attrSetter.setAttribute(pAttr.getQName(i), pAttr.getURI(i), pAttr.getLocalName(i), pAttr.getValue(i));
                        continue;
                    }
                    catch (SAXException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        Throwable t;
                        UndeclaredThrowableException te;
                        Exception ex = e;
                        while (true) {
                            te = null;
                            if (ex instanceof UndeclaredThrowableException) {
                                te = (UndeclaredThrowableException)ex;
                                t = te.getUndeclaredThrowable();
                            } else {
                                if (!(ex instanceof InvocationTargetException)) throw new LocSAXException(ex.getClass().getName() + ": " + ex.getMessage(), this.getData().getLocator(), ex);
                                t = ((InvocationTargetException)ex).getTargetException();
                            }
                            if (!(t instanceof Exception)) break;
                            ex = (Exception)t;
                        }
                        if (te == null) {
                            te = new UndeclaredThrowableException(t);
                        }
                        t.printStackTrace();
                        throw te;
                    }
                }
                return;
            }
            case 2: {
                try {
                    ChildSetter childSetter = this.getData().getChildSetter();
                    this.childHandler = childSetter.getChildHandler(pQName, pNamespaceURI, pLocalName);
                }
                catch (SAXException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    Throwable t;
                    UndeclaredThrowableException te;
                    Exception ex = e;
                    while (true) {
                        te = null;
                        if (ex instanceof UndeclaredThrowableException) {
                            te = (UndeclaredThrowableException)ex;
                            t = te.getUndeclaredThrowable();
                        } else {
                            if (!(ex instanceof InvocationTargetException)) throw new LocSAXException(ex.getClass().getName() + ": " + ex.getMessage(), this.getData().getLocator(), ex);
                            t = ((InvocationTargetException)ex).getTargetException();
                        }
                        if (!(t instanceof Exception)) break;
                        ex = (Exception)t;
                    }
                    if (te == null) {
                        te = new UndeclaredThrowableException(t);
                    }
                    t.printStackTrace();
                    throw te;
                }
                this.getData().setCurrentContentHandler(this.childHandler);
                this.childHandler.startDocument();
                this.childHandler.startElement(pNamespaceURI, pLocalName, pQName, pAttr);
                return;
            }
            default: {
                this.childHandler.startElement(pNamespaceURI, pLocalName, pQName, pAttr);
            }
        }
    }

    @Override
    public void endElement(String pNamespaceURI, String pLocalName, String pQName) throws SAXException {
        switch (this.level--) {
            case 1: {
                Object o = this.getBean();
                if (o == null) break;
                Method m = null;
                try {
                    m = o.getClass().getMethod("validate", ZERO_CLASSES);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (m == null) break;
                try {
                    m.invoke(o, ZERO_OBJECTS);
                    break;
                }
                catch (RuntimeException e) {
                    throw new LocSAXException(e.getClass().getName() + ": " + e.getMessage(), this.getData().getLocator(), e);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof SAXException) {
                        throw (SAXException)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw new LocSAXException(t.getClass().getName() + ": " + t.getMessage(), this.getData().getLocator(), (RuntimeException)t);
                    }
                    if (t instanceof Exception) {
                        throw new LocSAXException("Failed to invoke method validate()  of class " + m.getDeclaringClass() + " with argument " + o.getClass().getName() + ": " + t.getClass().getName() + ", " + t.getMessage(), this.getData().getLocator(), (Exception)t);
                    }
                    throw new LocSAXException("Failed to invoke method validate()  of class " + m.getDeclaringClass() + " with argument " + o.getClass().getName() + ": " + t.getClass().getName() + ", " + t.getMessage(), this.getData().getLocator(), e);
                }
                catch (IllegalAccessException e) {
                    throw new LocSAXException("Failed to invoke method validate()  of class " + m.getDeclaringClass() + " with argument " + o.getClass().getName() + ": IllegalAccessException, " + e.getMessage(), this.getData().getLocator(), e);
                }
            }
            case 2: {
                this.childHandler.endElement(pNamespaceURI, pLocalName, pQName);
                this.childHandler.endDocument();
                this.getData().setCurrentContentHandler(this);
                this.childHandler = null;
                break;
            }
            default: {
                this.childHandler.endElement(pNamespaceURI, pLocalName, pQName);
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator pLocator) {
        this.getData().setLocator(pLocator);
        if (this.childHandler != null) {
            this.childHandler.setDocumentLocator(pLocator);
        }
    }
}

