/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.channels.ClosedChannelException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.deployers.Deployer;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.AddressSettingsDeployer;
import org.hornetq.core.deployers.impl.BasicUserCredentialsDeployer;
import org.hornetq.core.deployers.impl.FileDeploymentManager;
import org.hornetq.core.deployers.impl.QueueDeployer;
import org.hornetq.core.deployers.impl.SecurityDeployer;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.impl.SyncSpeedTest;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.impl.PagingManagerImpl;
import org.hornetq.core.paging.impl.PagingStoreFactoryNIO;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.QueueBindingInfo;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.config.PersistedAddressSetting;
import org.hornetq.core.persistence.config.PersistedRoles;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.persistence.impl.nullpm.NullStorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.impl.DivertBinding;
import org.hornetq.core.postoffice.impl.LocalQueueBinding;
import org.hornetq.core.postoffice.impl.PostOfficeImpl;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.remoting.server.impl.RemotingServiceImpl;
import org.hornetq.core.replication.ReplicationEndpoint;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.core.security.SecurityStore;
import org.hornetq.core.security.impl.SecurityStoreImpl;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.Bindable;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.MemoryManager;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.cluster.impl.ClusterManagerImpl;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.hornetq.core.server.group.impl.LocalGroupingHandler;
import org.hornetq.core.server.group.impl.RemoteGroupingHandler;
import org.hornetq.core.server.impl.AIOFileLockNodeManager;
import org.hornetq.core.server.impl.ConnectorsService;
import org.hornetq.core.server.impl.DivertImpl;
import org.hornetq.core.server.impl.FileLockNodeManager;
import org.hornetq.core.server.impl.MemoryManagerImpl;
import org.hornetq.core.server.impl.QueueFactoryImpl;
import org.hornetq.core.server.impl.ServerInfo;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.impl.ManagementServiceImpl;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.HierarchicalObjectRepository;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.impl.ResourceManagerImpl;
import org.hornetq.core.version.Version;
import org.hornetq.spi.core.logging.LogDelegateFactory;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.OrderedExecutorFactory;
import org.hornetq.utils.SecurityFormatter;
import org.hornetq.utils.VersionLoader;

public class HornetQServerImpl
implements HornetQServer {
    private static final Logger log = Logger.getLogger(HornetQServerImpl.class);
    public static final String GENERIC_IGNORED_FILTER = "__HQX=-1";
    private final Version version;
    private final HornetQSecurityManager securityManager;
    private final Configuration configuration;
    private final MBeanServer mbeanServer;
    private volatile boolean started;
    private volatile SecurityStore securityStore;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private volatile QueueFactory queueFactory;
    private volatile PagingManager pagingManager;
    private volatile PostOffice postOffice;
    private volatile ExecutorService threadPool;
    private volatile ScheduledExecutorService scheduledPool;
    private volatile ExecutorFactory executorFactory;
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private volatile ResourceManager resourceManager;
    private volatile HornetQServerControlImpl messagingServerControl;
    private volatile ClusterManager clusterManager;
    private volatile StorageManager storageManager;
    private volatile RemotingService remotingService;
    private volatile ManagementService managementService;
    private volatile ConnectorsService connectorsService;
    private MemoryManager memoryManager;
    private volatile DeploymentManager deploymentManager;
    private Deployer basicUserCredentialsDeployer;
    private Deployer addressSettingsDeployer;
    private Deployer queueDeployer;
    private Deployer securityDeployer;
    private final Map<String, ServerSession> sessions = new ConcurrentHashMap<String, ServerSession>();
    private final Object initialiseLock = new Object();
    private boolean initialised;
    private ReplicationManager replicationManager;
    private ReplicationEndpoint replicationEndpoint;
    private final Set<ActivateCallback> activateCallbacks = new HashSet<ActivateCallback>();
    private volatile GroupingHandler groupingHandler;
    private NodeManager nodeManager;
    private String identity;
    private Thread backupActivationThread;
    private Activation activation;

    public HornetQServerImpl() {
        this(null, null, null);
    }

    public HornetQServerImpl(Configuration configuration) {
        this(configuration, null, null);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer) {
        this(configuration, mbeanServer, null);
    }

    public HornetQServerImpl(Configuration configuration, HornetQSecurityManager securityManager) {
        this(configuration, null, securityManager);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer, HornetQSecurityManager securityManager) {
        if (configuration == null) {
            configuration = new ConfigurationImpl();
        }
        if (mbeanServer == null) {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.version = VersionLoader.getVersion();
        this.configuration = configuration;
        this.mbeanServer = mbeanServer;
        this.securityManager = securityManager;
        this.addressSettingsRepository = new HierarchicalObjectRepository<AddressSettings>();
        this.addressSettingsRepository.setDefault(new AddressSettings());
        this.securityRepository = new HierarchicalObjectRepository<Set<Role>>();
        this.securityRepository.setDefault(new HashSet());
    }

    protected NodeManager createNodeManager(String directory) {
        if (this.configuration.getJournalType() == JournalType.ASYNCIO && AsynchronousFileImpl.isLoaded()) {
            return new AIOFileLockNodeManager(directory);
        }
        return new FileLockNodeManager(directory);
    }

    @Override
    public synchronized void start() throws Exception {
        this.initialiseLogging();
        this.checkJournalDirectory();
        this.nodeManager = this.createNodeManager(this.configuration.getJournalDirectory());
        this.nodeManager.start();
        if (this.started) {
            log.info((this.configuration.isBackup() ? "backup" : "live") + " is already started, ignoring the call to start..");
            return;
        }
        log.info((this.configuration.isBackup() ? "backup" : "live") + " server is starting with configuration " + this.configuration);
        if (this.configuration.isRunSyncSpeedTest()) {
            SyncSpeedTest test = new SyncSpeedTest();
            test.run();
        }
        if (!this.configuration.isBackup()) {
            if (this.configuration.isSharedStore() && this.configuration.isPersistenceEnabled()) {
                this.activation = new SharedStoreLiveActivation();
                this.activation.run();
            } else {
                this.activation = new NoSharedStoreLiveActivation();
                this.activation.run();
            }
            this.started = true;
            log.info("HornetQ Server version " + this.getVersion().getFullVersion() + " [" + this.nodeManager.getNodeId() + "] started");
        }
        if (this.configuration.isBackup()) {
            this.activation = this.configuration.isSharedStore() ? new SharedStoreBackupActivation() : new SharedNothingBackupActivation();
            this.backupActivationThread = new Thread(this.activation);
            this.backupActivationThread.start();
        }
        this.connectorsService = new ConnectorsService(this.configuration, this.storageManager, this.scheduledPool, this.postOffice);
        this.connectorsService.start();
    }

    protected void finalize() throws Throwable {
        if (this.started) {
            log.warn("HornetQServer is being finalized and has not been stopped. Please remember to stop the server before letting it go out of scope");
            this.stop();
        }
        super.finalize();
    }

    @Override
    public void stop() throws Exception {
        this.stop(this.configuration.isFailoverOnServerShutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean failoverOnServerShutdown) throws Exception {
        HornetQServerImpl hornetQServerImpl = this;
        synchronized (hornetQServerImpl) {
            if (!this.started) {
                return;
            }
            this.connectorsService.stop();
            if (this.groupingHandler != null) {
                this.managementService.removeNotificationListener(this.groupingHandler);
                this.groupingHandler = null;
            }
            if (this.clusterManager != null) {
                this.clusterManager.stop();
            }
        }
        for (ServerSession session : this.sessions.values()) {
            session.close(true);
            session.waitContextCompletion();
        }
        this.remotingService.stop();
        hornetQServerImpl = this;
        synchronized (hornetQServerImpl) {
            if (this.configuration.isFileDeploymentEnabled()) {
                this.basicUserCredentialsDeployer.stop();
                this.addressSettingsDeployer.stop();
                if (this.queueDeployer != null) {
                    this.queueDeployer.stop();
                }
                if (this.securityDeployer != null) {
                    this.securityDeployer.stop();
                }
                this.deploymentManager.stop();
            }
            this.managementService.unregisterServer();
            this.managementService.stop();
            if (this.pagingManager != null) {
                this.pagingManager.stop();
            }
            if (this.storageManager != null) {
                this.storageManager.stop();
            }
            if (this.replicationManager != null) {
                this.replicationManager.stop();
                this.replicationManager = null;
            }
            if (this.replicationEndpoint != null) {
                this.replicationEndpoint.stop();
                this.replicationEndpoint = null;
            }
            if (this.securityManager != null) {
                this.securityManager.stop();
            }
            if (this.resourceManager != null) {
                this.resourceManager.stop();
            }
            if (this.postOffice != null) {
                this.postOffice.stop();
            }
            List<Runnable> tasks = this.scheduledPool.shutdownNow();
            for (Runnable task : tasks) {
                log.debug("Waiting for " + task);
            }
            if (this.memoryManager != null) {
                this.memoryManager.stop();
            }
            this.threadPool.shutdown();
            this.scheduledPool.shutdown();
            try {
                if (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    log.warn("Timed out waiting for pool to terminate");
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.threadPool = null;
            try {
                if (!this.scheduledPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    log.warn("Timed out waiting for scheduled pool to terminate");
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.threadPool = null;
            this.scheduledPool = null;
            this.pagingManager = null;
            this.securityStore = null;
            this.resourceManager = null;
            this.postOffice = null;
            this.securityStore = null;
            this.queueFactory = null;
            this.resourceManager = null;
            this.messagingServerControl = null;
            this.memoryManager = null;
            this.sessions.clear();
            this.started = false;
            this.initialised = false;
            SimpleString tempNodeID = this.getNodeID();
            if (this.activation != null) {
                this.activation.close(failoverOnServerShutdown);
            }
            if (this.backupActivationThread != null) {
                this.backupActivationThread.join();
            }
            this.nodeManager.stop();
            this.nodeManager = null;
            log.info("HornetQ Server version " + this.getVersion().getFullVersion() + " [" + tempNodeID + "] stopped");
            Logger.reset();
        }
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public ScheduledExecutorService getScheduledPool() {
        return this.scheduledPool;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    @Override
    public RemotingService getRemotingService() {
        return this.remotingService;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public HornetQSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public HierarchicalRepository<Set<Role>> getSecurityRepository() {
        return this.securityRepository;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository() {
        return this.addressSettingsRepository;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public ServerSession createSession(String name, String username, String password, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback) throws Exception {
        if (this.securityStore != null) {
            this.securityStore.authenticate(username, password);
        }
        ServerSessionImpl session = new ServerSessionImpl(name, username, password, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, this.configuration.isPersistDeliveryCountBeforeDelivery(), xa, connection, this.storageManager, this.postOffice, this.resourceManager, this.securityStore, this.managementService, this, this.configuration.getManagementAddress(), defaultAddress == null ? null : new SimpleString(defaultAddress), callback);
        this.sessions.put(name, session);
        return session;
    }

    @Override
    public synchronized ReplicationEndpoint connectToReplicationEndpoint(Channel channel) throws Exception {
        if (!this.configuration.isBackup()) {
            throw new HornetQException(104, "Connected server is not a backup server");
        }
        if (this.replicationEndpoint.getChannel() != null) {
            throw new HornetQException(104, "Backup replication server is already connected to another server");
        }
        this.replicationEndpoint.setChannel(channel);
        return this.replicationEndpoint;
    }

    @Override
    public void removeSession(String name) throws Exception {
        this.sessions.remove(name);
    }

    @Override
    public synchronized List<ServerSession> getSessions(String connectionID) {
        Set<Map.Entry<String, ServerSession>> sessionEntries = this.sessions.entrySet();
        ArrayList<ServerSession> matchingSessions = new ArrayList<ServerSession>();
        for (Map.Entry<String, ServerSession> sessionEntry : sessionEntries) {
            ServerSession serverSession = sessionEntry.getValue();
            if (!serverSession.getConnectionID().toString().equals(connectionID)) continue;
            matchingSessions.add(serverSession);
        }
        return matchingSessions;
    }

    @Override
    public synchronized Set<ServerSession> getSessions() {
        return new HashSet<ServerSession>(this.sessions.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialised() {
        Object object = this.initialiseLock;
        synchronized (object) {
            return this.initialised;
        }
    }

    @Override
    public HornetQServerControlImpl getHornetQServerControl() {
        return this.messagingServerControl;
    }

    @Override
    public int getConnectionCount() {
        return this.remotingService.getConnections().size();
    }

    @Override
    public PostOffice getPostOffice() {
        return this.postOffice;
    }

    @Override
    public QueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    @Override
    public SimpleString getNodeID() {
        return this.nodeManager == null ? null : this.nodeManager.getNodeId();
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, queueName, filterString, durable, temporary, false);
    }

    @Override
    public Queue locateQueue(SimpleString queueName) throws Exception {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            return null;
        }
        Bindable queue = binding.getBindable();
        if (!(queue instanceof Queue)) {
            throw new IllegalStateException("locateQueue should only be used to locate queues");
        }
        return (Queue)binding.getBindable();
    }

    @Override
    public Queue deployQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        log.info("trying to deploy queue " + queueName);
        return this.createQueue(address, queueName, filterString, durable, temporary, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, ServerSession session) throws Exception {
        this.addressSettingsRepository.clearCache();
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            throw new HornetQException(100, "No such queue " + queueName);
        }
        Queue queue = (Queue)binding.getBindable();
        if (queue.getPageSubscription() != null) {
            queue.getPageSubscription().close();
        }
        if (queue.getConsumerCount() != 0) {
            throw new HornetQException(104, "Cannot delete queue " + queue.getName() + " on binding " + queueName + " - it has consumers = " + binding.getClass().getName());
        }
        if (session != null) {
            if (queue.isDurable()) {
                this.securityStore.check(binding.getAddress(), CheckType.DELETE_DURABLE_QUEUE, session);
            } else {
                this.securityStore.check(binding.getAddress(), CheckType.DELETE_NON_DURABLE_QUEUE, session);
            }
        }
        queue.deleteAllReferences();
        if (queue.isDurable()) {
            this.storageManager.deleteQueueBinding(queue.getID());
        }
        this.postOffice.removeBinding(queueName);
    }

    @Override
    public synchronized void registerActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.add(callback);
    }

    @Override
    public synchronized void unregisterActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.remove(callback);
    }

    @Override
    public synchronized ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public void setGroupingHandler(GroupingHandler groupingHandler) {
        this.groupingHandler = groupingHandler;
    }

    @Override
    public GroupingHandler getGroupingHandler() {
        return this.groupingHandler;
    }

    @Override
    public ReplicationEndpoint getReplicationEndpoint() {
        return this.replicationEndpoint;
    }

    @Override
    public ReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    @Override
    public ConnectorsService getConnectorsService() {
        return this.connectorsService;
    }

    protected PagingManager createPagingManager() {
        return new PagingManagerImpl(new PagingStoreFactoryNIO(this.configuration.getPagingDirectory(), this.configuration.getJournalBufferSize_NIO(), this.scheduledPool, this.executorFactory, this.configuration.isJournalSyncNonTransactional()), this.storageManager, this.addressSettingsRepository);
    }

    protected StorageManager createStorageManager() {
        if (this.configuration.isPersistenceEnabled()) {
            return new JournalStorageManager(this.configuration, this.executorFactory, this.replicationManager);
        }
        return new NullStorageManager();
    }

    private void callActivateCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activated();
        }
    }

    private void callPreActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.preActivate();
        }
    }

    @Override
    public synchronized boolean checkActivate() throws Exception {
        if (this.configuration.isBackup()) {
            if (!this.configuration.isSharedStore()) {
                if (this.replicationEndpoint == null) {
                    log.warn("There is no replication endpoint, can't activate this backup server");
                    throw new HornetQException(0, "Can't activate the server");
                }
                this.replicationEndpoint.stop();
            }
            log.info("Activating backup server");
            this.configuration.setBackup(false);
            this.initialisePart2();
        }
        return true;
    }

    private void initialiseLogging() {
        LogDelegateFactory logDelegateFactory = (LogDelegateFactory)this.instantiateInstance(this.configuration.getLogDelegateFactoryClassName());
        Logger.setDelegateFactory(logDelegateFactory);
    }

    private void initialisePart1() throws Exception {
        HornetQThreadFactory tFactory = new HornetQThreadFactory("HornetQ-server-threads" + System.identityHashCode(this), false, HornetQServerImpl.getThisClassLoader());
        this.threadPool = this.configuration.getThreadPoolMaxSize() == -1 ? Executors.newCachedThreadPool(tFactory) : Executors.newFixedThreadPool(this.configuration.getThreadPoolMaxSize(), tFactory);
        this.executorFactory = new OrderedExecutorFactory(this.threadPool);
        this.scheduledPool = new ScheduledThreadPoolExecutor(this.configuration.getScheduledThreadPoolMaxSize(), new HornetQThreadFactory("HornetQ-scheduled-threads", false, HornetQServerImpl.getThisClassLoader()));
        this.managementService = new ManagementServiceImpl(this.mbeanServer, this.configuration);
        this.remotingService = new RemotingServiceImpl(this.configuration, this, this.managementService, this.scheduledPool);
        if (this.configuration.getMemoryMeasureInterval() != -1L) {
            this.memoryManager = new MemoryManagerImpl(this.configuration.getMemoryWarningThreshold(), this.configuration.getMemoryMeasureInterval());
            this.memoryManager.start();
        }
        if (this.configuration.isFileDeploymentEnabled()) {
            this.deploymentManager = new FileDeploymentManager(this.configuration.getFileDeployerScanPeriod());
        }
        this.callPreActiveCallbacks();
        this.storageManager = this.createStorageManager();
        if ("HORNETQ.CLUSTER.ADMIN.USER".equals(this.configuration.getClusterUser()) && "CHANGE ME!!".equals(this.configuration.getClusterPassword())) {
            log.warn("Security risk! It has been detected that the cluster admin user and password have not been changed from the installation default. Please see the HornetQ user guide, cluster chapter, for instructions on how to do this.");
        }
        this.securityStore = new SecurityStoreImpl(this.securityRepository, this.securityManager, this.configuration.getSecurityInvalidationInterval(), this.configuration.isSecurityEnabled(), this.configuration.getClusterUser(), this.configuration.getClusterPassword(), this.managementService);
        this.queueFactory = new QueueFactoryImpl(this.executorFactory, this.scheduledPool, this.addressSettingsRepository, this.storageManager);
        this.pagingManager = this.createPagingManager();
        this.resourceManager = new ResourceManagerImpl((int)(this.configuration.getTransactionTimeout() / 1000L), this.configuration.getTransactionTimeoutScanPeriod(), this.scheduledPool);
        this.postOffice = new PostOfficeImpl(this, this.storageManager, this.pagingManager, this.queueFactory, this.managementService, this.configuration.getMessageExpiryScanPeriod(), this.configuration.getMessageExpiryThreadPriority(), this.configuration.isWildcardRoutingEnabled(), this.configuration.getIDCacheSize(), this.configuration.isPersistIDCache(), this.addressSettingsRepository);
        this.messagingServerControl = this.managementService.registerServer(this.postOffice, this.storageManager, this.configuration, this.addressSettingsRepository, this.securityRepository, this.resourceManager, this.remotingService, this, this.queueFactory, this.scheduledPool, this.pagingManager, this.configuration.isBackup());
        if (this.configuration.isFileDeploymentEnabled()) {
            this.addressSettingsDeployer = new AddressSettingsDeployer(this.deploymentManager, this.addressSettingsRepository);
            this.addressSettingsDeployer.start();
        }
        this.deployAddressSettingsFromConfiguration();
        this.storageManager.start();
        if (this.securityManager != null) {
            this.securityManager.start();
        }
        this.postOffice.start();
        this.pagingManager.start();
        this.managementService.start();
        this.resourceManager.start();
        if (this.configuration.isFileDeploymentEnabled()) {
            this.basicUserCredentialsDeployer = new BasicUserCredentialsDeployer(this.deploymentManager, this.securityManager);
            this.basicUserCredentialsDeployer.start();
            if (this.securityManager != null) {
                this.securityDeployer = new SecurityDeployer(this.deploymentManager, this.securityRepository);
                this.securityDeployer.start();
            }
        }
        this.deploySecurityFromConfiguration();
        this.deployGroupingHandlerConfiguration(this.configuration.getGroupingHandlerConfiguration());
        this.clusterManager = new ClusterManagerImpl(this.executorFactory, this, this.postOffice, this.scheduledPool, this.managementService, this.configuration, this.nodeManager.getUUID(), this.configuration.isBackup(), this.configuration.isClustered());
    }

    private void initialisePart2() throws Exception {
        this.pagingManager.reloadStores();
        JournalLoadInformation[] journalInfo = this.loadJournals();
        this.compareJournals(journalInfo);
        final ServerInfo dumper = new ServerInfo(this, this.pagingManager);
        long dumpInfoInterval = this.configuration.getServerDumpInterval();
        if (dumpInfoInterval > 0L) {
            this.scheduledPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    log.info(dumper.dump());
                }
            }, 0L, dumpInfoInterval, TimeUnit.MILLISECONDS);
        }
        if (this.configuration.isFileDeploymentEnabled()) {
            this.queueDeployer = new QueueDeployer(this.deploymentManager, this);
            this.queueDeployer.start();
        } else {
            this.deployQueuesFromConfiguration();
        }
        this.callActivateCallbacks();
        this.deployDiverts();
        if (this.deploymentManager != null) {
            this.deploymentManager.start();
        }
        this.remotingService.start();
        this.clusterManager.start();
        this.initialised = true;
    }

    private void compareJournals(JournalLoadInformation[] journalInfo) throws Exception {
        if (this.replicationManager != null) {
            this.replicationManager.compareJournals(journalInfo);
        }
    }

    private void deploySecurityFromConfiguration() {
        for (Map.Entry<String, Set<Role>> entry : this.configuration.getSecurityRoles().entrySet()) {
            this.securityRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private void deployQueuesFromConfiguration() throws Exception {
        for (CoreQueueConfiguration config : this.configuration.getQueueConfigurations()) {
            this.deployQueue(SimpleString.toSimpleString(config.getAddress()), SimpleString.toSimpleString(config.getName()), SimpleString.toSimpleString(config.getFilterString()), config.isDurable(), false);
        }
    }

    private void deployAddressSettingsFromConfiguration() {
        for (Map.Entry<String, AddressSettings> entry : this.configuration.getAddressesSettings().entrySet()) {
            this.addressSettingsRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private JournalLoadInformation[] loadJournals() throws Exception {
        JournalLoadInformation[] journalInfo = new JournalLoadInformation[2];
        ArrayList<QueueBindingInfo> queueBindingInfos = new ArrayList<QueueBindingInfo>();
        ArrayList<GroupingInfo> groupingInfos = new ArrayList<GroupingInfo>();
        journalInfo[0] = this.storageManager.loadBindingJournal(queueBindingInfos, groupingInfos);
        this.recoverStoredConfigs();
        HashMap<Long, Queue> queues = new HashMap<Long, Queue>();
        HashMap<Long, QueueBindingInfo> queueBindingInfosMap = new HashMap<Long, QueueBindingInfo>();
        for (QueueBindingInfo queueBindingInfo : queueBindingInfos) {
            queueBindingInfosMap.put(queueBindingInfo.getId(), queueBindingInfo);
            Filter filter = FilterImpl.createFilter(queueBindingInfo.getFilterString());
            PageSubscription subscription = this.pagingManager.getPageStore(queueBindingInfo.getAddress()).getCursorProvier().createSubscription(queueBindingInfo.getId(), filter, true);
            Queue queue = this.queueFactory.createQueue(queueBindingInfo.getId(), queueBindingInfo.getAddress(), queueBindingInfo.getQueueName(), filter, subscription, true, false);
            LocalQueueBinding binding = new LocalQueueBinding(queueBindingInfo.getAddress(), queue, this.nodeManager.getNodeId());
            queues.put(queueBindingInfo.getId(), queue);
            this.postOffice.addBinding(binding);
            this.managementService.registerAddress(queueBindingInfo.getAddress());
            this.managementService.registerQueue(queue, queueBindingInfo.getAddress(), this.storageManager);
        }
        for (GroupingInfo groupingInfo : groupingInfos) {
            if (this.groupingHandler == null) continue;
            this.groupingHandler.addGroupBinding(new GroupBinding(groupingInfo.getId(), groupingInfo.getGroupId(), groupingInfo.getClusterName()));
        }
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        journalInfo[1] = this.storageManager.loadMessageJournal(this.postOffice, this.pagingManager, this.resourceManager, queues, queueBindingInfosMap, duplicateIDMap);
        for (Map.Entry entry : duplicateIDMap.entrySet()) {
            SimpleString address = (SimpleString)entry.getKey();
            DuplicateIDCache cache = this.postOffice.getDuplicateIDCache(address);
            if (!this.configuration.isPersistIDCache()) continue;
            cache.load((List)entry.getValue());
        }
        return journalInfo;
    }

    private void recoverStoredConfigs() throws Exception {
        List<PersistedAddressSetting> adsettings = this.storageManager.recoverAddressSettings();
        for (PersistedAddressSetting set : adsettings) {
            this.addressSettingsRepository.addMatch(set.getAddressMatch().toString(), set.getSetting());
        }
        List<PersistedRoles> roles = this.storageManager.recoverPersistedRoles();
        for (PersistedRoles roleItem : roles) {
            Set<Role> setRoles = SecurityFormatter.createSecurity(roleItem.getSendRoles(), roleItem.getConsumeRoles(), roleItem.getCreateDurableQueueRoles(), roleItem.getDeleteDurableQueueRoles(), roleItem.getCreateNonDurableQueueRoles(), roleItem.getDeleteNonDurableQueueRoles(), roleItem.getManageRoles());
            this.securityRepository.addMatch(roleItem.getAddressMatch().toString(), setRoles);
        }
    }

    private Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary, boolean ignoreIfExists) throws Exception {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding != null) {
            if (ignoreIfExists) {
                return null;
            }
            throw new HornetQException(101, "Queue " + queueName + " already exists");
        }
        Filter filter = FilterImpl.createFilter(filterString);
        long queueID = this.storageManager.generateUniqueID();
        PageSubscription pageSubscription = filterString != null && filterString.toString().equals(GENERIC_IGNORED_FILTER) ? null : this.pagingManager.getPageStore(address).getCursorProvier().createSubscription(queueID, filter, durable);
        Queue queue = this.queueFactory.createQueue(queueID, address, queueName, filter, pageSubscription, durable, temporary);
        binding = new LocalQueueBinding(address, queue, this.nodeManager.getNodeId());
        if (durable) {
            this.storageManager.addQueueBinding(binding);
        }
        this.postOffice.addBinding(binding);
        this.managementService.registerAddress(address);
        this.managementService.registerQueue(queue, address, this.storageManager);
        return queue;
    }

    private void deployDiverts() throws Exception {
        for (DivertConfiguration config : this.configuration.getDivertConfigurations()) {
            this.deployDivert(config);
        }
    }

    @Override
    public void deployDivert(DivertConfiguration config) throws Exception {
        if (config.getName() == null) {
            log.warn("Must specify a name for each divert. This one will not be deployed.");
            return;
        }
        if (config.getAddress() == null) {
            log.warn("Must specify an address for each divert. This one will not be deployed.");
            return;
        }
        if (config.getForwardingAddress() == null) {
            log.warn("Must specify an forwarding address for each divert. This one will not be deployed.");
            return;
        }
        SimpleString sName = new SimpleString(config.getName());
        if (this.postOffice.getBinding(sName) != null) {
            log.warn("Binding already exists with name " + sName + ", divert will not be deployed");
            return;
        }
        SimpleString sAddress = new SimpleString(config.getAddress());
        Transformer transformer = this.instantiateTransformer(config.getTransformerClassName());
        Filter filter = FilterImpl.createFilter(config.getFilterString());
        DivertImpl divert = new DivertImpl(new SimpleString(config.getForwardingAddress()), sName, new SimpleString(config.getRoutingName()), config.isExclusive(), filter, transformer, this.postOffice, this.storageManager);
        DivertBinding binding = new DivertBinding(this.storageManager.generateUniqueID(), sAddress, divert);
        this.postOffice.addBinding(binding);
        this.managementService.registerDivert(divert, config);
    }

    @Override
    public void destroyDivert(SimpleString name) throws Exception {
        Binding binding = this.postOffice.getBinding(name);
        if (binding == null) {
            throw new HornetQException(0, "No binding for divert " + name);
        }
        if (!(binding instanceof DivertBinding)) {
            throw new HornetQException(0, "Binding " + name + " is not a divert");
        }
        this.postOffice.removeBinding(name);
    }

    private synchronized void deployGroupingHandlerConfiguration(GroupingHandlerConfiguration config) throws Exception {
        if (config != null) {
            GroupingHandler groupingHandler = config.getType() == GroupingHandlerConfiguration.TYPE.LOCAL ? new LocalGroupingHandler(this.managementService, config.getName(), config.getAddress(), this.getStorageManager(), config.getTimeout()) : new RemoteGroupingHandler(this.managementService, config.getName(), config.getAddress(), config.getTimeout());
            this.groupingHandler = groupingHandler;
            this.managementService.addNotificationListener(groupingHandler);
        }
    }

    @Override
    public void deployBridge(BridgeConfiguration config) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.deployBridge(config);
        }
    }

    @Override
    public void destroyBridge(String name) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.destroyBridge(name);
        }
    }

    private Transformer instantiateTransformer(String transformerClassName) {
        Transformer transformer = null;
        if (transformerClassName != null) {
            transformer = (Transformer)this.instantiateInstance(transformerClassName);
        }
        return transformer;
    }

    private Object instantiateInstance(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clz = loader.loadClass(className);
            Object object = clz.newInstance();
            return object;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error instantiating class \"" + className + "\"", e);
        }
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    @Override
    public ServerSession getSessionByID(String sessionName) {
        return this.sessions.get(sessionName);
    }

    private void checkJournalDirectory() {
        File journalDir = new File(this.configuration.getJournalDirectory());
        if (!journalDir.exists()) {
            if (this.configuration.isCreateJournalDir()) {
                journalDir.mkdirs();
            } else {
                throw new IllegalArgumentException("Directory " + journalDir + " does not exist and will not be created");
            }
        }
    }

    public String toString() {
        return "HornetQServerImpl::" + (this.identity == null ? "" : this.identity + ", ") + (this.nodeManager != null ? "serverUUID=" + this.nodeManager.getUUID() : "");
    }

    private class FileActivateRunner
    implements Runnable {
        private FileActivateRunner() {
        }

        @Override
        public void run() {
        }
    }

    private class SharedNothingBackupActivation
    implements Activation {
        private SharedNothingBackupActivation() {
        }

        @Override
        public void run() {
        }

        @Override
        public void close(boolean permanently) throws Exception {
        }
    }

    private class SharedStoreBackupActivation
    implements Activation {
        private SharedStoreBackupActivation() {
        }

        @Override
        public void run() {
            try {
                HornetQServerImpl.this.nodeManager.startBackup();
                HornetQServerImpl.this.initialisePart1();
                HornetQServerImpl.this.clusterManager.start();
                HornetQServerImpl.this.started = true;
                log.info("HornetQ Backup Server version " + HornetQServerImpl.this.getVersion().getFullVersion() + " [" + HornetQServerImpl.this.nodeManager.getNodeId() + "] started, waiting live to fail before it gets active");
                HornetQServerImpl.this.nodeManager.awaitLiveNode();
                HornetQServerImpl.this.configuration.setBackup(false);
                HornetQServerImpl.this.initialisePart2();
                HornetQServerImpl.this.clusterManager.activate();
                log.info("Backup Server is now live");
                HornetQServerImpl.this.nodeManager.releaseBackup();
                if (HornetQServerImpl.this.configuration.isAllowAutoFailBack()) {
                    class FailbackChecker
                    implements Runnable {
                        boolean restarting = false;

                        FailbackChecker() {
                        }

                        @Override
                        public void run() {
                            try {
                                if (!this.restarting && HornetQServerImpl.this.nodeManager.isAwaitingFailback()) {
                                    log.info("live server wants to restart, restarting server in backup");
                                    this.restarting = true;
                                    Thread t = new Thread(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                HornetQServerImpl.this.stop(true);
                                                HornetQServerImpl.this.configuration.setBackup(true);
                                                HornetQServerImpl.this.start();
                                            }
                                            catch (Exception e) {
                                                log.info("unable to restart server, please kill and restart manually", e);
                                            }
                                        }
                                    });
                                    t.start();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    HornetQServerImpl.this.scheduledPool.scheduleAtFixedRate(new FailbackChecker(), 1000L, 1000L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
            }
            catch (ClosedChannelException e) {
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof InterruptedException)) {
                    log.error("Failure in initialisation", e);
                }
            }
            catch (Throwable e) {
                log.error("Failure in initialisation", e);
            }
        }

        @Override
        public void close(boolean permanently) throws Exception {
            if (HornetQServerImpl.this.configuration.isBackup()) {
                long timeout = 30000L;
                long start = System.currentTimeMillis();
                while (HornetQServerImpl.this.backupActivationThread.isAlive() && System.currentTimeMillis() - start < timeout) {
                    HornetQServerImpl.this.nodeManager.interrupt();
                    HornetQServerImpl.this.backupActivationThread.interrupt();
                    Thread.sleep(1000L);
                }
                if (System.currentTimeMillis() - start >= timeout) {
                    log.warn("Timed out waiting for backup activation to exit");
                }
                HornetQServerImpl.this.nodeManager.stopBackup();
            } else if (permanently) {
                HornetQServerImpl.this.nodeManager.crashLiveServer();
            } else {
                HornetQServerImpl.this.nodeManager.pauseLiveServer();
            }
        }
    }

    private class SharedStoreLiveActivation
    implements Activation {
        private SharedStoreLiveActivation() {
        }

        @Override
        public void run() {
            try {
                log.info("Waiting to obtain live lock");
                HornetQServerImpl.this.checkJournalDirectory();
                HornetQServerImpl.this.initialisePart1();
                if (HornetQServerImpl.this.nodeManager.isBackupLive()) {
                    HornetQServerImpl.this.clusterManager.announceBackup();
                    Thread.sleep(HornetQServerImpl.this.configuration.getFailbackDelay());
                }
                HornetQServerImpl.this.nodeManager.startLiveNode();
                HornetQServerImpl.this.initialisePart2();
                log.info("Server is now live");
            }
            catch (Exception e) {
                log.error("Failure in initialisation", e);
            }
        }

        @Override
        public void close(boolean permanently) throws Exception {
            if (permanently) {
                HornetQServerImpl.this.nodeManager.crashLiveServer();
            } else {
                HornetQServerImpl.this.nodeManager.pauseLiveServer();
            }
        }
    }

    private class NoSharedStoreLiveActivation
    implements Activation {
        private NoSharedStoreLiveActivation() {
        }

        @Override
        public void run() {
            try {
                HornetQServerImpl.this.initialisePart1();
                HornetQServerImpl.this.initialisePart2();
                log.info("Server is now live");
            }
            catch (Exception e) {
                log.error("Failure in initialisation", e);
            }
        }

        @Override
        public void close(boolean permanently) throws Exception {
        }
    }

    private static interface Activation
    extends Runnable {
        public void close(boolean var1) throws Exception;
    }
}

