/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.util.logging.AOPLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectToJavassist {
    private static final AOPLogger logger = AOPLogger.getLogger(ReflectToJavassist.class);

    public static CtClass classToJavassist(Class<?> clazz) throws NotFoundException {
        ClassPool pool = AspectManager.instance().findClassPool(clazz);
        CtClass ct = pool.get(clazz.getName());
        return ct;
    }

    public static CtField fieldToJavassist(Field field) throws NotFoundException {
        try {
            return ReflectToJavassist.classToJavassist(field.getDeclaringClass()).getField(field.getName());
        }
        catch (NotFoundException nfe) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("Field " + field.getName() + " doesn't exist in " + field.getDeclaringClass());
            }
            return null;
        }
    }

    public static CtConstructor constructorToJavassist(Constructor<?> con) throws NotFoundException {
        Class<?> clazz = con.getDeclaringClass();
        Class<?>[] params = con.getParameterTypes();
        String[] strParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            strParams[i] = ReflectToJavassist.simpleType(params[i]);
        }
        CtClass ct = ReflectToJavassist.classToJavassist(clazz);
        CtConstructor[] methods = ct.getDeclaredConstructors();
        for (int i = 0; i < methods.length; ++i) {
            CtClass[] ctParams = methods[i].getParameterTypes();
            if (ctParams.length != params.length) continue;
            boolean found = true;
            for (int j = 0; j < ctParams.length; ++j) {
                if (ctParams[j].getName().equals(strParams[j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return methods[i];
        }
        return null;
    }

    protected static String simpleType(Class<?> type) {
        Class<?> ret = type;
        if (ret.isArray()) {
            Class<?> arr = ret;
            String array = "";
            while (arr.isArray()) {
                array = array + "[]";
                arr = arr.getComponentType();
            }
            return arr.getName() + array;
        }
        return ret.getName();
    }

    public static CtMethod methodToJavassist(Method method) throws NotFoundException {
        Class<?> clazz = method.getDeclaringClass();
        Class<?>[] params = method.getParameterTypes();
        String[] strParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            strParams[i] = ReflectToJavassist.simpleType(params[i]);
        }
        CtClass ct = ReflectToJavassist.classToJavassist(clazz);
        while (!ct.getName().equals(clazz.getName())) {
            ct = ct.getSuperclass();
        }
        CtMethod[] methods = ct.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            CtClass[] ctParams;
            if (!methods[i].getName().equals(method.getName()) || (ctParams = methods[i].getParameterTypes()).length != params.length) continue;
            boolean found = true;
            for (int j = 0; j < ctParams.length; ++j) {
                if (ctParams[j].getName().equals(strParams[j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return methods[i];
        }
        return null;
    }

    public static String castInvocationValueToTypeString(Class<?> type, String valueName) {
        String cast = null;
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                cast = "((Boolean)" + valueName + ").booleanValue()";
            } else if (type.equals(Byte.TYPE)) {
                cast = "((Byte)" + valueName + ").byteValue()";
            } else if (type.equals(Character.TYPE)) {
                cast = "((Character)" + valueName + ").charValue()";
            } else if (type.equals(Double.TYPE)) {
                cast = "((Double)" + valueName + ").doubleValue()";
            } else if (type.equals(Float.TYPE)) {
                cast = "((Float)" + valueName + ").floatValue()";
            } else if (type.equals(Integer.TYPE)) {
                cast = "((Integer)" + valueName + ").intValue()";
            } else if (type.equals(Long.TYPE)) {
                cast = "((Long)" + valueName + ").longValue()";
            } else if (type.equals(Short.TYPE)) {
                cast = "((Short)" + valueName + ").shortValue()";
            }
        } else {
            cast = type.isArray() ? "(" + type.getName() + ")" + valueName : "(" + type.getName() + ")" + valueName;
        }
        return cast;
    }
}

