/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.bean.history.operation;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.on.embedded.manager.history.AbstractHistoryManager;
import org.jboss.on.embedded.manager.history.operation.OperationHistoryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="historyManager")
@Scope(value=ScopeType.APPLICATION)
public class OperationHistoryManagerBean
extends AbstractHistoryManager<OperationHistory>
implements OperationHistoryManager {
    private AtomicInteger jobNameId = new AtomicInteger(0);

    @Override
    public OperationHistory addOperationHistory(String operationName, Configuration parameters, Resource resource, ResourceType resourceType) {
        ResourceOperationHistory operationHistory = null;
        OperationDefinition operationDefinition = OperationHistoryManagerBean.getOperationDefinition(operationName, resourceType);
        if (operationDefinition != null) {
            int id = this.jobNameId.incrementAndGet();
            String jobName = operationDefinition.getName() + "-" + id;
            operationHistory = new ResourceOperationHistory(jobName, "", resource.getName(), operationDefinition, parameters, resource, null);
            operationHistory.setId(id);
            this.addToMaps(operationHistory, resource, resourceType);
        }
        return operationHistory;
    }

    private static OperationDefinition getOperationDefinition(String operationName, ResourceType resourceType) {
        Set operationDefinitions = resourceType.getOperationDefinitions();
        OperationDefinition operationDefinition = null;
        for (OperationDefinition definition : operationDefinitions) {
            if (!definition.getName().equals(operationName)) continue;
            operationDefinition = definition;
        }
        return operationDefinition;
    }

    @Override
    protected String getJobId(OperationHistory history) {
        return history.getJobId().toString();
    }
}

