/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.bean.ResourceListItem;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.NavigationAction;
import org.jboss.on.embedded.ui.nav.JONTreeNode;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="commonActionUtil")
public class CommonActionUtil {
    private final Log LOG = LogFactory.getLog(CommonActionUtil.class);
    @In
    private NavigationAction navigationAction;

    public ResourceListItem getCurrentResourceListItem() {
        Resource resource = this.getCurrentResource();
        ResourceManager resourceManager = ResourceManagerFactory.resourceManager();
        Availability availability = resourceManager.getAvailability(resource);
        ResourceListItem resourceListItem = new ResourceListItem(resource, availability);
        return resourceListItem;
    }

    public Resource getCurrentResource() {
        int resourceId;
        String path = this.navigationAction.getCurrentPath();
        try {
            if (path.equals("/")) {
                resourceId = 0;
                this.LOG.info((Object)"Application just started, so the Resource path is showing as '/'");
            } else {
                resourceId = Integer.valueOf(path);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not parse path [" + path + "] into a numeric Resource id.");
        }
        ResourceManager resourceManager = ResourceManagerFactory.resourceManager();
        Resource resource = resourceManager.getResource(resourceId);
        if (resource == null) {
            throw new IllegalStateException("Resource with id " + resourceId + " not found.");
        }
        return resource;
    }

    public List<SelectItem> asSelectItemList() {
        JONTreeNode selectedNode = this.navigationAction.getSelectedNode();
        Collection<JONTreeNode> c = selectedNode.getChildNodes();
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        if (c != null) {
            result.add(new SelectItem((Object)"All Types"));
            for (JONTreeNode node : c) {
                result.add(new SelectItem((Object)node.getPath(), node.getName()));
            }
        }
        return result;
    }
}

