/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import javax.transaction.RollbackException;
import javax.transaction.Status;
import javax.transaction.TransactionManager;

import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;

/**
 * @author Brian Stansberry
 *
 */
class BatchingManagerImpl implements BatchingManager
{
   private static final Logger log = Logger.getLogger(BatchingManagerImpl.class);
   
   private final TransactionManager tm;
   
   BatchingManagerImpl(TransactionManager tm)
   {
      assert tm != null : " batchingManager is null";
      
      this.tm = tm;
   }

   public boolean isBatchInProgress() throws Exception
   {
      return (tm.getTransaction() != null);
   }

   public void startBatch() throws Exception
   {
      tm.begin();
   }

   public void setBatchRollbackOnly() throws Exception
   {
      tm.setRollbackOnly();
   }

   public void endBatch()
   {
      try
      {
         if(tm.getTransaction().getStatus() != Status.STATUS_MARKED_ROLLBACK)
         {
            tm.commit();
         }
         else
         {
            log.debug("endBatch(): rolling back batch");
            tm.rollback();
         }
      }
      catch (RollbackException re)
      {
         // Do nothing here since cache may rollback automatically.
         log.warn("endBatch(): rolling back transaction with exception: " +re);
      }
      catch (RuntimeException re)
      {
         throw re;
      }
      catch (Exception e)
      {
         throw new RuntimeException("endTransaction(): Caught Exception ending batch: ", e);
      }
      
   }
   
   
   
}
