package org.jboss.seam.test.integration;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.TransactionPropagationType;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.bpm.CreateProcess;
import org.jboss.seam.mock.SeamTest;
import org.testng.annotations.Test;

public class BusinessProcessTest 
    extends SeamTest
{
   
   static final String EXCEPTION_MESSAGE = "org.jbpm.jpdl.el.ELException: Error evaluating ${seamExpressionEvaluatorTestController.exceptionThrowing}; possible causes are logged at debug level";
   
    @Test
    public void noProcessDefinition() 
        throws Exception 
    {
        new FacesRequest() {
            @Override
            protected void invokeApplication() throws Exception {
                try {
                    invokeAction("#{bpmTest.startInvalid}");
                    assert false;
                } catch (Exception e) {
                    // expected
                }
            }

        }.run();
    }
    
    @Test
    public void noVariableStart() 
        throws Exception 
    {
        new FacesRequest() {
            @Override
            protected void invokeApplication() throws Exception {
                try {
                    invokeAction("#{bpmTest.startOne}");
                } catch (Exception e) {
                    assert false;
                }
            }

        }.run();
    }
    
   @Test (dependsOnMethods = "asyncExceptionHandling" )
   public void exceptionHandling() throws Exception
   {
      new FacesRequest(){
         
         @Override
         protected void invokeApplication() throws Exception 
         {
            try {
               invokeAction("#{bpmTest.startExceptionPageflow}");
               assert false;
            } catch (Exception e) {         
//               System.out.println(e.getMessage());
//               System.out.println(EXCEPTION_MESSAGE);
               assert EXCEPTION_MESSAGE.equals(e.getMessage());               
            }
            
         }
      }.run();
   }
   
   @Test 
   public void asyncExceptionHandling() throws Exception
   {
      new FacesRequest(){
         
         @Override
         protected void invokeApplication() throws Exception 
         {            
               invokeAction("#{bpmTest.startAsyncExceptionPageflow}");
         }
      }.run();
   }
    
    
    @Name("bpmTest")
    static public class ProcessComponent {
        @CreateProcess(definition="NoSuchProcess") 
        public void startInvalid() {
        }
        
        @CreateProcess(definition="TestProcess1") 
        public void startOne() {            
        }
        
        @CreateProcess(definition="TestProcess5") 
        public void startExceptionPageflow() 
        {
        }
        
        @CreateProcess(definition="TestProcess6" ) 
        public void startAsyncExceptionPageflow() 
        {
        }
    }
    
    @Name("asyncEcho")
    //@Scope(ScopeType.EVENT)
   public class AsynchEcho    {
       
       @Asynchronous //@Transactional(TransactionPropagationType.REQUIRED)
       public void asyncExceptionThrowing()
       {
          System.out.println("calling async method ********************");
          //throw new RuntimeException("Exception is thrown - test handling");
       }
    }
    
}
