/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.spi;

import java.io.IOException;
import java.util.Collection;

import org.jboss.profileservice.spi.metadata.ProfileMetaData;

/**
 * An interface for obtaining a DeploymentRepository for a Profile.
 *  
 * @author Scott.Stark@jboss.org
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision:$
 */
public interface ProfileRepository
{
   /**
    * Get the keys for all known profiles with a
    * deploymentRepository.
    * 
    * @return keys for all known profiles.
    */
   Collection<ProfileKey> getProfileKeys();

   /**
    * Create a new DeploymentRepository for a profile.
    * 
    * @Param key - the profile key.
    * @param metaData - the profile meta data.
    * @return the profile DeploymentRepository
    * @throws Exception for any error
    */
   DeploymentRepository createProfileDeploymentRepository(ProfileKey key, ProfileMetaData metaData)
      throws Exception;

   /**
    * Get a created DeploymentRepository for the given profile key.
    * 
    * @param key - the key for the Profile to obtain the DeploymentRepository for.
    * @return the profile DeploymentRepository
    * @throws NoSuchProfileException thrown if there is no such profile.
    */
   DeploymentRepository getProfileDeploymentRepository(ProfileKey key)
      throws NoSuchProfileException;

   /**
    * Remove the DeploymentRepository for the given profile key.
    * 
    * @param key - the key for the Profile to obtain the DeploymentRepository for.
    * @throws NoSuchProfileException thrown if there is no such profile.
    * @throws IOException thrown on error removing the repository
    * @throws Exception for any error
    */
   void removeProfileDeploymentRepository(ProfileKey key)
      throws Exception, NoSuchProfileException;
}
