/*
 * JBoss, Home of Professional Open Source
 * Copyright (c) 2010, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.vfs.spi;

import java.util.Iterator;

import org.jboss.ejb3.vfs.spi.util.ServiceLoader;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

/**
 * Factory used to create {@link UnifiedVirtualFile} instances from a {@link VirtualFile}.
 * 
 * @author John Bailey
 */
public abstract class UnifiedVirtualFileFactory
{
   /**
    * Get a factory instance.  
    * 
    * @return factory instance
    */
   public static UnifiedVirtualFileFactory getInstance() {
      ServiceLoader<UnifiedVirtualFileFactory> factoryLoader = ServiceLoader.load(UnifiedVirtualFileFactory.class);
      
      Iterator<UnifiedVirtualFileFactory> factoryIterator = factoryLoader.iterator();
      
      UnifiedVirtualFileFactory factory = null;
      if(factoryIterator.hasNext())
      {
         factory = factoryIterator.next();
         if(factoryIterator.hasNext())
         {
            throw new RuntimeException("More the one service found found for " + UnifiedVirtualFileFactory.class + ", please ensure only one factory implementation is found on the classpath.");
         }
      }
      else 
      {
         throw new RuntimeException("No service found for " + UnifiedVirtualFileFactory.class);
      }
      
      return factory;
   }
   
   /**
    * Create a {@link UnifiedVirtualFile} instance from a provided {@link VirtualFile}
    * 
    * @param virtualFile VirtualFile to {@link VirtualFileAdaptor} from
    * @return the {@link UnifiedVirtualFile}
    */
   public abstract UnifiedVirtualFile create(VirtualFile virtualFile);
}
