%define contentdir /var/www
%define suexec_caller apache
%define mmn 20051115
%define vstring Red Hat
%define distro Red Hat Enterprise Web Server
# Minimum version of OpenSSL having support for the secure TLS reneg API
%define opensslver 0.9.8e-12.el5_4.4

%define _with_zips 1
# If you want to build the zips,
# give rpmbuild option '--with zips'

%define with_zips %{?_with_zips:1}%{!?_with_zips:0}
%define without_zips %{!?_with_zips:1}%{?_with_zips:0}

Summary: Apache HTTP Server
Name: httpd
Version: 2.2.22
Release: 27%{?dist}
URL: http://httpd.apache.org/
Source0: http://www.apache.org/dist/httpd/httpd-%{version}.tar.gz
Source1: index.html
Source3: httpd.logrotate
Source4: httpd.init
Source5: httpd.sysconf
Source10: httpd.conf
Source11: ssl.conf
Source12: welcome.conf
Source13: manual.conf
Source14: proxy_ajp.conf
# Documentation
Source33: README.confd
# Multiplatform file
Source40: httpd.conf.windows
Source41: ssl.conf.windows
# build/scripts patches
Patch1: httpd-2.2.22-apctl.patch
Patch2: httpd-2.2.17-apxs.patch
Patch3: httpd-2.2.9-deplibs.patch
Patch4: httpd-2.2.10-vpath.patch
Patch5: httpd-2.1.10-disablemods.patch
Patch6: httpd-2.1.10-layout.patch

# Features/functional changes
Patch20: httpd-2.2.14-release.patch
Patch21: httpd-2.2.11-xfsz.patch
Patch22: httpd-2.1.10-pod.patch
Patch23: httpd-2.0.45-export.patch
Patch24: httpd-2.2.11-corelimit.patch
Patch25: httpd-2.2.11-selinux.patch
Patch26: httpd-2.2.14-sslocsp.patch
# Multiplatform patches
Patch40: httpd-2.2.10-sol-apr-xpg4.patch
Patch41: httpd-2.2.10-win-defs.patch
Patch42: httpd-2.2.14-win-apr.patch
Patch43: httpd-2.2.17-force-expat1.patch
Patch44: httpd-2.2.10-apmon.patch
Patch45: httpd-2.2.15-nmakefiles.patch

# Bug fixes
Patch60: httpd-2.0.52-logresline.patch
Patch61: httpd-2.2.3-defpidlog.patch
Patch62: httpd-2.2.3-extfiltereos.patch
Patch63: httpd-2.2.3-graceful-ebadf.patch
Patch64: httpd-2.2.3-noxpad.patch
Patch65: httpd-2.2.3-pngmagic.patch
Patch68: httpd-2.2.15-proxyconn.patch
Patch70: httpd-2.2.15-ssloidval.patch
Patch71: httpd-2.2.15-davputfail.patch

Patch75: httpd-2.2.17-bz48735.patch
Patch77: httpd-JBPAPP-3614.patch

Patch79: httpd-2.2.15-CVE-2011-3368.patch
Patch80: httpd-2.2.22-apr.patch
Patch81: httpd-2.2.22-r815719.patch
Patch82: httpd-2.2.22-CVE-2012-2687.patch
Patch84: httpd-2.2.3-r693108.patch
Patch85: httpd-2.2.15-CVE-2012-3499.patch
Patch86: httpd-2.2.15-CVE-2012-4558.patch
Patch87: httpd-ocsp-entrust.patch
Patch88: httpd-2.2.22-ocsptrust.patch
Patch89: httpd-2.2.3-CVE-2013-1862.patch
Patch90: httpd-2.2.25-CVE-2013-1896.patch

License: ASL 2.0
Group: System Environment/Daemons
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: zip
BuildRequires: autoconf, perl, pkgconfig, findutils, ed
BuildRequires: db4-devel, expat-devel, zlib-devel, libselinux-devel
BuildRequires: apr-devel >= 1.2.0, apr-util-devel >= 1.2.0, pcre-devel >= 5.0
Requires: initscripts >= 8.36, /etc/mime.types
Obsoletes: httpd-suexec
Requires(pre): /usr/sbin/useradd
Requires(post): chkconfig
Provides: webserver
Provides: httpd-mmn = %{mmn}
Obsoletes: apache, secureweb, mod_dav, mod_gzip, stronghold-apache, stronghold-htdocs
Obsoletes: mod_put, mod_roaming
Conflicts: pcre < 4.0

#win-buildrequires: xbuild
#win-buildrequires: zlib
#win-buildrequires: libiconv
#win-buildrequires: db4
#win-buildrequires: openssl

#sun-buildrequires: zlib
#sun-buildrequires: db4
#sun-buildrequires: openssl
#sun-buildrequires: cyrus-sasl
#sun-buildrequires: openldap

%description
The Apache HTTP Server is a powerful, efficient, and extensible
web server.
%if %{with_zips}
%package zip
Summary:     Container for the zipped distribution of the Apache HTTP server.
Group:       Development

%description zip
Container for the zipped distribution of the Apache HTTP server.
%endif

%package devel
Group: Development/Libraries
Summary: Development tools for the Apache HTTP server.
Obsoletes: secureweb-devel, apache-devel, stronghold-apache-devel
Requires: apr-devel, apr-util-devel, pkgconfig
Requires: httpd = %{version}-%{release}

%description devel
The httpd-devel package contains the APXS binary and other files
that you need to build Dynamic Shared Objects (DSOs) for the
Apache HTTP Server.

If you are installing the Apache HTTP server and you want to be
able to compile or develop additional modules for Apache, you need
to install this package.

%package manual
Group: Documentation
Summary: Documentation for the Apache HTTP server.
Requires: httpd = %{version}-%{release}
Obsoletes: secureweb-manual, apache-manual

%description manual
The httpd-manual package contains the complete manual and
reference guide for the Apache HTTP server. The information can
also be found at http://httpd.apache.org/docs/2.2/.

%package -n mod_ssl
Group: System Environment/Daemons
Summary: SSL/TLS module for the Apache HTTP server
Epoch: 1
BuildRequires: openssl-devel >= %{opensslver}, distcache-devel
Requires(post): openssl >= 0.9.7f-4, /bin/cat
Requires: httpd = 0:%{version}-%{release}, httpd-mmn = %{mmn}
Requires: openssl >= %{opensslver}
Obsoletes: stronghold-mod_ssl

%description -n mod_ssl
The mod_ssl module provides strong cryptography for the Apache Web
server via the Secure Sockets Layer (SSL) and Transport Layer
Security (TLS) protocols.

%prep
%setup -q
%patch1 -p1 -b .apctl
%patch2 -p1 -b .apxs
%patch3 -p1 -b .deplibs
%patch4 -p1 -b .vpath
%patch5 -p1 -b .disablemods
%patch6 -p1 -b .layout

%patch21 -p1 -b .xfsz
%patch22 -p1 -b .pod
%patch23 -p1 -b .export
%patch24 -p1 -b .corelimit
%ifos linux
%patch25 -p1 -b .selinux
%endif
%patch26 -p1 -b .sslocsp

%patch40 -p1 -b .xpg4
%patch41 -p1 -b .windefs
%patch42 -p1 -b .winapr
%patch43 -p1 -b .expat1
%patch44 -p1 -b .apmonitor
%patch45 -p1 -b .windefs

%patch60 -p1 -b .logresline
%patch61 -p1 -b .defpidlog
%patch62 -p1 -b .extfiltereos
%patch63 -p1 -b .graceful-ebadf
%patch64 -p1 -b .noxpad
%patch65 -p1 -b .pngmagic
%patch68 -p1 -b .proxyconn
%patch70 -p1 -b .ssloidval
%patch71 -p1 -b .davputfail

%patch75 -p1 -b .bz48735
%patch77 -p1 -b .jbpapp3614

%patch79 -p1 -b .cve3368
%patch80 -p1 -b .apr
%patch81 -p1 -b .r815719+
%patch82 -p1 -b .cve20122687
%patch84 -p1 -b .r693108
%patch85 -p1 -b .cve20123499
%patch86 -p1 -b .cve20124558
%patch87 -p1 -b .ocspentrust
%patch88 -p1 -b .ocsptrust
%patch89 -p1 -b .cve1862
%patch90 -p1 -b .cve1896

# Patch in vendor/release string
sed "s/@VENDOR@/%{distro}/;s/@RELEASE@/%{version}-%{release}/" < %{PATCH20} | patch -p1 -b -z .release

# Safety check: prevent build if defined MMN does not equal upstream MMN.
vmmn=`echo MODULE_MAGIC_NUMBER_MAJOR | cpp -include include/ap_mmn.h | sed -n '/^2/p'`
if test "x${vmmn}" != "x%{mmn}"; then
   : Error: Upstream MMN is now ${vmmn}, packaged MMN is %{mmn}.
   : Update the mmn macro and rebuild.
   exit 1
fi

: Building for '%{distro}' with MMN %{mmn} and vendor string '%{vstring}'

# Fix for JBPAPP-3740
sed -i -e '/  Installation$/{N;N;N;N;N;d;}' README

%build
# forcibly prevent use of bundled apr, apr-util, pcre
rm -rf srclib/{apr,apr-util,pcre}

# regenerate configure scripts
autoheader && autoconf || exit 1

# Before configure; fix location of build dir in generated apxs
%{__perl} -pi -e "s:\@exp_installbuilddir\@:%{_libdir}/httpd/build:g" \
	support/apxs.in

CFLAGS="$RPM_OPT_FLAGS -Wformat-security -fno-strict-aliasing"
SH_LDFLAGS="-Wl,-z,relro"
export CFLAGS SH_LDFLAGS

# Hard-code path to links to avoid unnecessary builddep
export LYNX_PATH=/usr/bin/links

function mpmbuild()
{
mpm=$1; shift
mkdir $mpm; pushd $mpm
../configure \
 	--prefix=%{_sysconfdir}/httpd \
 	--exec-prefix=%{_prefix} \
 	--bindir=%{_bindir} \
 	--sbindir=%{_sbindir} \
 	--mandir=%{_mandir} \
	--libdir=%{_libdir} \
	--sysconfdir=%{_sysconfdir}/httpd/conf \
	--includedir=%{_includedir}/httpd \
	--libexecdir=%{_libdir}/httpd/modules \
	--datadir=%{contentdir} \
        --with-installbuilddir=%{_libdir}/httpd/build \
	--with-mpm=$mpm \
        --with-apr=%{_prefix} --with-apr-util=%{_prefix} \
	--enable-suexec --with-suexec \
	--with-suexec-caller=%{suexec_caller} \
	--with-suexec-docroot=%{contentdir} \
	--with-suexec-logfile=%{_localstatedir}/log/httpd/suexec.log \
	--with-suexec-bin=%{_sbindir}/suexec \
	--with-suexec-uidmin=500 --with-suexec-gidmin=100 \
        --enable-pie \
        --with-pcre \
	$*

make %{?_smp_mflags} EXTRA_CFLAGS="-Werror-implicit-function-declaration"
popd
}

# Build everything and the kitchen sink with the prefork build
mpmbuild prefork \
        --enable-mods-shared=all \
	--enable-ssl --with-ssl --enable-distcache \
	--enable-proxy \
        --enable-cache --enable-mem-cache \
        --enable-file-cache --enable-disk-cache \
        --enable-ldap --enable-authnz-ldap \
        --enable-cgid \
        --enable-authn-anon --enable-authn-alias

# For the other MPMs, just build httpd and no optional modules
mpmbuild worker --enable-modules=none
mpmbuild event --enable-modules=none

%install
rm -rf $RPM_BUILD_ROOT

# Classify ab and logresolve as section 1 commands, as they are in /usr/bin
mv docs/man/ab.8 docs/man/ab.1
mv docs/man/logresolve.8 docs/man/logresolve.1

pushd prefork
make DESTDIR=$RPM_BUILD_ROOT install
popd

# install alternative MPMs
install -m 755 worker/httpd $RPM_BUILD_ROOT%{_sbindir}/httpd.worker
install -m 755 event/httpd $RPM_BUILD_ROOT%{_sbindir}/httpd.event

# install conf file/directory
mkdir $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d
install -m 644 $RPM_SOURCE_DIR/README.confd \
    $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d/README
for f in ssl.conf welcome.conf manual.conf proxy_ajp.conf; do
  install -m 644 $RPM_SOURCE_DIR/$f $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d/$f
  %{__perl} -pi -e "s:\@installroot\@::g" \
     $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d/$f
done

rm $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf/*.conf
install -m 644 $RPM_SOURCE_DIR/httpd.conf \
   $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf/httpd.conf
%{__perl} -pi -e "s:\@installroot\@::g" \
   $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf/httpd.conf

mkdir $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
install -m 644 $RPM_SOURCE_DIR/httpd.sysconf \
   $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/httpd

# for holding mod_dav lock database
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lib/dav

# create a prototype session cache
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/cache/mod_ssl
touch $RPM_BUILD_ROOT%{_localstatedir}/cache/mod_ssl/scache.{dir,pag,sem}

# create cache root
mkdir $RPM_BUILD_ROOT%{_localstatedir}/cache/mod_proxy

%if %{with_zips}
mkdir -p httpd/{include,lib/build,sbin,cache/mod_ssl,conf,conf.d,logs,run,modules,www/html,www/error}
sed "s:@installroot@::g" $RPM_SOURCE_DIR/index.html > httpd/www/error/noindex.html
cp -r $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d/* httpd/conf.d/
cp -r $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf/{httpd.conf,magic} httpd/conf/
cp -r $RPM_BUILD_ROOT%{_localstatedir}/www/{cgi-bin,error,icons} httpd/www
cp -r $RPM_BUILD_ROOT%{_localstatedir}/cache/* httpd/cache/
cp -r $RPM_BUILD_ROOT%{_sbindir}/* httpd/sbin/
sed -e "s|/usr/sbin/httpd|./httpd|" -e "s|/etc/sysconfig/httpd|../conf/httpd.conf|" \
 $RPM_BUILD_ROOT%{_sbindir}/apachectl > httpd/sbin/apachectl
cp -r $RPM_BUILD_ROOT%{_libdir}/httpd/modules/* httpd/modules/
cp -r $RPM_BUILD_ROOT%{_libdir}/httpd/build/* httpd/lib/build/
cp -r $RPM_BUILD_ROOT%{_libdir}/* httpd/lib/
rm -fr httpd/lib/httpd
cp -r $RPM_BUILD_ROOT%{_includedir}/httpd/* httpd/include/

#JBPAPP-3635
rm httpd/sbin/{checkgid,envvars,envvars-std,dbmmanage}
zip -q -r httpd-%{version}.zip httpd
%endif

# move utilities to /usr/bin
mv $RPM_BUILD_ROOT%{_sbindir}/{ab,htdbm,logresolve,htpasswd,htdigest} \
   $RPM_BUILD_ROOT%{_bindir}

# Make the MMN accessible to module packages
echo %{mmn} > $RPM_BUILD_ROOT%{_includedir}/httpd/.mmn

# docroot
mkdir $RPM_BUILD_ROOT%{contentdir}/html
install -m 644 $RPM_SOURCE_DIR/index.html \
	$RPM_BUILD_ROOT%{contentdir}/error/noindex.html
%{__perl} -pi -e "s:\@installroot\@::g" \
   $RPM_BUILD_ROOT%{contentdir}/error/noindex.html

# remove manual sources
find $RPM_BUILD_ROOT%{contentdir}/manual \( \
    -name \*.xml -o -name \*.xml.* -o -name \*.ent -o -name \*.xsl -o -name \*.dtd \
    \) -print0 | xargs -0 rm -f

# Strip the manual down just to English and replace the typemaps with flat files:
set +x
for f in `find $RPM_BUILD_ROOT%{contentdir}/manual -name \*.html -type f`; do
   if test -f ${f}.en; then
      cp ${f}.en ${f}
      rm ${f}.*
   fi
done
set -x

# logs
rmdir $RPM_BUILD_ROOT%{_sysconfdir}/httpd/logs
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/httpd

# symlinks for /etc/httpd
ln -s ../..%{_localstatedir}/log/httpd $RPM_BUILD_ROOT/etc/httpd/logs
ln -s ../..%{_localstatedir}/run $RPM_BUILD_ROOT/etc/httpd/run
ln -s ../..%{_libdir}/httpd/modules $RPM_BUILD_ROOT/etc/httpd/modules

# install SYSV init stuff
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install -m755 $RPM_SOURCE_DIR/httpd.init \
	$RPM_BUILD_ROOT/etc/rc.d/init.d/httpd
%{__perl} -pi -e "s:\@docdir\@:%{_docdir}/%{name}-%{version}:g" \
	$RPM_BUILD_ROOT/etc/rc.d/init.d/httpd	

# install log rotation stuff
mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d
install -m644 $RPM_SOURCE_DIR/httpd.logrotate \
	$RPM_BUILD_ROOT/etc/logrotate.d/httpd

# fix man page paths
sed -e "s|/usr/local/apache2/conf/httpd.conf|/etc/httpd/conf/httpd.conf|" \
    -e "s|/usr/local/apache2/conf/mime.types|/etc/mime.types|" \
    -e "s|/usr/local/apache2/conf/magic|/etc/httpd/conf/magic|" \
    -e "s|/usr/local/apache2/logs/error_log|/var/log/httpd/error_log|" \
    -e "s|/usr/local/apache2/logs/access_log|/var/log/httpd/access_log|" \
    -e "s|/usr/local/apache2/logs/httpd.pid|/var/run/httpd.pid|" \
    -e "s|/usr/local/apache2|/etc/httpd|" < docs/man/httpd.8 \
  > $RPM_BUILD_ROOT%{_mandir}/man8/httpd.8

# Make ap_config_layout.h libdir-agnostic
sed -i '/.*DEFAULT_..._LIBEXECDIR/d;/DEFAULT_..._INSTALLBUILDDIR/d' \
    $RPM_BUILD_ROOT%{_includedir}/httpd/ap_config_layout.h

# Fix path to instdso in special.mk
sed -i '/instdso/s,top_srcdir,top_builddir,' \
    $RPM_BUILD_ROOT%{_libdir}/httpd/build/special.mk

# Remove unpackaged files
rm -f $RPM_BUILD_ROOT%{_libdir}/*.exp \
      $RPM_BUILD_ROOT/etc/httpd/conf/mime.types \
      $RPM_BUILD_ROOT%{_libdir}/httpd/modules/*.exp \
      $RPM_BUILD_ROOT%{_libdir}/httpd/build/config.nice \
      $RPM_BUILD_ROOT%{_bindir}/ap?-config \
      $RPM_BUILD_ROOT%{_sbindir}/{checkgid,dbmmanage,envvars*} \
      $RPM_BUILD_ROOT%{contentdir}/htdocs/* \
      $RPM_BUILD_ROOT%{_mandir}/man1/dbmmanage.* \
      $RPM_BUILD_ROOT%{contentdir}/cgi-bin/*

rm -rf $RPM_BUILD_ROOT/etc/httpd/conf/{original,extra}

# Make suexec a+rw so it can be stripped.  %%files lists real permissions
chmod 755 $RPM_BUILD_ROOT%{_sbindir}/suexec

%pre
# Add the "apache" user
/usr/sbin/useradd -c "Apache" -u 48 \
	-s /sbin/nologin -r -d %{contentdir} apache 2> /dev/null || :

%post
# Register the httpd service
/sbin/chkconfig --add httpd

%preun
if [ $1 = 0 ]; then
	/sbin/service httpd stop > /dev/null 2>&1
	/sbin/chkconfig --del httpd
fi

%define sslcert %{_sysconfdir}/pki/tls/certs/localhost.crt
%define sslkey %{_sysconfdir}/pki/tls/private/localhost.key

%post -n mod_ssl
umask 077

if [ ! -f %{sslkey} ] ; then
%{_bindir}/openssl genrsa -rand /proc/apm:/proc/cpuinfo:/proc/dma:/proc/filesystems:/proc/interrupts:/proc/ioports:/proc/pci:/proc/rtc:/proc/uptime 1024 > %{sslkey} 2> /dev/null
fi

FQDN=`hostname`
if [ "x${FQDN}" = "x" ]; then
   FQDN=localhost.localdomain
fi

if [ ! -f %{sslcert} ] ; then
cat << EOF | %{_bindir}/openssl req -new -key %{sslkey} \
         -x509 -days 365 -set_serial $RANDOM \
         -out %{sslcert} 2>/dev/null
--
SomeState
SomeCity
SomeOrganization
SomeOrganizationalUnit
${FQDN}
root@${FQDN}
EOF
fi

%check
# Check the built modules are all PIC
if readelf -d $RPM_BUILD_ROOT%{_libdir}/httpd/modules/*.so | grep TEXTREL; then
   : modules contain non-relocatable code
   exit 1
fi

# Verify that the same modules were built into the httpd binaries
./prefork/httpd -l | grep -v prefork > prefork.mods
for mpm in worker; do
  ./${mpm}/httpd -l | grep -v ${mpm} > ${mpm}.mods
  if ! diff -u prefork.mods ${mpm}.mods; then
    : Different modules built into httpd binaries, will not proceed
    exit 1
  fi
done

%if %{with_zips}
install -dm 755 $RPM_BUILD_ROOT/%{_javadir}/jbossas-fordev
# Copy over zip for the zip subpackage
install -m 644 httpd-%{version}.zip $RPM_BUILD_ROOT/%{_javadir}/jbossas-fordev/httpd-%{version}.zip
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)

%doc ABOUT_APACHE README CHANGES LICENSE VERSIONING NOTICE

%dir %{_sysconfdir}/httpd
%{_sysconfdir}/httpd/modules
%{_sysconfdir}/httpd/logs
%{_sysconfdir}/httpd/run
%dir %{_sysconfdir}/httpd/conf
%config %{_sysconfdir}/httpd/conf/httpd.conf
%config(noreplace) %{_sysconfdir}/httpd/conf.d/welcome.conf
%config(noreplace) %{_sysconfdir}/httpd/conf.d/proxy_ajp.conf
%config(noreplace) %{_sysconfdir}/httpd/conf/magic

%config(noreplace) %{_sysconfdir}/logrotate.d/httpd
%{_sysconfdir}/rc.d/init.d/httpd

%dir %{_sysconfdir}/httpd/conf.d
%{_sysconfdir}/httpd/conf.d/README

%config(noreplace) %{_sysconfdir}/sysconfig/httpd

%{_bindir}/*
%{_sbindir}/ht*
%{_sbindir}/apachectl
%{_sbindir}/rotatelogs
%attr(4510,root,%{suexec_caller}) %{_sbindir}/suexec

%dir %{_libdir}/httpd
%dir %{_libdir}/httpd/modules
%{_libdir}/httpd/modules/mod*.so
%exclude %{_libdir}/httpd/modules/mod_ssl.so

%dir %{contentdir}
%dir %{contentdir}/cgi-bin
%dir %{contentdir}/html
%dir %{contentdir}/icons
%dir %{contentdir}/error
%dir %{contentdir}/error/include
%{contentdir}/icons/*
%{contentdir}/error/README
%{contentdir}/error/noindex.html
%config %{contentdir}/error/*.var
%config %{contentdir}/error/include/*.html

%attr(0700,root,root) %dir %{_localstatedir}/log/httpd
%attr(0700,apache,apache) %dir %{_localstatedir}/lib/dav
%attr(0700,apache,apache) %dir %{_localstatedir}/cache/mod_proxy

%{_mandir}/man?/*
%exclude %{_mandir}/man8/apxs.8*

%files manual
%defattr(-,root,root)
%{contentdir}/manual
%config %{_sysconfdir}/httpd/conf.d/manual.conf

%files -n mod_ssl
%defattr(-,root,root)
%{_libdir}/httpd/modules/mod_ssl.so
%config(noreplace) %{_sysconfdir}/httpd/conf.d/ssl.conf
%attr(0700,apache,root) %dir %{_localstatedir}/cache/mod_ssl
%attr(0600,apache,root) %ghost %{_localstatedir}/cache/mod_ssl/scache.dir
%attr(0600,apache,root) %ghost %{_localstatedir}/cache/mod_ssl/scache.pag
%attr(0600,apache,root) %ghost %{_localstatedir}/cache/mod_ssl/scache.sem

%files devel
%defattr(-,root,root)
%{_includedir}/httpd
%{_sbindir}/apxs
%{_mandir}/man8/apxs.8*
%dir %{_libdir}/httpd/build
%{_libdir}/httpd/build/*.mk
%{_libdir}/httpd/build/*.sh

%if %{with_zips}
%files zip
%defattr(0644,root,root,0755)
%{_javadir}/jbossas-fordev/httpd-%{version}.zip
%endif

%changelog
* Thu Jul 25 2013 Mladen Turk <mturk@redhat.com> - 2.2.22-27
- CVE-2013-1862
- CVE-2013-1896

* Thu Jun 20 2013 Mladen Turk <mturk@redhat.com> - 2.2.22-26
- Rebuild

* Mon Jun 17 2013 Weinan Li <weli@redhat.com> - 2.2.22-23
- bz973189 

* Tue Jun  4 2013 Joe Orton <jorton@redhat.com> - 2.2.22-22
- mod_ssl: add "SSLOCSPResponderCertificateFile" config option
- fix init script handling in spec file
- Add patch for one-off: support the Tumbleweed OCSP responder

* Tue May 28 2013 Weinan Li <weli@redhat.com> - 2.2.22-20
- CVE2012-3499
- CVE2012-4558

* Tue May 14 2013 Permaine Cheung <pcheung@redhat.com> 2.2.22-19
- Add Obsoletes: in -devel to avoid running into BZ 892922 (yum trying to
  install httpd-devel.i386 from base without the requiried httpd)

* Wed May 08 2013 Weinan Li <weli@redhat.com> - 2.2.22-18
- relax checks for status-line validity #853128

* Thu May 02 2013 Weinan Li <weli@redhat.com> - 2.2.22-17
- generate src zip correctly

* Mon Apr 08 2013 Weinan Li <weli@redhat.com> - 2.2.22-16
- move httpd.init to correct position during build process

* Mon Apr 08 2013 Weinan Li <weli@redhat.com> - 2.2.22-15
- bz894955
- bz947391

* Wed Oct 17 2012 Weinan Li <weli@redhat.com> - 2.2.22-14
- More fix on JBPAPP-10212

* Tue Oct 16 2012 Weinan Li <weli@redhat.com> - 2.2.22-13
- JBPAPP-10212

* Fri Sep 21 2012 Weinan Li <weli@redhat.com> - 2.2.22-12
- JBPAPP-9446,9578

* Tue Sep 04 2012 Weinan Li <weli@redhat.com> - 2.2.22-11
- httpd-2.2.22-CVE-2012-2687.patch

* Thu Jul 12 2012 Joe Orton <jorton@redhat.com> - 2.2.22-10.1
- mod_ssl: pull latest upstream OCSP code (r815719+)
  Thanks to Joe Orton for providing the patch

* Mon Jul 09 2012 Weinan Li <weli@redhat.com> - 2.2.22-10
- Remove R apr-util-ldap because it's RHEL6 only

* Wed Jun 20 2012 Weinan Li <weli@redhat.com> - 2.2.22-9
- Fix incorrect src-zip

* Tue Jun 19 2012 Weinan Li <weli@redhat.com> - 2.2.22-8
- Bundle patched sources instead of the pristine one

* Wed May 23 2012 Weinan Li <weli@redhat.com> - 2.2.22-7
- JBPAPP-7633

* Tue May 01 2012 Weinan Li <weli@redhat.com> - 2.2.22-6
- Add var directory for zip

* Mon Apr 30 2012 Weinan Li <weli@redhat.com> - 2.2.22-5
- Add var directory

* Fri Apr 27 2012 Weinan Li <weli@redhat.com> - 2.2.22-4
- Fix src-zip package name

* Thu Apr 26 2012 Weinan Li <weli@redhat.com> - 2.2.22-3
- Add src-zip

* Mon Apr 23 2012 Weinan Li <weli@redhat.com> - 2.2.22-2
- Rebuild 2.2.22

* Wed Apr 04 2012 Weinan Li <weli@redhat.com> - 2.2.22-1
- Upgrade to 2.2.22

* Thu Feb 09 2012 Permaine Cheung <pcheung@redhat.com> - 2.2.17-15.4
- Update security fixes for CVE-2012-0021  (r1227292)

* Wed Feb 08 2012 Weinan Li <weli@redhat.com> - 2.2.17-15.2
- add security fixes for CVE-2012-0031, CVE-2012-0053 
- add security fixes for CVE-2011-4317, CVE-2011-3607 (#787598)
- obviates fix for CVE-2011-3368, patch removed

* Thu Oct 18 2011 Weinan Li <weli@redhat.com> - 2.2.17-15.1
- Update patch for CVE-2011-3192
- Add httpd-2.2.15-CVE-2011-3368.patch
- Add httpd-2.2.15-CVE-2011-3348.patch

* Wed Sep 07 2011 Weinan Li <weli@redhat.com> - 2.2.17-14.1
- updated patch for CVE-2011-3192

* Wed Aug 31 2011 Weinan Li <weli@redhat.com> - 2.2.17-13.1
- updated patch for CVE-2011-3192 from upstream (#733062)

* Fri Aug 30 2011 Weinan Li <weli@redhat.com> - 2.2.17-12.1
- fix #733062 -  backported CVE-2011-3192 fix from httpd trunk

* Mon Apr 18 2011 Permaine Cheung <pcheung@redhat.com> 2.2.17-11.1
- Add patch for JBPAPP-3614 and MODCLUSTER-226

* Fri Apr 01 2011 Permaine Cheung <pcheung@redhat.com> 2.2.17-10.1
- Add comment in conf file for use with mod_jk and mod_cluster (JBPAPP-6218)

* Mon Mar 07 2011 Permaine Cheung <pcheung@redhat.com> 2.2.17-9.1
- Add fix for bz48735
- Replace VENDOR properly

* Wed Mar 02 2011 Permaine Cheung <pcheung@redhat.com> 2.2.17-8.1
- Update index.html

* Wed Feb 23 2011 Permaine Cheung <pcheung@redhat.com> 2.2.17-7.1
- Fix patch for bz50481

* Wed Feb 23 2011 Permaine Cheung <pcheung@redhat.com> 2.2.17-5.1
- Apply fix for JBPAPP-5951 (apache issue 50481)

* Mon Feb 14 2011 Permaine Cheung <pcheung@redhat.com> 2.2.17-3.1
- Add noindex.html to zip

* Thu Jan 20 2011 Permaine Cheung <pcheung@redhat.com> 2.2.17-2.2
- Rebuild

* Wed Jan 12 2011 Permaine Cheung <pcheung@redhat.com> 2.2.17-2.1
- build the event MPM

* Thu Jan 06 2011 Permaine Cheung <pcheung@redhat.com> 2.2.17-1
- Update to 2.2.17
- Remove patches that are incorporated in this version
- Rediff patches

* Fri Oct 29 2010 Permaine Cheung <pcheung@redhat.com> 2.2.14-1.2.7
- Remove Installation section in README as it is not applicable
- Remove checkgid,envvars,envvars-std,dbmmanage from the zip
- Re-enable OCSP support for EWS 1.0.2

* Thu Apr 22 2010 Permaine Cheung <pcheung@redhat.com> 2.2.14-1.2.6
- Fix the sslreneg patch

* Thu Mar 25 2010 Permaine Cheung <pcheung@redhat.com> 2.2.14-1.2.5
- require and BR a version of OpenSSL with the secure reneg API (#567980)

* Fri Mar 12 2010 Permaine Cheung <pcheung@redhat.com> 2.2.14-1.2.4
- mod_ssl: add SSLInsecureRenegotiation

* Fri Mar 05 2010 Permaine Cheung <pcheung@redhat.com> 2.2.14-1.2.3
- Add security fixes for CVE-2010-0408, CVE-2010-0434
- Disable OCSP support until EWS 1.0.2

* Thu Feb 25 2010 Joe Orton <jorton@redhat.com> - 2.2.14-1.2.2
- mod_ssl: add OCSP support

* Tue Jan 12 2010  Permaine Cheung <pcheung@redhat.com> 2.2.14-1.2.1
- Merge with RHEL-4-EP-5 branch

* Fri Nov 13 2009 Permaine Cheung <pcheung@redhat.com> 2.2.10-11
- Add security fixes for CVE-2009-3555, CVE-2009-3094 and CVE-2009-3095

* Fri Jul  3 2009 Joe Orton <jorton@redhat.com> 2.2.10-10
- add security fixes for CVE-2009-1890, CVE-2009-1891

* Fri Jun 19 2009 Permaine Cheung <pcheung@redhat.com> 2.2.10-9
- Fix apachectl in rpm

* Tue Jun 16 2009 Permaine Cheung <pcheung@redhat.com> 2.2.10-8
- Fix apachectl in zip

* Wed Jun 10 2009 Permaine Cheung <pcheung@redhat.com> 2.2.10-7
- Updated patch for CVE-2009-1195 from Joe Orton

* Mon Jun 08 2009 Permaine Cheung <pcheung@redhat.com> 2.2.10-5
- Add patch for CVE-2009-1195 (BZ 489436)

* Thu Apr 23 2009 Permaine Cheung <pcheung@redhat.com> 2.2.10-4
- Add patch for CVE-2009-1191 (BZ 496801)

* Sat Feb 28 2009 Permaine Cheung <pcheung@redhat.com> 2.2.10-3
- Add zip

* Mon Nov 17 2008 Permaine Cheung <pcheung@redhat.com> 2.2.10-2
- Back port patch for IT 231340

* Fri Oct 24 2008 Joe Orton <jorton@redhat.com> 2.2.10-1.el5s2
- update to 2.2.10

* Mon Oct 20 2008 Joe Orton <jorton@redhat.com> 2.2.9-1.el5s2
- update to 2.2.9

* Wed Feb 20 2008 Joe Orton <jorton@redhat.com> 2.2.8-1.el5s2
- update to 2.2.8

* Wed Jan 16 2008 Joe Orton <jorton@redhat.com> 2.2.4-9.el5s2
- updated backport for CVE-2007-6421 (#427239)

* Tue Jan  8 2008 Joe Orton <jorton@redhat.com> 2.2.4-8.el5s2
- add security fix for CVE-2007-5000 (#421661)
- add security fixes for CVE-2007-6388, CVE-2007-6421,
  CVE-2007-6422 (#427239)
- add security fix for CVE-2008-0005 (#427741)

* Tue Sep 18 2007 Joe Orton <jorton@redhat.com> 2.2.4-7.el5s2
- add security fix for CVE-2007-4465 (#294451)

* Thu Sep  6 2007 Joe Orton <jorton@redhat.com> 2.2.4-6.el5s2
- add security fix for CVE-2007-3847 (#251114)

* Thu Jun 28 2007 Joe Orton <jorton@redhat.com> 2.2.4-5.el5s2
- add security fixes for CVE-2007-1863, CVE-2007-3304,
  CVE-2006-5752, CVE-2007-1862 (#245127)

* Thu Apr 19 2007 Joe Orton <jorton@redhat.com> 2.2.4-4.el5s2
- branding fixes

* Thu Apr 19 2007 Joe Orton <jorton@redhat.com> 2.2.4-3.el5s2
- rebuild

* Tue Apr  3 2007 Joe Orton <jorton@redhat.com> 2.2.4-3
- drop old triggers, old Requires, xmlto BR
- use Requires(...) correctly 
- use standard BuildRoot 
- don't mark init script as config file
- trim CHANGES further

* Mon Mar 12 2007 Joe Orton <jorton@redhat.com> 2.2.4-2
- update to 2.2.4
- drop the migration guide (#223605)

* Thu Dec  7 2006 Joe Orton <jorton@redhat.com> 2.2.3-8
- fix path to instdso.sh in special.mk (#217677)
- fix detection of links in "apachectl fullstatus"

* Tue Dec  5 2006 Joe Orton <jorton@redhat.com> 2.2.3-7
- rebuild for libpq soname bump

* Sat Nov 11 2006 Joe Orton <jorton@redhat.com> 2.2.3-6
- rebuild for BDB soname bump

* Mon Sep 11 2006 Joe Orton <jorton@redhat.com> 2.2.3-5
- updated "powered by Fedora" logo (#205573, Diana Fong)
- tweak welcome page wording slightly (#205880)

* Fri Aug 18 2006 Jesse Keating <jkeating@redhat.com> - 2.2.3-4
- rebuilt with latest binutils to pick up 64K -z commonpagesize on ppc*
  (#203001)

* Thu Aug  3 2006 Joe Orton <jorton@redhat.com> 2.2.3-3
- init: use killproc() delay to avoid race killing parent

* Fri Jul 28 2006 Joe Orton <jorton@redhat.com> 2.2.3-2
- update to 2.2.3
- trim %%changelog to >=2.0.52

* Thu Jul 20 2006 Joe Orton <jorton@redhat.com> 2.2.2-8
- fix segfault on dummy connection failure at graceful restart (#199429)

* Wed Jul 19 2006 Joe Orton <jorton@redhat.com> 2.2.2-7
- fix "apxs -g"-generated Makefile
- fix buildconf with autoconf 2.60

* Wed Jul 12 2006 Jesse Keating <jkeating@redhat.com> - 2.2.2-5.1
- rebuild

* Wed Jun  7 2006 Joe Orton <jorton@redhat.com> 2.2.2-5
- require pkgconfig for -devel (#194152)
- fixes for installed support makefiles (special.mk et al)
- BR autoconf

* Fri Jun  2 2006 Joe Orton <jorton@redhat.com> 2.2.2-4
- make -devel package multilib-safe (#192686)

* Thu May 11 2006 Joe Orton <jorton@redhat.com> 2.2.2-3
- build DSOs using -z relro linker flag

* Wed May  3 2006 Joe Orton <jorton@redhat.com> 2.2.2-2
- update to 2.2.2

* Thu Apr  6 2006 Joe Orton <jorton@redhat.com> 2.2.0-6
- rebuild to pick up apr-util LDAP interface fix (#188073)

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - (none):2.2.0-5.1.2
- bump again for double-long bug on ppc(64)

* Tue Feb 07 2006 Jesse Keating <jkeating@redhat.com> - (none):2.2.0-5.1.1
- rebuilt for new gcc4.1 snapshot and glibc changes

* Mon Feb  6 2006 Joe Orton <jorton@redhat.com> 2.2.0-5.1
- mod_auth_basic/mod_authn_file: if no provider is configured,
  and AuthUserFile is not configured, decline to handle authn
  silently rather than failing noisily.

* Fri Feb  3 2006 Joe Orton <jorton@redhat.com> 2.2.0-5
- mod_ssl: add security fix for CVE-2005-3357 (#177914)
- mod_imagemap: add security fix for CVE-2005-3352 (#177913)
- add fix for AP_INIT_* designated initializers with C++ compilers
- httpd.conf: enable HTMLTable in default IndexOptions
- httpd.conf: add more "redirect-carefully" matches for DAV clients

* Thu Jan  5 2006 Joe Orton <jorton@redhat.com> 2.2.0-4
- mod_proxy_ajp: fix Cookie handling (Mladen Turk, r358769)

* Fri Dec 09 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt

* Wed Dec  7 2005 Joe Orton <jorton@redhat.com> 2.2.0-3
- strip manual to just English content

* Mon Dec  5 2005 Joe Orton <jorton@redhat.com> 2.2.0-2
- don't strip C-L from HEAD responses (Greg Ames, #110552)
- load mod_proxy_balancer by default
- add proxy_ajp.conf to load/configure mod_proxy_ajp
- Obsolete mod_jk
- update docs URLs in httpd.conf/ssl.conf

* Fri Dec  2 2005 Joe Orton <jorton@redhat.com> 2.2.0-1
- update to 2.2.0

* Wed Nov 30 2005 Joe Orton <jorton@redhat.com> 2.1.10-2
- enable mod_authn_alias, mod_authn_anon
- update default httpd.conf

* Fri Nov 25 2005 Joe Orton <jorton@redhat.com> 2.1.10-1
- update to 2.1.10
- require apr >= 1.2.0, apr-util >= 1.2.0

* Wed Nov  9 2005 Tomas Mraz <tmraz@redhat.com> 2.0.54-16
- rebuilt against new openssl

* Thu Nov  3 2005 Joe Orton <jorton@redhat.com> 2.0.54-15
- log notice giving SELinux context at startup if enabled
- drop SSLv2 and restrict default cipher suite in default
 SSL configuration

* Thu Oct 20 2005 Joe Orton <jorton@redhat.com> 2.0.54-14
- mod_ssl: add security fix for SSLVerifyClient (CVE-2005-2700)
- add security fix for byterange filter DoS (CVE-2005-2728)
- add security fix for C-L vs T-E handling (CVE-2005-2088)
- mod_ssl: add security fix for CRL overflow (CVE-2005-1268)
- mod_ldap/mod_auth_ldap: add fixes from 2.0.x branch (upstream #34209 etc)
- add fix for dummy connection handling (#167425)
- mod_auth_digest: fix hostinfo comparison in CONNECT requests
- mod_include: fix variable corruption in nested includes (upstream #12655)
- mod_ssl: add fix for handling non-blocking reads
- mod_ssl: fix to enable output buffering (upstream #35279)
- mod_ssl: buffer request bodies for per-location renegotiation (upstream #12355)

* Sat Aug 13 2005 Joe Orton <jorton@redhat.com> 2.0.54-13
- don't load by default: mod_cern_meta, mod_asis
- do load by default: mod_ext_filter (#165893)

* Thu Jul 28 2005 Joe Orton <jorton@redhat.com> 2.0.54-12
- drop broken epoch deps

* Thu Jun 30 2005 Joe Orton <jorton@redhat.com> 2.0.54-11
- mod_dav_fs: fix uninitialized variable (#162144)
- add epoch to dependencies as appropriate
- mod_ssl: drop dependencies on dev, make
- mod_ssl: mark post script dependencies as such

* Mon May 23 2005 Joe Orton <jorton@redhat.com> 2.0.54-10
- remove broken symlink (Robert Scheck, #158404)

* Wed May 18 2005 Joe Orton <jorton@redhat.com> 2.0.54-9
- add piped logger fixes (w/Jeff Trawick)

* Mon May  9 2005 Joe Orton <jorton@redhat.com> 2.0.54-8
- drop old "powered by Red Hat" logos

* Wed May  4 2005 Joe Orton <jorton@redhat.com> 2.0.54-7
- mod_userdir: fix memory allocation issue (upstream #34588)
- mod_ldap: fix memory corruption issue (Brad Nicholes, upstream #34618)

* Tue Apr 26 2005 Joe Orton <jorton@redhat.com> 2.0.54-6
- fix key/cert locations in post script

* Mon Apr 25 2005 Joe Orton <jorton@redhat.com> 2.0.54-5
- create default dummy cert in /etc/pki/tls
- use a pseudo-random serial number on the dummy cert
- change default ssl.conf to point at /etc/pki/tls
- merge back -suexec subpackage; SELinux policy can now be
  used to persistently disable suexec (#155716)
- drop /etc/httpd/conf/ssl.* directories and Makefiles
- unconditionally enable PIE support
- mod_ssl: fix for picking up -shutdown options (upstream #34452)

* Mon Apr 18 2005 Joe Orton <jorton@redhat.com> 2.0.54-4
- replace PreReq with Requires(pre) 

* Mon Apr 18 2005 Joe Orton <jorton@redhat.com> 2.0.54-3
- update to 2.0.54

* Tue Mar 29 2005 Joe Orton <jorton@redhat.com> 2.0.53-6
- update default httpd.conf:
 * clarify the comments on AddDefaultCharset usage (#135821)
 * remove all the AddCharset default extensions
 * don't load mod_imap by default
 * synch with upstream 2.0.53 httpd-std.conf
- mod_ssl: set user from SSLUserName in access hook (upstream #31418)
- htdigest: fix permissions of created files (upstream #33765)
- remove htsslpass

* Wed Mar  2 2005 Joe Orton <jorton@redhat.com> 2.0.53-5
- apachectl: restore use of $OPTIONS again

* Wed Feb  9 2005 Joe Orton <jorton@redhat.com> 2.0.53-4
- update to 2.0.53
- move prefork/worker modules comparison to %%check

* Mon Feb  7 2005 Joe Orton <jorton@redhat.com> 2.0.52-7
- fix cosmetic issues in "service httpd reload"
- move User/Group higher in httpd.conf (#146793)
- load mod_logio by default in httpd.conf
- apachectl: update for correct libselinux tools locations

* Tue Nov 16 2004 Joe Orton <jorton@redhat.com> 2.0.52-6
- add security fix for CVE CAN-2004-0942 (memory consumption DoS)
- SELinux: run httpd -t under runcon in configtest (Steven Smalley)
- fix SSLSessionCache comment for distcache in ssl.conf
- restart using SIGHUP not SIGUSR1 after logrotate
- add ap_save_brigade fix (upstream #31247)
- mod_ssl: fix possible segfault in auth hook (upstream #31848)
- add htsslpass(1) and configure as default SSLPassPhraseDialog (#128677)
- apachectl: restore use of $OPTIONS
- apachectl, httpd.init: refuse to restart if $HTTPD -t fails
- apachectl: run $HTTPD -t in user SELinux context for configtest
- update for pcre-5.0 header locations

* Sat Nov 13 2004 Jeff Johnson <jbj@redhat.com> 2.0.52-5
- rebuild against db-4.3.21 aware apr-util.

* Thu Nov 11 2004 Jeff Johnson <jbj@jbj.org> 2.0.52-4
- rebuild against db-4.3-21.

* Thu Sep 28 2004 Joe Orton <jorton@redhat.com> 2.0.52-3
- add dummy connection address fixes from HEAD
- mod_ssl: add security fix for CAN-2004-0885

* Tue Sep 28 2004 Joe Orton <jorton@redhat.com> 2.0.52-2
- update to 2.0.52
