package loginmodule.custom;

import java.security.Principal;

public class MyPrincipal implements Principal {

  private final String name;
  
  public MyPrincipal(String name) {
    if (name == null) {
      throw new IllegalArgumentException("name cannot be null");
    }
    this.name = name;
  }
  
  public String getName() {
    return name;
  }
  
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if ((o == null) || (getClass() != o.getClass())) {
      return false;
    }
    MyPrincipal that = (MyPrincipal)o;
    if (!name.equals(name)) {
      return false;
    }
    return true;
  }
  
  public int hashCode() {
    return name.hashCode();
  }
  
  public String toString() {
    return getClass().getName() + ":" + getName();
  }
}
