/**
 *  Copyright 2005-2016 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package io.fabric8.api;

import java.util.HashMap;
import java.util.Map;

public class CreateContainerBasicMetadata<O extends CreateContainerOptions> implements CreateContainerMetadata<O> {

    static final long serialVersionUID = 7432148266874950445L;

    private String containerName = "<not available>";
    private O createOptions;
    private transient Throwable failure;
    private transient Container container;
    private String overridenResolver;
    private String containerType = "karaf";
    private final Map<String,String> containerConfiguration = new HashMap<String, String>();

    public boolean isSuccess() {
        return failure == null;
    }

    public Throwable getFailure() {
        return failure;
    }

    public void setFailure(Throwable failure) {
        this.failure = failure;
    }

    public String getContainerName() {
        return containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    @Override
    public String getContainerType() {
        return containerType;
    }

    @Override
    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public Container getContainer() {
        return container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public O getCreateOptions() {
        return createOptions;
    }

    public void setCreateOptions(CreateContainerOptions createOptions) {
        this.createOptions = (O) createOptions;
    }

    @Override
    public Map<String, String> getContainerConfiguration() {
        return containerConfiguration;
    }

    public String getOverridenResolver() {
        return overridenResolver;
    }

    @Override
    public void updateCredentials(String user, String credential) {
        this.createOptions = (O) createOptions.updateCredentials(user, credential);
    }

    public void setOverridenResolver(String overridenResolver) {
        this.overridenResolver = overridenResolver;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Container: ").append(containerName).append(".");
        O createOptions = getCreateOptions();
        if (createOptions != null && createOptions.isEnsembleServer() && createOptions.getZookeeperPassword() != null) {
            sb.append("Registry Password: ").append(createOptions.getZookeeperPassword());
        }
        return  sb.toString();
    }
}
