package org.jboss.qe.camel.components.ejb.subB;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;

import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
public class TransactedRouteCaller extends AbstractTransactionEjb {

	@Resource(name = "java:jboss/camel/context/transaction-ejb-test")
	private CamelContext context;

	public void startRouteSingleTransaction(String payload) throws Exception {
		start(payload, "direct:toRoutePropagatedSingleTransactionTest");
	}

	public void startRouteSingleTransactionRollback(String payload) throws Exception {
		start(payload, "direct:toRoutePropagatedSingleTransactionRollbackTest");
	}

	public void startRouteNewTransactionRollback(String payload) throws Exception {
		start(payload, "direct:toRouteNewTransactionRollbackTest");
	}

	private void start(String payload, String endpoint) throws Exception {

		accept(payload); // send message to JMS

		final ProducerTemplate producer = context.createProducerTemplate();
		producer.start();
		producer.sendBody(endpoint, payload);
	}

	@Override
	public void accept(String message) throws Exception {
		sendMessage(message);
	}
}
