/*
 * Copyright 2017 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */
package org.jbosson.plugins.fuse;

import java.io.File;
import java.util.HashMap;

import com.fasterxml.jackson.databind.ObjectMapper;
import junit.framework.TestCase;


public class JBossFuseProfileGroupManagerTest extends TestCase {
    
    public void testGetJsonEntry() throws Exception {
        JBossFuseProfileGroupManager jBossFuseProfileGroupManager = new JBossFuseProfileGroupManager(null);
        File configFile = new File(this.getClass().getClassLoader().getResource("failover-list.dat").toURI());
        String jsonEntry = jBossFuseProfileGroupManager.getJsonEntry(configFile);
        ObjectMapper mapper = new ObjectMapper();
        //Insure no error is thrown when deserializing
        mapper.readValue(jsonEntry.getBytes(), HashMap.class);
        assertEquals("{\"id\":\"jon\",\"services\":[\"http(s)://localhost.localdomain:7080/7443 /rest\",\"http(s)://localhost2.localdomain:7080/7443 /rest\"]}", jsonEntry);
    }

}